/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import jakarta.persistence.Timeout;
import org.hibernate.Incubating;

@Incubating
public interface Timeouts {
    public static final int NO_WAIT_MILLI = 0;
    public static final int WAIT_FOREVER_MILLI = -1;
    public static final int SKIP_LOCKED_MILLI = -2;
    public static final Timeout NO_WAIT;
    public static final Timeout WAIT_FOREVER;
    public static final Timeout SKIP_LOCKED;

    public static Timeout interpretMilliSeconds(int timeoutInMilliseconds) {
        return switch (timeoutInMilliseconds) {
            case 0 -> NO_WAIT;
            case -1 -> WAIT_FOREVER;
            case -2 -> SKIP_LOCKED;
            default -> Timeout.milliseconds((int)timeoutInMilliseconds);
        };
    }

    public static boolean isRealTimeout(Timeout timeout) {
        return Timeouts.isRealTimeout(timeout.milliseconds());
    }

    public static boolean isRealTimeout(int timeoutInMilliseconds) {
        return timeoutInMilliseconds > 0;
    }

    public static int getTimeoutInSeconds(Timeout timeout) {
        return Timeouts.getTimeoutInSeconds(timeout.milliseconds());
    }

    public static int getTimeoutInSeconds(int timeoutInMilliseconds) {
        if (!1.$assertionsDisabled && timeoutInMilliseconds < 0) {
            throw new AssertionError();
        }
        return timeoutInMilliseconds == 0 ? 0 : Math.max(1, Math.round((float)timeoutInMilliseconds / 1000.0f));
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        NO_WAIT = Timeout.milliseconds((int)0);
        WAIT_FOREVER = Timeout.milliseconds((int)-1);
        SKIP_LOCKED = Timeout.milliseconds((int)-2);
    }
}

