/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.annotations;

import org.hibernate.cache.spi.access.AccessType;

public enum CacheConcurrencyStrategy {
    NONE,
    READ_ONLY,
    NONSTRICT_READ_WRITE,
    READ_WRITE,
    TRANSACTIONAL;


    public AccessType toAccessType() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case NONE -> null;
            case READ_ONLY -> AccessType.READ_ONLY;
            case NONSTRICT_READ_WRITE -> AccessType.NONSTRICT_READ_WRITE;
            case READ_WRITE -> AccessType.READ_WRITE;
            case TRANSACTIONAL -> AccessType.TRANSACTIONAL;
        };
    }

    public static CacheConcurrencyStrategy fromAccessType(AccessType accessType) {
        if (accessType == null) {
            return NONE;
        }
        return switch (accessType) {
            default -> throw new IncompatibleClassChangeError();
            case AccessType.READ_ONLY -> READ_ONLY;
            case AccessType.READ_WRITE -> READ_WRITE;
            case AccessType.NONSTRICT_READ_WRITE -> NONSTRICT_READ_WRITE;
            case AccessType.TRANSACTIONAL -> TRANSACTIONAL;
        };
    }

    public static CacheConcurrencyStrategy parse(String name) {
        for (CacheConcurrencyStrategy strategy : CacheConcurrencyStrategy.values()) {
            if (!strategy.isMatch(name)) continue;
            return strategy;
        }
        return null;
    }

    private boolean isMatch(String name) {
        AccessType accessType = this.toAccessType();
        return accessType != null && accessType.getExternalName().equalsIgnoreCase(name) || this.name().equalsIgnoreCase(name);
    }
}

