/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.boot.SessionFactoryBuilder;
import org.hibernate.boot.model.IdentifierGeneratorDefinition;
import org.hibernate.boot.model.NamedEntityGraphDefinition;
import org.hibernate.boot.model.TypeDefinition;
import org.hibernate.boot.model.relational.ColumnOrderingStrategy;
import org.hibernate.boot.model.relational.ColumnOrderingStrategyLegacy;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.boot.model.relational.Sequence;
import org.hibernate.boot.query.NamedHqlQueryDefinition;
import org.hibernate.boot.query.NamedNativeQueryDefinition;
import org.hibernate.boot.query.NamedProcedureCallDefinition;
import org.hibernate.boot.query.NamedResultSetMappingDescriptor;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.MetadataBuildingOptions;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.boot.spi.SessionFactoryBuilderFactory;
import org.hibernate.boot.spi.SessionFactoryBuilderImplementor;
import org.hibernate.boot.spi.SessionFactoryBuilderService;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.FetchProfile;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UserDefinedObjectType;
import org.hibernate.mapping.UserDefinedType;
import org.hibernate.metamodel.mapping.DiscriminatorType;
import org.hibernate.query.internal.NamedObjectRepositoryImpl;
import org.hibernate.query.named.NamedObjectRepository;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.tool.schema.Action;
import org.hibernate.tool.schema.spi.SchemaManagementToolCoordinator;
import org.hibernate.type.Type;
import org.hibernate.type.spi.TypeConfiguration;

public class MetadataImpl
implements MetadataImplementor,
Serializable {
    private final UUID uuid;
    private final MetadataBuildingOptions metadataBuildingOptions;
    private final BootstrapContext bootstrapContext;
    private final Map<String, PersistentClass> entityBindingMap;
    private final List<Component> composites;
    private final Map<Class<?>, Component> genericComponentsMap;
    private final Map<Class<?>, DiscriminatorType<?>> embeddableDiscriminatorTypesMap;
    private final Map<Class<?>, MappedSuperclass> mappedSuperclassMap;
    private final Map<String, org.hibernate.mapping.Collection> collectionBindingMap;
    private final Map<String, TypeDefinition> typeDefinitionMap;
    private final Map<String, FilterDefinition> filterDefinitionMap;
    private final Map<String, FetchProfile> fetchProfileMap;
    private final Map<String, String> imports;
    private final Map<String, IdentifierGeneratorDefinition> idGeneratorDefinitionMap;
    private final Map<String, NamedHqlQueryDefinition<?>> namedQueryMap;
    private final Map<String, NamedNativeQueryDefinition<?>> namedNativeQueryMap;
    private final Map<String, NamedProcedureCallDefinition> namedProcedureCallMap;
    private final Map<String, NamedResultSetMappingDescriptor> sqlResultSetMappingMap;
    private final Map<String, NamedEntityGraphDefinition> namedEntityGraphMap;
    private final Map<String, SqmFunctionDescriptor> sqlFunctionMap;
    private final Database database;

    public MetadataImpl(UUID uuid, MetadataBuildingOptions metadataBuildingOptions, Map<String, PersistentClass> entityBindingMap, List<Component> composites, Map<Class<?>, Component> genericComponentsMap, Map<Class<?>, DiscriminatorType<?>> embeddableDiscriminatorTypesMap, Map<Class<?>, MappedSuperclass> mappedSuperclassMap, Map<String, org.hibernate.mapping.Collection> collectionBindingMap, Map<String, TypeDefinition> typeDefinitionMap, Map<String, FilterDefinition> filterDefinitionMap, Map<String, FetchProfile> fetchProfileMap, Map<String, String> imports, Map<String, IdentifierGeneratorDefinition> idGeneratorDefinitionMap, Map<String, NamedHqlQueryDefinition<?>> namedQueryMap, Map<String, NamedNativeQueryDefinition<?>> namedNativeQueryMap, Map<String, NamedProcedureCallDefinition> namedProcedureCallMap, Map<String, NamedResultSetMappingDescriptor> sqlResultSetMappingMap, Map<String, NamedEntityGraphDefinition> namedEntityGraphMap, Map<String, SqmFunctionDescriptor> sqlFunctionMap, Database database, BootstrapContext bootstrapContext) {
        this.uuid = uuid;
        this.metadataBuildingOptions = metadataBuildingOptions;
        this.entityBindingMap = entityBindingMap;
        this.composites = composites;
        this.genericComponentsMap = genericComponentsMap;
        this.embeddableDiscriminatorTypesMap = embeddableDiscriminatorTypesMap;
        this.mappedSuperclassMap = mappedSuperclassMap;
        this.collectionBindingMap = collectionBindingMap;
        this.typeDefinitionMap = typeDefinitionMap;
        this.filterDefinitionMap = filterDefinitionMap;
        this.fetchProfileMap = fetchProfileMap;
        this.imports = imports;
        this.idGeneratorDefinitionMap = idGeneratorDefinitionMap;
        this.namedQueryMap = namedQueryMap;
        this.namedNativeQueryMap = namedNativeQueryMap;
        this.namedProcedureCallMap = namedProcedureCallMap;
        this.sqlResultSetMappingMap = sqlResultSetMappingMap;
        this.namedEntityGraphMap = namedEntityGraphMap;
        this.sqlFunctionMap = sqlFunctionMap;
        this.database = database;
        this.bootstrapContext = bootstrapContext;
    }

    @Override
    public MetadataBuildingOptions getMetadataBuildingOptions() {
        return this.metadataBuildingOptions;
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.bootstrapContext.getTypeConfiguration();
    }

    @Override
    public SqmFunctionRegistry getFunctionRegistry() {
        return this.bootstrapContext.getFunctionRegistry();
    }

    @Override
    public SessionFactoryBuilder getSessionFactoryBuilder() {
        SessionFactoryBuilderImplementor defaultBuilder = this.getFactoryBuilder();
        SessionFactoryBuilder builder = null;
        ArrayList<String> activeFactoryNames = null;
        for (SessionFactoryBuilderFactory discoveredBuilderFactory : this.getSessionFactoryBuilderFactories()) {
            SessionFactoryBuilder returnedBuilder = discoveredBuilderFactory.getSessionFactoryBuilder(this, defaultBuilder);
            if (returnedBuilder == null) continue;
            if (activeFactoryNames == null) {
                activeFactoryNames = new ArrayList<String>();
            }
            activeFactoryNames.add(discoveredBuilderFactory.getClass().getName());
            builder = returnedBuilder;
        }
        if (activeFactoryNames != null && activeFactoryNames.size() > 1) {
            throw new HibernateException("Multiple active SessionFactoryBuilderFactory definitions were discovered: " + String.join((CharSequence)", ", (Iterable<? extends CharSequence>)activeFactoryNames));
        }
        return builder == null ? defaultBuilder : builder;
    }

    private Iterable<SessionFactoryBuilderFactory> getSessionFactoryBuilderFactories() {
        return this.getClassLoaderService().loadJavaServices(SessionFactoryBuilderFactory.class);
    }

    private SessionFactoryBuilderImplementor getFactoryBuilder() {
        return this.metadataBuildingOptions.getServiceRegistry().requireService(SessionFactoryBuilderService.class).createSessionFactoryBuilder(this, this.bootstrapContext);
    }

    private ClassLoaderService getClassLoaderService() {
        return this.metadataBuildingOptions.getServiceRegistry().requireService(ClassLoaderService.class);
    }

    @Override
    public SessionFactoryImplementor buildSessionFactory() {
        return (SessionFactoryImplementor)this.getSessionFactoryBuilder().build();
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public Database getDatabase() {
        return this.database;
    }

    @Override
    public Collection<PersistentClass> getEntityBindings() {
        return this.entityBindingMap.values();
    }

    @Override
    public PersistentClass getEntityBinding(String entityName) {
        return this.entityBindingMap.get(entityName);
    }

    @Override
    public Collection<org.hibernate.mapping.Collection> getCollectionBindings() {
        return this.collectionBindingMap.values();
    }

    @Override
    public org.hibernate.mapping.Collection getCollectionBinding(String role) {
        return this.collectionBindingMap.get(role);
    }

    @Override
    public Map<String, String> getImports() {
        return this.imports;
    }

    @Override
    public NamedHqlQueryDefinition<?> getNamedHqlQueryMapping(String name) {
        return this.namedQueryMap.get(name);
    }

    @Override
    public void visitNamedHqlQueryDefinitions(Consumer<NamedHqlQueryDefinition<?>> definitionConsumer) {
        this.namedQueryMap.values().forEach(definitionConsumer);
    }

    @Override
    public NamedNativeQueryDefinition<?> getNamedNativeQueryMapping(String name) {
        return this.namedNativeQueryMap.get(name);
    }

    @Override
    public void visitNamedNativeQueryDefinitions(Consumer<NamedNativeQueryDefinition<?>> definitionConsumer) {
        this.namedNativeQueryMap.values().forEach(definitionConsumer);
    }

    @Override
    public NamedProcedureCallDefinition getNamedProcedureCallMapping(String name) {
        return this.namedProcedureCallMap.get(name);
    }

    @Override
    public void visitNamedProcedureCallDefinition(Consumer<NamedProcedureCallDefinition> definitionConsumer) {
        this.namedProcedureCallMap.values().forEach(definitionConsumer);
    }

    @Override
    public NamedResultSetMappingDescriptor getResultSetMapping(String name) {
        return this.sqlResultSetMappingMap.get(name);
    }

    @Override
    public void visitNamedResultSetMappingDefinition(Consumer<NamedResultSetMappingDescriptor> definitionConsumer) {
        this.sqlResultSetMappingMap.values().forEach(definitionConsumer);
    }

    @Override
    public TypeDefinition getTypeDefinition(String typeName) {
        return this.typeDefinitionMap.get(typeName);
    }

    @Override
    public Map<String, FilterDefinition> getFilterDefinitions() {
        return this.filterDefinitionMap;
    }

    @Override
    public FilterDefinition getFilterDefinition(String name) {
        return this.filterDefinitionMap.get(name);
    }

    @Override
    public FetchProfile getFetchProfile(String name) {
        return this.fetchProfileMap.get(name);
    }

    @Override
    public Collection<FetchProfile> getFetchProfiles() {
        return this.fetchProfileMap.values();
    }

    @Override
    public NamedEntityGraphDefinition getNamedEntityGraph(String name) {
        return this.namedEntityGraphMap.get(name);
    }

    @Override
    public Map<String, NamedEntityGraphDefinition> getNamedEntityGraphs() {
        return this.namedEntityGraphMap;
    }

    @Override
    public IdentifierGeneratorDefinition getIdentifierGenerator(String name) {
        return this.idGeneratorDefinitionMap.get(name);
    }

    @Override
    public Map<String, SqmFunctionDescriptor> getSqlFunctionMap() {
        return this.sqlFunctionMap;
    }

    @Override
    public Set<String> getContributors() {
        HashSet<String> contributors = new HashSet<String>();
        this.entityBindingMap.forEach((s, persistentClass) -> contributors.add(persistentClass.getContributor()));
        for (Namespace namespace : this.database.getNamespaces()) {
            for (Table table : namespace.getTables()) {
                contributors.add(table.getContributor());
            }
            for (Sequence sequence : namespace.getSequences()) {
                contributors.add(sequence.getContributor());
            }
        }
        return contributors;
    }

    @Override
    public Collection<Table> collectTableMappings() {
        ArrayList<Table> tables = new ArrayList<Table>();
        for (Namespace namespace : this.database.getNamespaces()) {
            tables.addAll(namespace.getTables());
        }
        return tables;
    }

    @Override
    public NamedObjectRepository buildNamedQueryRepository() {
        return new NamedObjectRepositoryImpl(CollectionHelper.mapOfSize(this.namedQueryMap.size()), CollectionHelper.mapOfSize(this.namedNativeQueryMap.size()), CollectionHelper.mapOfSize(this.namedProcedureCallMap.size()), CollectionHelper.mapOfSize(this.sqlResultSetMappingMap.size()));
    }

    @Override
    public void orderColumns(boolean forceOrdering) {
        ColumnOrderingStrategy columnOrderingStrategy = this.metadataBuildingOptions.getColumnOrderingStrategy();
        if (columnOrderingStrategy != ColumnOrderingStrategyLegacy.INSTANCE) {
            boolean shouldOrderTableColumns = forceOrdering || this.shouldOrderTableColumns();
            for (Namespace namespace : this.database.getNamespaces()) {
                if (shouldOrderTableColumns) {
                    for (Table table : namespace.getTables()) {
                        this.handleTable(table, columnOrderingStrategy);
                        this.handlePrimaryKey(table, columnOrderingStrategy);
                        this.handleForeignKeys(table, columnOrderingStrategy);
                    }
                }
                for (UserDefinedType userDefinedType : namespace.getUserDefinedTypes()) {
                    this.handleUDT(userDefinedType, columnOrderingStrategy);
                }
            }
        }
    }

    private void handleTable(Table table, ColumnOrderingStrategy columnOrderingStrategy) {
        List<Column> tableColumns = columnOrderingStrategy.orderTableColumns(table, this);
        if (tableColumns != null) {
            table.reorderColumns(tableColumns);
        }
    }

    private void handleUDT(UserDefinedType userDefinedType, ColumnOrderingStrategy columnOrderingStrategy) {
        List<Column> objectTypeColumns;
        UserDefinedObjectType objectType;
        if (userDefinedType instanceof UserDefinedObjectType && (objectType = (UserDefinedObjectType)userDefinedType).getColumns().size() > 1 && (objectTypeColumns = columnOrderingStrategy.orderUserDefinedTypeColumns(objectType, this)) != null) {
            objectType.reorderColumns(objectTypeColumns);
        }
    }

    private void handleForeignKeys(Table table, ColumnOrderingStrategy columnOrderingStrategy) {
        for (ForeignKey foreignKey : table.getForeignKeyCollection()) {
            int[] originalPrimaryKeyOrder;
            List<Column> primaryKeyColumns;
            List<Column> columns = foreignKey.getColumns();
            if (columns.size() <= 1 || !foreignKey.getReferencedColumns().isEmpty()) continue;
            PrimaryKey targetPrimaryKey = foreignKey.getReferencedTable().getPrimaryKey();
            if (targetPrimaryKey.getOriginalOrder() == null && (primaryKeyColumns = columnOrderingStrategy.orderConstraintColumns(targetPrimaryKey, this)) != null) {
                targetPrimaryKey.reorderColumns(primaryKeyColumns);
            }
            if ((originalPrimaryKeyOrder = targetPrimaryKey.getOriginalOrder()) == null) continue;
            ArrayList<Column> foreignKeyColumnsCopy = new ArrayList<Column>(columns);
            for (int i = 0; i < foreignKeyColumnsCopy.size(); ++i) {
                columns.set(i, foreignKeyColumnsCopy.get(originalPrimaryKeyOrder[i]));
            }
        }
    }

    private void handlePrimaryKey(Table table, ColumnOrderingStrategy columnOrderingStrategy) {
        List<Column> primaryKeyColumns;
        PrimaryKey primaryKey = table.getPrimaryKey();
        if (primaryKey != null && primaryKey.getColumns().size() > 1 && primaryKey.getOriginalOrder() == null && (primaryKeyColumns = columnOrderingStrategy.orderConstraintColumns(primaryKey, this)) != null) {
            primaryKey.reorderColumns(primaryKeyColumns);
        }
    }

    private boolean shouldOrderTableColumns() {
        Map<String, Object> settings = this.metadataBuildingOptions.getServiceRegistry().requireService(ConfigurationService.class).getSettings();
        for (SchemaManagementToolCoordinator.ActionGrouping grouping : SchemaManagementToolCoordinator.ActionGrouping.interpret(this, settings)) {
            if (!MetadataImpl.isColumnOrderingRelevant(grouping.getScriptAction()) && !MetadataImpl.isColumnOrderingRelevant(grouping.getDatabaseAction())) continue;
            return true;
        }
        return false;
    }

    private static boolean isColumnOrderingRelevant(Action grouping) {
        return switch (grouping) {
            case Action.CREATE, Action.CREATE_DROP, Action.CREATE_ONLY -> true;
            default -> false;
        };
    }

    @Override
    public void validate() throws MappingException {
        for (PersistentClass entityBinding : this.getEntityBindings()) {
            entityBinding.validate(this);
        }
        for (org.hibernate.mapping.Collection collectionBinding : this.getCollectionBindings()) {
            collectionBinding.validate(this);
        }
    }

    @Override
    public Set<MappedSuperclass> getMappedSuperclassMappingsCopy() {
        return this.mappedSuperclassMap == null ? Collections.emptySet() : new HashSet<MappedSuperclass>(this.mappedSuperclassMap.values());
    }

    @Override
    public void initSessionFactory(SessionFactoryImplementor sessionFactory) {
        ServiceRegistryImplementor registry = sessionFactory.getServiceRegistry();
        assert (registry != null);
        ConfigurationService configurationService = registry.requireService(ConfigurationService.class);
        ClassLoaderService classLoaderService = registry.requireService(ClassLoaderService.class);
        EventListenerRegistry eventListenerRegistry = registry.requireService(EventListenerRegistry.class);
        configurationService.getSettings().forEach((propertyName, value) -> {
            if (propertyName.startsWith("hibernate.event.listener")) {
                String eventTypeName = propertyName.substring("hibernate.event.listener".length() + 1);
                EventType<?> eventType = EventType.resolveEventTypeByName(eventTypeName);
                String listeners = (String)value;
                this.appendListeners(eventListenerRegistry, classLoaderService, listeners, eventType);
            }
        });
    }

    private <T> void appendListeners(EventListenerRegistry eventListenerRegistry, ClassLoaderService classLoaderService, String listeners, EventType<T> eventType) {
        EventListenerGroup<Object> eventListenerGroup = eventListenerRegistry.getEventListenerGroup(eventType);
        for (String listenerImpl : StringHelper.splitAtCommas(listeners)) {
            Object listener = MetadataImpl.instantiate(listenerImpl, classLoaderService);
            if (!eventType.baseListenerInterface().isInstance(listener)) {
                throw new HibernateException("Event listener '" + listenerImpl + "' must implement '" + eventType.baseListenerInterface().getName() + "'");
            }
            eventListenerGroup.appendListener(listener);
        }
    }

    private static Object instantiate(String listenerImpl, ClassLoaderService classLoaderService) {
        try {
            return classLoaderService.classForName(listenerImpl).newInstance();
        }
        catch (Exception e) {
            throw new HibernateException("Could not instantiate event listener '" + listenerImpl + "'", e);
        }
    }

    @Override
    public void visitRegisteredComponents(Consumer<Component> consumer) {
        this.composites.forEach(consumer);
    }

    @Override
    public Component getGenericComponent(Class<?> componentClass) {
        return this.genericComponentsMap.get(componentClass);
    }

    @Override
    public DiscriminatorType<?> resolveEmbeddableDiscriminatorType(Class<?> embeddableClass, Supplier<DiscriminatorType<?>> supplier) {
        return this.embeddableDiscriminatorTypesMap.computeIfAbsent(embeddableClass, k -> (DiscriminatorType)supplier.get());
    }

    @Override
    public Type getIdentifierType(String entityName) throws MappingException {
        PersistentClass pc = this.entityBindingMap.get(entityName);
        if (pc == null) {
            throw new MappingException("Persistent class not known: " + entityName);
        }
        return pc.getIdentifier().getType();
    }

    @Override
    public String getIdentifierPropertyName(String entityName) throws MappingException {
        PersistentClass pc = this.entityBindingMap.get(entityName);
        if (pc == null) {
            throw new MappingException("Persistent class not known: " + entityName);
        }
        if (!pc.hasIdentifierProperty()) {
            return null;
        }
        return pc.getIdentifierProperty().getName();
    }

    @Override
    public Type getReferencedPropertyType(String entityName, String propertyName) throws MappingException {
        PersistentClass pc = this.entityBindingMap.get(entityName);
        if (pc == null) {
            throw new MappingException("Persistent class not known: " + entityName);
        }
        Property prop = pc.getReferencedProperty(propertyName);
        if (prop == null) {
            throw new MappingException("Property not known: " + entityName + "." + propertyName);
        }
        return prop.getType();
    }

    public Map<String, PersistentClass> getEntityBindingMap() {
        return this.entityBindingMap;
    }

    public Map<String, org.hibernate.mapping.Collection> getCollectionBindingMap() {
        return this.collectionBindingMap;
    }

    public Map<String, TypeDefinition> getTypeDefinitionMap() {
        return this.typeDefinitionMap;
    }

    public Map<String, FetchProfile> getFetchProfileMap() {
        return this.fetchProfileMap;
    }

    public Map<Class<?>, MappedSuperclass> getMappedSuperclassMap() {
        return this.mappedSuperclassMap;
    }

    public Map<String, IdentifierGeneratorDefinition> getIdGeneratorDefinitionMap() {
        return this.idGeneratorDefinitionMap;
    }

    public Map<String, NamedEntityGraphDefinition> getNamedEntityGraphMap() {
        return this.namedEntityGraphMap;
    }

    public BootstrapContext getBootstrapContext() {
        return this.bootstrapContext;
    }

    public Map<String, NamedHqlQueryDefinition<?>> getNamedQueryMap() {
        return this.namedQueryMap;
    }

    public Map<String, NamedNativeQueryDefinition<?>> getNamedNativeQueryMap() {
        return this.namedNativeQueryMap;
    }

    public Map<String, NamedProcedureCallDefinition> getNamedProcedureCallMap() {
        return this.namedProcedureCallMap;
    }

    public Map<String, NamedResultSetMappingDescriptor> getSqlResultSetMappingMap() {
        return this.sqlResultSetMappingMap;
    }

    public List<Component> getComposites() {
        return this.composites;
    }

    public Map<Class<?>, Component> getGenericComponentsMap() {
        return this.genericComponentsMap;
    }

    public Map<Class<?>, DiscriminatorType<?>> getEmbeddableDiscriminatorTypesMap() {
        return this.embeddableDiscriminatorTypesMap;
    }
}

