/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.jaxb.internal;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.Internal;
import org.hibernate.boot.ResourceStreamLocator;
import org.hibernate.boot.UnsupportedOrmXsdVersionException;
import org.hibernate.boot.jaxb.Origin;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmHibernateMapping;
import org.hibernate.boot.jaxb.hbm.transform.UnsupportedFeatureHandling;
import org.hibernate.boot.jaxb.internal.AbstractBinder;
import org.hibernate.boot.jaxb.internal.stax.HbmEventReader;
import org.hibernate.boot.jaxb.internal.stax.JpaOrmXmlEventReader;
import org.hibernate.boot.jaxb.internal.stax.MappingEventReader;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityMappingsImpl;
import org.hibernate.boot.jaxb.spi.Binding;
import org.hibernate.boot.jaxb.spi.JaxbBindableMappingDescriptor;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.xsd.MappingXsdSupport;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.internal.util.config.ConfigurationException;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.jboss.logging.Logger;

public class MappingBinder
extends AbstractBinder<JaxbBindableMappingDescriptor> {
    private static final Logger log = Logger.getLogger(MappingBinder.class);
    private final XMLEventFactory xmlEventFactory = XMLEventFactory.newInstance();
    private final Supplier<Options> optionsAccess;
    private JAXBContext hbmJaxbContext;
    private JAXBContext entityMappingsJaxbContext;
    public static final Options VALIDATING = new Options(){

        @Override
        public boolean validateMappings() {
            return true;
        }
    };
    public static final Options NON_VALIDATING = new Options(){

        @Override
        public boolean validateMappings() {
            return true;
        }
    };

    public MappingBinder(ResourceStreamLocator resourceStreamLocator, Supplier<Options> optionsAccess, Supplier<UnsupportedFeatureHandling> unsupportedHandlingAccess) {
        super(resourceStreamLocator);
        this.optionsAccess = optionsAccess;
    }

    private MappingBinder(ResourceStreamLocator resourceStreamLocator, Options options, UnsupportedFeatureHandling unsupportedHandling) {
        this(resourceStreamLocator, () -> options, () -> unsupportedHandling);
    }

    public MappingBinder(ResourceStreamLocator resourceStreamLocator, final @Nullable Function<String, Object> settingsAccess) {
        super(resourceStreamLocator == null ? MappingBinder.class.getClassLoader()::getResourceAsStream : resourceStreamLocator);
        this.optionsAccess = settingsAccess == null ? () -> VALIDATING : () -> new Options(){

            @Override
            public boolean validateMappings() {
                Object setting = settingsAccess.apply("hibernate.validate_xml");
                if (setting == null) {
                    return false;
                }
                return StandardConverters.BOOLEAN.convert(setting);
            }
        };
    }

    public MappingBinder(ServiceRegistry serviceRegistry) {
        this((ResourceStreamLocator)serviceRegistry.getService(ClassLoaderService.class), (String settingName) -> {
            ConfigurationService configurationService;
            if (serviceRegistry instanceof ServiceRegistryImplementor) {
                ServiceRegistryImplementor serviceRegistryImplementor = (ServiceRegistryImplementor)serviceRegistry;
                configurationService = serviceRegistryImplementor.fromRegistryOrChildren(ConfigurationService.class);
            } else {
                configurationService = serviceRegistry.getService(ConfigurationService.class);
            }
            ConfigurationService configurationService2 = configurationService;
            return configurationService2 == null ? null : configurationService2.getSettings().get(settingName);
        });
    }

    public MappingBinder(ResourceStreamLocator resourceStreamLocator, UnsupportedFeatureHandling unsupportedHandling) {
        this(resourceStreamLocator, new Options(){

            @Override
            public boolean validateMappings() {
                return false;
            }
        }, unsupportedHandling);
    }

    public MappingBinder(ResourceStreamLocator resourceStreamLocator, Options options) {
        this(resourceStreamLocator, options, UnsupportedFeatureHandling.ERROR);
    }

    @Override
    public boolean isValidationEnabled() {
        return this.optionsAccess.get().validateMappings();
    }

    @Override
    protected <X extends JaxbBindableMappingDescriptor> Binding<X> doBind(XMLEventReader staxEventReader, StartElement rootElementStartEvent, Origin origin) {
        String rootElementLocalName = rootElementStartEvent.getName().getLocalPart();
        if ("hibernate-mapping".equals(rootElementLocalName)) {
            if (log.isDebugEnabled()) {
                log.debugf("Performing JAXB binding of hbm.xml document : %s", (Object)origin.toString());
            }
            HbmEventReader hbmReader = new HbmEventReader(staxEventReader, this.xmlEventFactory);
            JaxbHbmHibernateMapping hbmBindings = (JaxbHbmHibernateMapping)this.jaxb(hbmReader, MappingXsdSupport.INSTANCE.hbmXsd().getSchema(), this.hbmJaxbContext(), origin);
            return new Binding<JaxbHbmHibernateMapping>(hbmBindings, origin);
        }
        assert ("entity-mappings".equals(rootElementLocalName));
        try {
            log.debugf("Performing JAXB binding of orm.xml document : %s", (Object)origin.toString());
            MappingEventReader reader = new MappingEventReader(staxEventReader, this.xmlEventFactory);
            JaxbEntityMappingsImpl bindingRoot = (JaxbEntityMappingsImpl)this.jaxb(reader, MappingXsdSupport.latestDescriptor().getSchema(), this.mappingJaxbContext(), origin);
            return new Binding<JaxbEntityMappingsImpl>(bindingRoot, origin);
        }
        catch (JpaOrmXmlEventReader.BadVersionException e) {
            throw new UnsupportedOrmXsdVersionException(e.getRequestedVersion(), origin);
        }
    }

    private JAXBContext hbmJaxbContext() {
        if (this.hbmJaxbContext == null) {
            try {
                this.hbmJaxbContext = JAXBContext.newInstance((Class[])new Class[]{JaxbHbmHibernateMapping.class});
            }
            catch (JAXBException e) {
                throw new ConfigurationException("Unable to build hbm.xml JAXBContext", e);
            }
        }
        return this.hbmJaxbContext;
    }

    @Internal
    public JAXBContext mappingJaxbContext() {
        if (this.entityMappingsJaxbContext == null) {
            try {
                this.entityMappingsJaxbContext = JAXBContext.newInstance((Class[])new Class[]{JaxbEntityMappingsImpl.class});
            }
            catch (JAXBException e) {
                throw new ConfigurationException("Unable to build orm.xml JAXBContext", e);
            }
        }
        return this.entityMappingsJaxbContext;
    }

    public static interface Options {
        public boolean validateMappings();
    }
}

