/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.convert.internal;

import com.fasterxml.classmate.ResolvedType;
import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Converter;
import java.util.List;
import org.hibernate.boot.model.convert.internal.AutoApplicableConverterDescriptorBypassedImpl;
import org.hibernate.boot.model.convert.internal.AutoApplicableConverterDescriptorStandardImpl;
import org.hibernate.boot.model.convert.internal.ConverterHelper;
import org.hibernate.boot.model.convert.spi.AutoApplicableConverterDescriptor;
import org.hibernate.boot.model.convert.spi.ConverterDescriptor;
import org.hibernate.boot.model.convert.spi.JpaAttributeConverterCreationContext;
import org.hibernate.boot.spi.ClassmateContext;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.type.descriptor.converter.internal.JpaAttributeConverterImpl;
import org.hibernate.type.descriptor.converter.spi.JpaAttributeConverter;

abstract class AbstractConverterDescriptor<X, Y>
implements ConverterDescriptor<X, Y> {
    private final Class<? extends AttributeConverter<X, Y>> converterClass;
    private final ResolvedType domainType;
    private final ResolvedType jdbcType;
    private final AutoApplicableConverterDescriptor autoApplicableDescriptor;

    AbstractConverterDescriptor(Class<? extends AttributeConverter<X, Y>> converterClass, Boolean forceAutoApply, ClassmateContext classmateContext) {
        this.converterClass = converterClass;
        List<ResolvedType> converterParamTypes = ConverterHelper.resolveConverterClassParamTypes(converterClass, classmateContext);
        this.domainType = converterParamTypes.get(0);
        this.jdbcType = converterParamTypes.get(1);
        this.autoApplicableDescriptor = this.resolveAutoApplicableDescriptor(converterClass, forceAutoApply);
    }

    private AutoApplicableConverterDescriptor resolveAutoApplicableDescriptor(Class<? extends AttributeConverter<?, ?>> converterClass, Boolean forceAutoApply) {
        return AbstractConverterDescriptor.isAutoApply(converterClass, forceAutoApply) ? new AutoApplicableConverterDescriptorStandardImpl(this) : AutoApplicableConverterDescriptorBypassedImpl.INSTANCE;
    }

    private static boolean isAutoApply(Class<? extends AttributeConverter<?, ?>> converterClass, Boolean forceAutoApply) {
        if (forceAutoApply != null) {
            return forceAutoApply;
        }
        Converter annotation = converterClass.getAnnotation(Converter.class);
        return annotation != null && annotation.autoApply();
    }

    @Override
    public Class<? extends AttributeConverter<X, Y>> getAttributeConverterClass() {
        return this.converterClass;
    }

    @Override
    public ResolvedType getDomainValueResolvedType() {
        return this.domainType;
    }

    @Override
    public ResolvedType getRelationalValueResolvedType() {
        return this.jdbcType;
    }

    @Override
    public AutoApplicableConverterDescriptor getAutoApplyDescriptor() {
        return this.autoApplicableDescriptor;
    }

    @Override
    public JpaAttributeConverter<X, Y> createJpaAttributeConverter(JpaAttributeConverterCreationContext context) {
        return new JpaAttributeConverterImpl<X, Y>(this.createManagedBean(context), context.getJavaTypeRegistry().getDescriptor(this.converterClass), this.getDomainClass(), this.getRelationalClass(), context);
    }

    private Class<Y> getRelationalClass() {
        return this.getRelationalValueResolvedType().getErasedType();
    }

    private Class<X> getDomainClass() {
        return this.getDomainValueResolvedType().getErasedType();
    }

    protected abstract ManagedBean<? extends AttributeConverter<X, Y>> createManagedBean(JpaAttributeConverterCreationContext var1);
}

