/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.convert.internal;

import com.fasterxml.classmate.ResolvedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.hibernate.AnnotationException;
import org.hibernate.HibernateException;
import org.hibernate.boot.model.convert.internal.ConverterHelper;
import org.hibernate.boot.model.convert.spi.AutoApplicableConverterDescriptor;
import org.hibernate.boot.model.convert.spi.ConverterAutoApplyHandler;
import org.hibernate.boot.model.convert.spi.ConverterDescriptor;
import org.hibernate.boot.model.convert.spi.RegisteredConversion;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.models.spi.MemberDetails;
import org.jboss.logging.Logger;

public class AttributeConverterManager
implements ConverterAutoApplyHandler {
    private static final Logger log = Logger.getLogger(AttributeConverterManager.class);
    private Map<Class<?>, ConverterDescriptor<?, ?>> attributeConverterDescriptorsByClass;
    private Map<Class<?>, RegisteredConversion> registeredConversionsByDomainType;

    public RegisteredConversion findRegisteredConversion(Class<?> domainType) {
        return this.registeredConversionsByDomainType == null ? null : this.registeredConversionsByDomainType.get(domainType);
    }

    public void addConverter(ConverterDescriptor<?, ?> descriptor) {
        ConverterDescriptor<?, ?> old;
        Class domainType;
        RegisteredConversion registeredConversion;
        if (log.isTraceEnabled()) {
            log.tracef("Starting AttributeConverterManager#addConverter : `%s`", (Object)descriptor.getAttributeConverterClass().getName());
        }
        if (this.registeredConversionsByDomainType != null && (registeredConversion = this.registeredConversionsByDomainType.get(domainType = descriptor.getDomainValueResolvedType().getErasedType())) != null) {
            if (log.isDebugEnabled()) {
                log.debugf("Skipping registration of discovered AttributeConverter `%s` for auto-apply", (Object)descriptor.getAttributeConverterClass().getName());
            }
            return;
        }
        if (this.attributeConverterDescriptorsByClass == null) {
            this.attributeConverterDescriptorsByClass = new ConcurrentHashMap();
        }
        if ((old = this.attributeConverterDescriptorsByClass.put(descriptor.getAttributeConverterClass(), descriptor)) != null) {
            throw new HibernateException(String.format(Locale.ENGLISH, "AttributeConverter class [%s] registered multiple times", descriptor.getAttributeConverterClass()));
        }
    }

    public void addRegistration(RegisteredConversion conversion, BootstrapContext context) {
        ConverterDescriptor<?, ?> removed;
        Class<?> domainType;
        RegisteredConversion existingRegistration;
        if (this.registeredConversionsByDomainType == null) {
            this.registeredConversionsByDomainType = new ConcurrentHashMap();
        }
        if ((existingRegistration = this.registeredConversionsByDomainType.get(domainType = AttributeConverterManager.getDomainType(conversion, context))) != null) {
            if (!conversion.equals(existingRegistration)) {
                throw new AnnotationException("Conflicting '@ConverterRegistration' descriptors for attribute converter '" + conversion.getConverterType().getName() + "'");
            }
            if (log.isDebugEnabled()) {
                log.debugf("Skipping duplicate '@ConverterRegistration' for '%s'", (Object)conversion.getConverterType().getName());
            }
        }
        if (this.attributeConverterDescriptorsByClass != null && (removed = this.attributeConverterDescriptorsByClass.remove(conversion.getConverterType())) != null && log.isDebugEnabled()) {
            log.debugf("Removed potentially auto-applicable converter `%s` due to @ConverterRegistration", (Object)removed.getAttributeConverterClass().getName());
        }
        this.registeredConversionsByDomainType.put(domainType, conversion);
    }

    private static Class<?> getDomainType(RegisteredConversion conversion, BootstrapContext context) {
        if (conversion.getExplicitDomainType().equals(Void.TYPE)) {
            List<ResolvedType> converterParamTypes = ConverterHelper.resolveConverterClassParamTypes(conversion.getConverterType(), context.getClassmateContext());
            return converterParamTypes.get(0).getErasedType();
        }
        return conversion.getExplicitDomainType();
    }

    private Collection<ConverterDescriptor<?, ?>> converterDescriptors() {
        return this.attributeConverterDescriptorsByClass == null ? Collections.emptyList() : this.attributeConverterDescriptorsByClass.values();
    }

    @Override
    public ConverterDescriptor<?, ?> findAutoApplyConverterForAttribute(MemberDetails attributeMember, MetadataBuildingContext context) {
        return this.locateMatchingConverter(attributeMember, ConversionSite.ATTRIBUTE, autoApplyDescriptor -> autoApplyDescriptor.getAutoAppliedConverterDescriptorForAttribute(attributeMember, context), context);
    }

    private ConverterDescriptor<?, ?> locateMatchingConverter(MemberDetails memberDetails, ConversionSite conversionSite, Function<AutoApplicableConverterDescriptor, ConverterDescriptor<?, ?>> matcher, MetadataBuildingContext context) {
        ResolvedType resolveAttributeType;
        RegisteredConversion registrationForDomainType;
        if (this.registeredConversionsByDomainType != null && (registrationForDomainType = this.registeredConversionsByDomainType.get((resolveAttributeType = ConverterHelper.resolveAttributeType(memberDetails, context)).getErasedType())) != null) {
            return registrationForDomainType.isAutoApply() ? registrationForDomainType.getConverterDescriptor() : null;
        }
        return AttributeConverterManager.pickUniqueMatch(memberDetails, conversionSite, this.getMatches(memberDetails, conversionSite, matcher));
    }

    private static ConverterDescriptor<?, ?> pickUniqueMatch(MemberDetails memberDetails, ConversionSite conversionSite, List<ConverterDescriptor<?, ?>> matches) {
        return switch (matches.size()) {
            case 0 -> null;
            case 1 -> matches.get(0);
            default -> {
                List<ConverterDescriptor> filtered = matches.stream().filter(match -> !match.overrideable()).toList();
                if (filtered.size() == 1) {
                    yield filtered.get(0);
                }
                throw new HibernateException(String.format(Locale.ROOT, "Multiple auto-apply converters matched %s [%s.%s] : %s", conversionSite.getSiteDescriptor(), memberDetails.getDeclaringType().getName(), memberDetails.getName(), StringHelper.join(matches, value -> value.getAttributeConverterClass().getName())));
            }
        };
    }

    private List<ConverterDescriptor<?, ?>> getMatches(MemberDetails memberDetails, ConversionSite conversionSite, Function<AutoApplicableConverterDescriptor, ConverterDescriptor<?, ?>> matcher) {
        ArrayList matches = new ArrayList();
        for (ConverterDescriptor<?, ?> descriptor : this.converterDescriptors()) {
            ConverterDescriptor<?, ?> match;
            if (log.isDebugEnabled()) {
                log.debugf("Checking auto-apply AttributeConverter [%s] (domain-type=%s) for match against %s : %s.%s (type=%s)", new Object[]{descriptor.getAttributeConverterClass().getName(), descriptor.getDomainValueResolvedType().getSignature(), conversionSite.getSiteDescriptor(), memberDetails.getDeclaringType().getName(), memberDetails.getName(), memberDetails.getType().getName()});
            }
            if ((match = matcher.apply(descriptor.getAutoApplyDescriptor())) == null) continue;
            matches.add(descriptor);
        }
        return matches;
    }

    @Override
    public ConverterDescriptor<?, ?> findAutoApplyConverterForCollectionElement(MemberDetails attributeMember, MetadataBuildingContext context) {
        return this.locateMatchingConverter(attributeMember, ConversionSite.COLLECTION_ELEMENT, autoApplyDescriptor -> autoApplyDescriptor.getAutoAppliedConverterDescriptorForCollectionElement(attributeMember, context), context);
    }

    @Override
    public ConverterDescriptor<?, ?> findAutoApplyConverterForMapKey(MemberDetails attributeMember, MetadataBuildingContext context) {
        return this.locateMatchingConverter(attributeMember, ConversionSite.MAP_KEY, autoApplyDescriptor -> autoApplyDescriptor.getAutoAppliedConverterDescriptorForMapKey(attributeMember, context), context);
    }

    static enum ConversionSite {
        ATTRIBUTE,
        COLLECTION_ELEMENT,
        MAP_KEY;


        public String getSiteDescriptor() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case ATTRIBUTE -> "basic attribute";
                case COLLECTION_ELEMENT -> "collection attribute's element";
                case MAP_KEY -> "map attribute's key";
            };
        }
    }
}

