/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.convert.internal;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.ResolvedTypeWithMembers;
import com.fasterxml.classmate.members.ResolvedField;
import com.fasterxml.classmate.members.ResolvedMember;
import com.fasterxml.classmate.members.ResolvedMethod;
import jakarta.persistence.AttributeConverter;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import org.hibernate.AnnotationException;
import org.hibernate.HibernateException;
import org.hibernate.boot.spi.ClassmateContext;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.internal.util.GenericsHelper;
import org.hibernate.internal.util.type.PrimitiveWrapperHelper;
import org.hibernate.models.spi.MemberDetails;

public class ConverterHelper {
    public static ParameterizedType extractAttributeConverterParameterizedType(Class<? extends AttributeConverter<?, ?>> base) {
        return GenericsHelper.extractParameterizedType(base);
    }

    public static ResolvedType resolveAttributeType(MemberDetails memberDetails, MetadataBuildingContext context) {
        return ConverterHelper.resolveMember(memberDetails, context).getType();
    }

    public static ResolvedMember<? extends Member> resolveMember(MemberDetails memberDetails, MetadataBuildingContext buildingContext) {
        ClassmateContext classmateContext = buildingContext.getBootstrapContext().getClassmateContext();
        ResolvedType declaringClassType = classmateContext.getTypeResolver().resolve((Type)memberDetails.getDeclaringType().toJavaClass(), new Type[0]);
        ResolvedTypeWithMembers declaringClassWithMembers = classmateContext.getMemberResolver().resolve(declaringClassType, null, null);
        Member member = memberDetails.toJavaMember();
        if (member instanceof Method) {
            for (ResolvedMethod resolvedMember : declaringClassWithMembers.getMemberMethods()) {
                if (!resolvedMember.getName().equals(member.getName())) continue;
                return resolvedMember;
            }
        } else if (member instanceof Field) {
            for (ResolvedField resolvedMember : declaringClassWithMembers.getMemberFields()) {
                if (!resolvedMember.getName().equals(member.getName())) continue;
                return resolvedMember;
            }
        } else {
            throw new HibernateException("Unexpected java.lang.reflect.Member type from org.hibernate.models.spi.MemberDetails : " + String.valueOf(member));
        }
        throw new HibernateException("Could not locate resolved type information for attribute [" + member.getName() + "] from Classmate");
    }

    public static List<ResolvedType> resolveConverterClassParamTypes(Class<? extends AttributeConverter<?, ?>> converterClass, ClassmateContext context) {
        ResolvedType converterType = context.getTypeResolver().resolve(converterClass, new Type[0]);
        List converterParamTypes = converterType.typeParametersFor(AttributeConverter.class);
        if (converterParamTypes == null) {
            throw new AnnotationException("Could not extract type argument from attribute converter class '" + converterClass.getName() + "'");
        }
        if (converterParamTypes.size() != 2) {
            throw new AnnotationException("Unexpected type argument for attribute converter class '" + converterClass.getName() + "' (expected 2 type arguments, but found " + converterParamTypes.size() + ")");
        }
        return converterParamTypes;
    }

    public static boolean typesMatch(ResolvedType converterDefinedType, ResolvedType checkType) {
        Class erasedCheckType = checkType.getErasedType();
        if (erasedCheckType.isPrimitive()) {
            erasedCheckType = PrimitiveWrapperHelper.getDescriptorByPrimitiveType(erasedCheckType).getWrapperClass();
        } else if (erasedCheckType.isArray()) {
            return converterDefinedType.getErasedType() == erasedCheckType;
        }
        return converterDefinedType.getErasedType().isAssignableFrom(erasedCheckType) && ConverterHelper.checkTypeParametersMatch(converterDefinedType, checkType);
    }

    private static boolean checkTypeParametersMatch(ResolvedType converterDefinedType, ResolvedType checkType) {
        List converterTypeParameters = converterDefinedType.getTypeParameters();
        if (converterTypeParameters.isEmpty()) {
            return true;
        }
        List checkTypeParameters = checkType.getTypeParameters();
        if (checkTypeParameters.isEmpty()) {
            return false;
        }
        if (converterTypeParameters.size() != checkTypeParameters.size()) {
            return false;
        }
        for (int i = 0; i < converterTypeParameters.size(); ++i) {
            if (ConverterHelper.typesMatch((ResolvedType)converterTypeParameters.get(i), (ResolvedType)checkTypeParameters.get(i))) continue;
            return false;
        }
        return true;
    }
}

