/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.NamedStoredProcedureQuery;
import jakarta.persistence.ParameterMode;
import jakarta.persistence.QueryHint;
import jakarta.persistence.SqlResultSetMapping;
import jakarta.persistence.StoredProcedureParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import org.hibernate.AnnotationException;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.LockOptions;
import org.hibernate.annotations.FlushModeType;
import org.hibernate.annotations.HQLSelect;
import org.hibernate.annotations.NamedNativeQuery;
import org.hibernate.annotations.SQLSelect;
import org.hibernate.boot.internal.NamedHqlQueryDefinitionImpl;
import org.hibernate.boot.internal.NamedProcedureCallDefinitionImpl;
import org.hibernate.boot.model.internal.QueryHintDefinition;
import org.hibernate.boot.model.internal.ResultSetMappingSecondPass;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.annotations.internal.NamedStoredProcedureQueryJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.QueryHintJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.StoredProcedureParameterJpaAnnotation;
import org.hibernate.boot.query.NamedHqlQueryDefinition;
import org.hibernate.boot.query.NamedNativeQueryDefinition;
import org.hibernate.boot.query.NamedProcedureCallDefinition;
import org.hibernate.boot.query.SqlResultSetMappingDescriptor;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.jpa.internal.util.FlushModeTypeHelper;
import org.hibernate.models.internal.util.StringHelper;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ModelsContext;
import org.hibernate.query.QueryFlushMode;
import org.hibernate.query.sql.internal.ParameterParser;
import org.hibernate.query.sql.spi.ParameterRecognizer;

public abstract class QueryBinder {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(QueryBinder.class);

    public static void bindQuery(NamedQuery namedQuery, MetadataBuildingContext context, boolean isDefault, AnnotationTarget annotationTarget) {
        if (namedQuery != null) {
            String queryName = namedQuery.name();
            String queryString = namedQuery.query();
            Class resultClass = namedQuery.resultClass();
            if (queryName.isBlank()) {
                throw new AnnotationException("Class or package level '@NamedQuery' annotation must specify a 'name'");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Binding named query: %s => %s", queryName, queryString);
            }
            QueryHintDefinition hints = new QueryHintDefinition(queryName, namedQuery.hints());
            NamedHqlQueryDefinitionImpl queryMapping = QueryBinder.createNamedQueryDefinition(queryName, queryString, resultClass, hints.determineLockOptions(namedQuery), hints, annotationTarget);
            if (isDefault) {
                context.getMetadataCollector().addDefaultQuery(queryMapping);
            } else {
                context.getMetadataCollector().addNamedQuery(queryMapping);
            }
        }
    }

    private static <T> NamedHqlQueryDefinitionImpl<T> createNamedQueryDefinition(String queryName, String queryString, Class<T> resultClass, LockOptions lockOptions, QueryHintDefinition hints, AnnotationTarget annotationTarget) {
        return ((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)new NamedHqlQueryDefinition.Builder(queryName, annotationTarget).setHqlString(queryString).setResultClass(resultClass)).setCacheable(hints.getCacheability())).setCacheMode(hints.getCacheMode())).setCacheRegion(hints.getString("org.hibernate.cacheRegion"))).setTimeout(hints.getTimeout())).setFetchSize(hints.getInteger("org.hibernate.fetchSize"))).setFlushMode(hints.getFlushMode())).setReadOnly(hints.getBooleanWrapper("org.hibernate.readOnly"))).setLockOptions(lockOptions)).setComment(hints.getString("org.hibernate.comment"))).build();
    }

    public static void bindNativeQuery(jakarta.persistence.NamedNativeQuery namedNativeQuery, MetadataBuildingContext context, AnnotationTarget location, boolean isDefault) {
        if (namedNativeQuery == null) {
            return;
        }
        String registrationName = namedNativeQuery.name();
        String queryString = namedNativeQuery.query();
        if (registrationName.isBlank()) {
            throw new AnnotationException("Class or package level '@NamedNativeQuery' annotation must specify a 'name'");
        }
        QueryHintDefinition hints = new QueryHintDefinition(registrationName, namedNativeQuery.hints());
        String resultSetMappingName = namedNativeQuery.resultSetMapping();
        Class resultClassDetails = namedNativeQuery.resultClass();
        Class resultClass = Void.TYPE == resultClassDetails ? null : resultClassDetails;
        NamedNativeQueryDefinition queryDefinition = QueryBinder.createNamedQueryDefinition(registrationName, queryString, resultClass, resultSetMappingName, hints, location);
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Binding named native query: %s => %s", queryDefinition.getRegistrationName(), queryDefinition.getSqlQueryString());
        }
        if (isDefault) {
            context.getMetadataCollector().addDefaultNamedNativeQuery(queryDefinition);
        } else {
            context.getMetadataCollector().addNamedNativeQuery(queryDefinition);
        }
    }

    private static <T> NamedNativeQueryDefinition<T> createNamedQueryDefinition(String registrationName, String queryString, Class<T> resultClass, String resultSetMappingName, QueryHintDefinition hints, AnnotationTarget location) {
        return ((NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)new NamedNativeQueryDefinition.Builder(registrationName, location).setSqlString(queryString).setResultClass(resultClass)).setResultSetMappingName(resultSetMappingName).setQuerySpaces(null).setCacheable(hints.getCacheability())).setCacheMode(hints.getCacheMode())).setCacheRegion(hints.getString("org.hibernate.cacheRegion"))).setTimeout(hints.getTimeout())).setFetchSize(hints.getInteger("org.hibernate.fetchSize"))).setFlushMode(hints.getFlushMode())).setReadOnly(hints.getBooleanWrapper("org.hibernate.readOnly"))).setComment(hints.getString("org.hibernate.comment"))).addHints(hints.getHintsMap())).build();
    }

    public static void bindNativeQuery(String name, SQLSelect sqlSelect, ClassDetails annotatedClass, MetadataBuildingContext context) {
        SqlResultSetMapping resultSetMapping;
        NamedNativeQueryDefinition.Builder builder = ((NamedNativeQueryDefinition.Builder)new NamedNativeQueryDefinition.Builder(name).setFlushMode(FlushMode.MANUAL)).setSqlString(sqlSelect.sql()).setQuerySpaces(CollectionHelper.setOf(sqlSelect.querySpaces()));
        if (annotatedClass != null) {
            builder.setResultClass(context.getBootstrapContext().getClassLoaderService().classForName(annotatedClass.getClassName()));
        }
        if (!(ArrayHelper.isEmpty((resultSetMapping = sqlSelect.resultSetMapping()).columns()) && ArrayHelper.isEmpty(resultSetMapping.entities()) && ArrayHelper.isEmpty(resultSetMapping.classes()))) {
            context.getMetadataCollector().addResultSetMapping(SqlResultSetMappingDescriptor.from(resultSetMapping, name));
            builder.setResultSetMappingName(name);
        }
        context.getMetadataCollector().addNamedNativeQuery(builder.build());
    }

    public static void bindNativeQuery(NamedNativeQuery namedNativeQuery, MetadataBuildingContext context, AnnotationTarget location) {
        if (namedNativeQuery == null) {
            return;
        }
        String registrationName = namedNativeQuery.name();
        if (registrationName.isBlank()) {
            throw new AnnotationException("Class or package level '@NamedNativeQuery' annotation must specify a 'name'");
        }
        String resultSetMappingName = namedNativeQuery.resultSetMapping();
        Class<?> resultClassDetails = namedNativeQuery.resultClass();
        Class<?> resultClass = resultClassDetails == Void.TYPE ? null : resultClassDetails;
        String[] querySpacesList = namedNativeQuery.querySpaces();
        HashSet<String> querySpaces = new HashSet<String>(CollectionHelper.determineProperSizing(querySpacesList.length));
        Collections.addAll(querySpaces, querySpacesList);
        NamedNativeQueryDefinition.Builder<?> builder = QueryBinder.createQueryDefinition(namedNativeQuery, registrationName, resultSetMappingName, resultClass, namedNativeQuery.timeout(), namedNativeQuery.fetchSize(), querySpaces, location);
        NamedNativeQueryDefinition<?> queryDefinition = builder.build();
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Binding named native query: %s => %s", queryDefinition.getRegistrationName(), queryDefinition.getSqlQueryString());
        }
        context.getMetadataCollector().addNamedNativeQuery(queryDefinition);
    }

    private static <T> NamedNativeQueryDefinition.Builder<T> createQueryDefinition(NamedNativeQuery namedNativeQuery, String registrationName, String resultSetMappingName, Class<T> resultClass, int timeout, int fetchSize, HashSet<String> querySpaces, AnnotationTarget location) {
        return (NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)new NamedNativeQueryDefinition.Builder(registrationName, location).setSqlString(namedNativeQuery.query()).setResultSetMappingName(resultSetMappingName).setResultClass(resultClass)).setCacheable(namedNativeQuery.cacheable())).setCacheRegion(org.hibernate.internal.util.StringHelper.nullIfEmpty(namedNativeQuery.cacheRegion()))).setCacheMode(QueryBinder.getCacheMode(namedNativeQuery.cacheRetrieveMode(), namedNativeQuery.cacheStoreMode()))).setTimeout(timeout < 0 ? null : Integer.valueOf(timeout))).setFetchSize(fetchSize < 0 ? null : Integer.valueOf(fetchSize))).setFlushMode(QueryBinder.getFlushMode(namedNativeQuery.flush(), namedNativeQuery.flushMode()))).setReadOnly(namedNativeQuery.readOnly())).setQuerySpaces(querySpaces).setComment(org.hibernate.internal.util.StringHelper.nullIfEmpty(namedNativeQuery.comment()));
    }

    @Deprecated
    public static NamedProcedureCallDefinition createStoredProcedure(NamedNativeQueryDefinition.Builder<?> builder, MetadataBuildingContext context, Supplier<RuntimeException> exceptionProducer) {
        Class resultClass;
        String sqlString = builder.getSqlString().trim();
        if (!sqlString.startsWith("{") || !sqlString.endsWith("}")) {
            throw exceptionProducer.get();
        }
        JdbcCall jdbcCall = QueryBinder.parseJdbcCall(sqlString, exceptionProducer);
        ModelsContext modelsContext = context.getBootstrapContext().getModelsContext();
        NamedStoredProcedureQueryJpaAnnotation nameStoredProcedureQueryAnn = (NamedStoredProcedureQueryJpaAnnotation)((Object)JpaAnnotations.NAMED_STORED_PROCEDURE_QUERY.createUsage(modelsContext));
        nameStoredProcedureQueryAnn.name(builder.getName());
        nameStoredProcedureQueryAnn.procedureName(jdbcCall.callableName);
        nameStoredProcedureQueryAnn.parameters(QueryBinder.parametersAsAnnotations(builder, context, jdbcCall));
        String resultSetMappingName = builder.getResultSetMappingName();
        if (resultSetMappingName != null) {
            nameStoredProcedureQueryAnn.resultSetMappings(new String[]{resultSetMappingName});
        }
        if ((resultClass = builder.getResultClass()) != null) {
            nameStoredProcedureQueryAnn.resultClasses(new Class[]{builder.getResultClass()});
        }
        List<QueryHint> hints = QueryBinder.hintsAsAnnotations(builder, modelsContext, jdbcCall);
        nameStoredProcedureQueryAnn.hints((QueryHint[])hints.toArray(QueryHint[]::new));
        return new NamedProcedureCallDefinitionImpl(nameStoredProcedureQueryAnn);
    }

    private static StoredProcedureParameter[] parametersAsAnnotations(NamedNativeQueryDefinition.Builder<?> builder, MetadataBuildingContext context, JdbcCall jdbcCall) {
        ModelsContext modelsContext = context.getBootstrapContext().getModelsContext();
        StoredProcedureParameter[] parameters = new StoredProcedureParameter[jdbcCall.parameters.size()];
        for (int i = 0; i < jdbcCall.parameters.size(); ++i) {
            StoredProcedureParameterJpaAnnotation param = (StoredProcedureParameterJpaAnnotation)((Object)JpaAnnotations.STORED_PROCEDURE_PARAMETER.createUsage(modelsContext));
            parameters[i] = param;
            String paramName = jdbcCall.parameters.get(i);
            param.name(paramName);
            param.mode(ParameterMode.IN);
            String typeName = builder.getParameterTypes().get(paramName);
            ClassDetails classDetails = StringHelper.isEmpty((String)typeName) ? ClassDetails.VOID_CLASS_DETAILS : QueryBinder.classDetails(context, typeName);
            param.type(classDetails.toJavaClass());
        }
        return parameters;
    }

    private static List<QueryHint> hintsAsAnnotations(NamedNativeQueryDefinition.Builder<?> builder, ModelsContext modelsContext, JdbcCall jdbcCall) {
        QueryHintJpaAnnotation hint;
        ArrayList<QueryHint> hints = new ArrayList<QueryHint>();
        if (builder.getQuerySpaces() != null) {
            hint = (QueryHintJpaAnnotation)((Object)JpaAnnotations.QUERY_HINT.createUsage(modelsContext));
            hint.name("org.hibernate.query.native.spaces");
            hint.value(String.join((CharSequence)" ", builder.getQuerySpaces()));
            hints.add(hint);
        }
        if (jdbcCall.resultParameter) {
            hint = (QueryHintJpaAnnotation)((Object)JpaAnnotations.QUERY_HINT.createUsage(modelsContext));
            hint.name("org.hibernate.callableFunction");
            hint.value("true");
            hints.add(hint);
        }
        return hints;
    }

    private static ClassDetails classDetails(MetadataBuildingContext context, String typeName) {
        String registeredTypeName = context.getBootstrapContext().getTypeConfiguration().getBasicTypeRegistry().getRegisteredType(typeName).getJavaType().getName();
        return context.getMetadataCollector().getClassDetailsRegistry().getClassDetails(registeredTypeName);
    }

    public static void bindQuery(String name, HQLSelect hqlSelect, MetadataBuildingContext context) {
        NamedHqlQueryDefinitionImpl hqlQueryDefinition = ((NamedHqlQueryDefinition.Builder)new NamedHqlQueryDefinition.Builder(name).setFlushMode(FlushMode.MANUAL)).setHqlString(hqlSelect.query()).build();
        context.getMetadataCollector().addNamedQuery(hqlQueryDefinition);
    }

    public static void bindQuery(org.hibernate.annotations.NamedQuery namedQuery, MetadataBuildingContext context, AnnotationTarget location) {
        if (namedQuery == null) {
            return;
        }
        String registrationName = namedQuery.name();
        Class<?> resultClass = namedQuery.resultClass();
        if (registrationName.isBlank()) {
            throw new AnnotationException("Class or package level '@NamedQuery' annotation must specify a 'name'");
        }
        NamedHqlQueryDefinition.Builder<?> builder = QueryBinder.createQueryDefinition(namedQuery, registrationName, resultClass, namedQuery.timeout(), namedQuery.fetchSize(), location);
        NamedHqlQueryDefinitionImpl<?> hqlQueryDefinition = builder.build();
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Binding named query: %s => %s", hqlQueryDefinition.getRegistrationName(), hqlQueryDefinition.getHqlString());
        }
        context.getMetadataCollector().addNamedQuery(hqlQueryDefinition);
    }

    private static <T> NamedHqlQueryDefinition.Builder<T> createQueryDefinition(org.hibernate.annotations.NamedQuery namedQuery, String registrationName, Class<T> resultClass, int timeout, int fetchSize, AnnotationTarget location) {
        return (NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)new NamedHqlQueryDefinition.Builder(registrationName, location).setHqlString(namedQuery.query()).setResultClass(resultClass)).setCacheable(namedQuery.cacheable())).setCacheRegion(org.hibernate.internal.util.StringHelper.nullIfEmpty(namedQuery.cacheRegion()))).setCacheMode(QueryBinder.getCacheMode(namedQuery.cacheRetrieveMode(), namedQuery.cacheStoreMode()))).setTimeout(timeout < 0 ? null : Integer.valueOf(timeout))).setFetchSize(fetchSize < 0 ? null : Integer.valueOf(fetchSize))).setFlushMode(QueryBinder.getFlushMode(namedQuery.flush(), namedQuery.flushMode()))).setReadOnly(namedQuery.readOnly())).setComment(org.hibernate.internal.util.StringHelper.nullIfEmpty(namedQuery.comment()));
    }

    private static CacheMode getCacheMode(CacheRetrieveMode cacheRetrieveMode, CacheStoreMode cacheStoreMode) {
        CacheMode cacheMode = CacheMode.fromJpaModes(cacheRetrieveMode, cacheStoreMode);
        return cacheMode == null ? CacheMode.NORMAL : cacheMode;
    }

    private static FlushMode getFlushMode(QueryFlushMode queryFlushMode, FlushModeType flushModeType) {
        return queryFlushMode == QueryFlushMode.DEFAULT ? QueryBinder.getFlushMode(flushModeType) : FlushModeTypeHelper.getFlushMode(queryFlushMode);
    }

    private static FlushMode getFlushMode(FlushModeType flushModeType) {
        return switch (flushModeType) {
            default -> throw new IncompatibleClassChangeError();
            case FlushModeType.ALWAYS -> FlushMode.ALWAYS;
            case FlushModeType.AUTO -> FlushMode.AUTO;
            case FlushModeType.COMMIT -> FlushMode.COMMIT;
            case FlushModeType.MANUAL -> FlushMode.MANUAL;
            case FlushModeType.PERSISTENCE_CONTEXT -> null;
        };
    }

    public static void bindNamedStoredProcedureQuery(NamedStoredProcedureQuery namedStoredProcedureQuery, MetadataBuildingContext context, boolean isDefault) {
        if (namedStoredProcedureQuery != null) {
            if (namedStoredProcedureQuery.name().isBlank()) {
                throw new AnnotationException("Class or package level '@NamedStoredProcedureQuery' annotation must specify a 'name'");
            }
            NamedProcedureCallDefinitionImpl definition = new NamedProcedureCallDefinitionImpl(namedStoredProcedureQuery);
            if (isDefault) {
                context.getMetadataCollector().addDefaultNamedProcedureCall(definition);
            } else {
                context.getMetadataCollector().addNamedProcedureCallDefinition(definition);
            }
            LOG.debugf("Bound named stored procedure query: %s => %s", definition.getRegistrationName(), definition.getProcedureName());
        }
    }

    public static void bindSqlResultSetMapping(SqlResultSetMapping resultSetMappingAnn, MetadataBuildingContext context, boolean isDefault) {
        context.getMetadataCollector().addSecondPass(new ResultSetMappingSecondPass(resultSetMappingAnn, context, isDefault));
    }

    private static JdbcCall parseJdbcCall(String sqlString, Supplier<RuntimeException> exceptionProducer) {
        String callableName = null;
        boolean resultParameter = false;
        int index = QueryBinder.skipWhitespace(sqlString, 1);
        if (sqlString.charAt(index) == '?') {
            resultParameter = true;
            ++index;
            if (sqlString.charAt(index = QueryBinder.skipWhitespace(sqlString, index)) != '=') {
                throw exceptionProducer.get();
            }
            ++index;
            index = QueryBinder.skipWhitespace(sqlString, index);
        }
        if (!sqlString.regionMatches(true, index, "call", 0, 4)) {
            throw exceptionProducer.get();
        }
        index += 4;
        int procedureStart = index = QueryBinder.skipWhitespace(sqlString, index);
        while (index < sqlString.length()) {
            char c = sqlString.charAt(index);
            if (c == '(' || Character.isWhitespace(c)) {
                callableName = sqlString.substring(procedureStart, index);
                break;
            }
            ++index;
        }
        index = QueryBinder.skipWhitespace(sqlString, index);
        final ArrayList<String> parameters = new ArrayList<String>();
        ParameterParser.parse(sqlString.substring(index, sqlString.length() - 1), new ParameterRecognizer(){

            @Override
            public void ordinalParameter(int sourcePosition) {
                parameters.add("");
            }

            @Override
            public void namedParameter(String name, int sourcePosition) {
                parameters.add(name);
            }

            @Override
            public void jpaPositionalParameter(int label, int sourcePosition) {
                parameters.add("");
            }

            @Override
            public void other(char character) {
            }
        });
        return new JdbcCall(callableName, resultParameter, parameters);
    }

    private static int skipWhitespace(String sqlString, int i) {
        while (i < sqlString.length() && Character.isWhitespace(sqlString.charAt(i))) {
            ++i;
        }
        return i;
    }

    private static class JdbcCall {
        private final String callableName;
        private final boolean resultParameter;
        private final ArrayList<String> parameters;

        public JdbcCall(String callableName, boolean resultParameter, ArrayList<String> parameters) {
            this.callableName = callableName;
            this.resultParameter = resultParameter;
            this.parameters = parameters;
        }
    }
}

