/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.LockModeType;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.QueryHint;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.internal.util.LockModeConverter;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;

public class QueryHintDefinition {
    private final String queryName;
    private final Map<String, Object> hintsMap;

    public QueryHintDefinition(String queryName, QueryHint[] hints) {
        this.queryName = queryName;
        if (CollectionHelper.isEmpty(hints)) {
            this.hintsMap = Collections.emptyMap();
        } else {
            HashMap<String, Object> hintsMap = CollectionHelper.mapOfSize(hints.length);
            for (QueryHint hint : hints) {
                hintsMap.put(hint.name(), hint.value());
            }
            this.hintsMap = hintsMap;
        }
    }

    public Map<String, Object> getHintsMap() {
        return this.hintsMap;
    }

    public String getString(String hintName) {
        return (String)this.hintsMap.get(hintName);
    }

    public boolean getBoolean(String hintName) {
        try {
            return ConfigurationHelper.getBoolean(hintName, this.hintsMap);
        }
        catch (Exception e) {
            throw new AnnotationException("Named query hint [" + hintName + "] is not a boolean: " + this.queryName, e);
        }
    }

    public Boolean getBooleanWrapper(String hintName) {
        try {
            return ConfigurationHelper.getBooleanWrapper(hintName, this.hintsMap, null);
        }
        catch (Exception e) {
            throw new AnnotationException("Named query hint [" + hintName + "] is not a boolean: " + this.queryName, e);
        }
    }

    public Integer getInteger(String hintName) {
        try {
            return ConfigurationHelper.getInteger(hintName, this.hintsMap);
        }
        catch (Exception e) {
            throw new AnnotationException("Named query hint [" + hintName + "] is not an integer: " + this.queryName, e);
        }
    }

    public Integer getTimeout() {
        Integer jakartaTimeout = this.getInteger("jakarta.persistence.query.timeout");
        if (jakartaTimeout != null) {
            return (int)Math.round(jakartaTimeout.doubleValue() / 1000.0);
        }
        Integer javaeeTimeout = this.getInteger("javax.persistence.query.timeout");
        if (javaeeTimeout != null) {
            return (int)Math.round(javaeeTimeout.doubleValue() / 1000.0);
        }
        return this.getInteger("org.hibernate.timeout");
    }

    public boolean getCacheability() {
        return this.getBoolean("org.hibernate.cacheable");
    }

    public CacheMode getCacheMode() {
        String value = this.getString("org.hibernate.cacheMode");
        try {
            return value == null ? null : CacheMode.interpretExternalSetting(value);
        }
        catch (Exception e) {
            throw new AnnotationException("Unable to interpret CacheMode in named query hint: " + this.queryName, e);
        }
    }

    public FlushMode getFlushMode() {
        String value = this.getString("org.hibernate.flushMode");
        try {
            return value == null ? null : FlushMode.interpretExternalSetting(value);
        }
        catch (MappingException e) {
            throw new AnnotationException("Unable to interpret FlushMode in named query hint: " + this.queryName, (Throwable)((Object)e));
        }
    }

    public LockMode getLockMode(String query) {
        String hitName = "org.hibernate.lockMode";
        String value = (String)this.hintsMap.get(hitName);
        if (value == null) {
            return null;
        }
        try {
            return LockMode.fromExternalForm(value);
        }
        catch (MappingException e) {
            throw new AnnotationException("Unknown LockMode in hint: " + query + ":" + hitName, (Throwable)((Object)e));
        }
    }

    public LockOptions determineLockOptions(NamedQuery namedQueryAnnotation) {
        LockModeType lockModeType = namedQueryAnnotation.lockMode();
        Integer lockTimeoutHint = this.specLockTimeout();
        Boolean followOnLocking = this.getBooleanWrapper("hibernate.query.followOnLocking");
        return this.determineLockOptions(lockModeType, lockTimeoutHint, followOnLocking);
    }

    private Integer specLockTimeout() {
        Integer jakartaLockTimeout = this.getInteger("jakarta.persistence.lock.timeout");
        if (jakartaLockTimeout != null) {
            return jakartaLockTimeout;
        }
        return this.getInteger("javax.persistence.lock.timeout");
    }

    private LockOptions determineLockOptions(LockModeType lockModeType, Integer lockTimeoutHint, Boolean followOnLocking) {
        LockOptions lockOptions = new LockOptions(LockModeConverter.convertToLockMode(lockModeType)).setFollowOnLocking(followOnLocking);
        if (lockTimeoutHint != null) {
            lockOptions.setTimeOut(lockTimeoutHint);
        }
        return lockOptions;
    }
}

