/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.process.internal;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import org.hibernate.annotations.Immutable;
import org.hibernate.boot.model.convert.internal.ConverterDescriptors;
import org.hibernate.boot.model.convert.spi.ConverterDescriptor;
import org.hibernate.boot.model.convert.spi.JpaAttributeConverterCreationContext;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.mapping.BasicValue;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.converter.internal.AttributeConverterMutabilityPlanImpl;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.converter.spi.JpaAttributeConverter;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.internal.CustomMutabilityConvertedBasicTypeImpl;
import org.hibernate.type.internal.CustomMutabilityConvertedPrimitiveBasicTypeImpl;
import org.hibernate.type.spi.TypeConfiguration;

public class NamedConverterResolution<J>
implements BasicValue.Resolution<J> {
    private final JavaType<J> domainJtd;
    private final JavaType<?> relationalJtd;
    private final JdbcType jdbcType;
    private final JpaAttributeConverter<J, ?> valueConverter;
    private final MutabilityPlan<J> mutabilityPlan;
    private final JdbcMapping jdbcMapping;
    private final BasicType<J> legacyResolvedType;

    public static <T> NamedConverterResolution<T> from(ConverterDescriptor<T, ?> converterDescriptor, Function<TypeConfiguration, BasicJavaType<?>> explicitJtdAccess, Function<TypeConfiguration, JdbcType> explicitStdAccess, Function<TypeConfiguration, MutabilityPlan<?>> explicitMutabilityPlanAccess, Type resolvedJavaType, JdbcTypeIndicators sqlTypeIndicators, JpaAttributeConverterCreationContext converterCreationContext, MetadataBuildingContext context) {
        return NamedConverterResolution.fromInternal(explicitJtdAccess, explicitStdAccess, explicitMutabilityPlanAccess, NamedConverterResolution.converter(converterCreationContext, converterDescriptor), resolvedJavaType, sqlTypeIndicators, context);
    }

    public static <T> NamedConverterResolution<T> from(String name, Function<TypeConfiguration, BasicJavaType<?>> explicitJtdAccess, Function<TypeConfiguration, JdbcType> explicitStdAccess, Function<TypeConfiguration, MutabilityPlan<?>> explicitMutabilityPlanAccess, JdbcTypeIndicators sqlTypeIndicators, JpaAttributeConverterCreationContext converterCreationContext, MetadataBuildingContext context) {
        assert (name.startsWith("converted::"));
        String converterClassName = name.substring("converted::".length());
        BootstrapContext bootstrapContext = context.getBootstrapContext();
        Class converterClass = bootstrapContext.getClassLoaderService().classForName(converterClassName);
        ConverterDescriptor converterDescriptor = ConverterDescriptors.of(converterClass, bootstrapContext.getClassmateContext());
        return NamedConverterResolution.fromInternal(explicitJtdAccess, explicitStdAccess, explicitMutabilityPlanAccess, NamedConverterResolution.converter(converterCreationContext, converterDescriptor), null, sqlTypeIndicators, context);
    }

    private static <T, S> JpaAttributeConverter<T, S> converter(JpaAttributeConverterCreationContext converterCreationContext, ConverterDescriptor<T, S> converterDescriptor) {
        return converterDescriptor.createJpaAttributeConverter(converterCreationContext);
    }

    private static <T, S> NamedConverterResolution<T> fromInternal(Function<TypeConfiguration, BasicJavaType<?>> explicitJtdAccess, Function<TypeConfiguration, JdbcType> explicitStdAccess, Function<TypeConfiguration, MutabilityPlan<?>> explicitMutabilityPlanAccess, JpaAttributeConverter<T, S> converter, Type resolvedJavaType, JdbcTypeIndicators sqlTypeIndicators, MetadataBuildingContext context) {
        Class clazz;
        TypeConfiguration typeConfiguration = context.getBootstrapContext().getTypeConfiguration();
        JavaType explicitJtd = explicitJtdAccess != null ? (JavaType)explicitJtdAccess.apply(typeConfiguration) : null;
        JavaType domainJtd = explicitJtd != null ? explicitJtd : converter.getDomainJavaType();
        JdbcType explicitJdbcType = explicitStdAccess != null ? explicitStdAccess.apply(typeConfiguration) : null;
        JavaType relationalJtd = converter.getRelationalJavaType();
        JdbcType jdbcType = explicitJdbcType != null ? explicitJdbcType : relationalJtd.getRecommendedJdbcType(sqlTypeIndicators);
        MutabilityPlan<T> mutabilityPlan = NamedConverterResolution.determineMutabilityPlan(explicitMutabilityPlanAccess, typeConfiguration, converter, domainJtd);
        Class primitiveClass = resolvedJavaType instanceof Class && (clazz = (Class)resolvedJavaType).isPrimitive() ? (Class)resolvedJavaType : null;
        return new NamedConverterResolution(domainJtd, relationalJtd, jdbcType, converter, mutabilityPlan, primitiveClass);
    }

    private static <T> MutabilityPlan<T> determineMutabilityPlan(Function<TypeConfiguration, MutabilityPlan<?>> explicitMutabilityPlanAccess, TypeConfiguration typeConfiguration, JpaAttributeConverter<T, ?> converter, JavaType<T> domainJtd) {
        MutabilityPlan<?> explicitMutabilityPlan;
        MutabilityPlan<?> mutabilityPlan = explicitMutabilityPlan = explicitMutabilityPlanAccess != null ? explicitMutabilityPlanAccess.apply(typeConfiguration) : null;
        if (explicitMutabilityPlan != null) {
            return explicitMutabilityPlan;
        }
        if (converter.getConverterJavaType().getJavaTypeClass().isAnnotationPresent(Immutable.class)) {
            return ImmutableMutabilityPlan.instance();
        }
        if (!domainJtd.getMutabilityPlan().isMutable() && !NamedConverterResolution.isCollection(domainJtd.getJavaTypeClass())) {
            return ImmutableMutabilityPlan.instance();
        }
        return new AttributeConverterMutabilityPlanImpl(converter, true);
    }

    private static boolean isCollection(Class<?> javaType) {
        return Collection.class.isAssignableFrom(javaType) || Map.class.isAssignableFrom(javaType);
    }

    private NamedConverterResolution(JavaType<J> domainJtd, JavaType<?> relationalJtd, JdbcType jdbcType, JpaAttributeConverter<J, ?> valueConverter, MutabilityPlan<J> mutabilityPlan, Class<J> primitiveClass) {
        assert (domainJtd != null);
        this.domainJtd = domainJtd;
        assert (relationalJtd != null);
        this.relationalJtd = relationalJtd;
        assert (jdbcType != null);
        this.jdbcType = jdbcType;
        assert (valueConverter != null);
        this.valueConverter = valueConverter;
        assert (mutabilityPlan != null);
        this.mutabilityPlan = mutabilityPlan;
        this.jdbcMapping = this.legacyResolvedType = NamedConverterResolution.legacyResolvedType("converted::" + valueConverter.getConverterJavaType().getTypeName(), String.format("BasicType adapter for AttributeConverter<%s,%s>", domainJtd.getTypeName(), relationalJtd.getTypeName()), jdbcType, valueConverter, primitiveClass, mutabilityPlan);
    }

    private static <J> BasicType<J> legacyResolvedType(String name, String description, JdbcType jdbcType, BasicValueConverter<J, ?> converter, Class<J> primitiveClass, MutabilityPlan<J> mutabilityPlan) {
        if (primitiveClass != null) {
            assert (primitiveClass.isPrimitive());
            return new CustomMutabilityConvertedPrimitiveBasicTypeImpl<J>(name, description, jdbcType, converter, primitiveClass, mutabilityPlan);
        }
        return new CustomMutabilityConvertedBasicTypeImpl<J>(name, description, jdbcType, converter, mutabilityPlan);
    }

    @Override
    public BasicType<J> getLegacyResolvedBasicType() {
        return this.legacyResolvedType;
    }

    @Override
    public JavaType<J> getDomainJavaType() {
        return this.domainJtd;
    }

    @Override
    public JavaType<?> getRelationalJavaType() {
        return this.relationalJtd;
    }

    @Override
    public JdbcType getJdbcType() {
        return this.jdbcType;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.jdbcMapping;
    }

    @Override
    public JpaAttributeConverter<J, ?> getValueConverter() {
        return this.valueConverter;
    }

    @Override
    public MutabilityPlan<J> getMutabilityPlan() {
        return this.mutabilityPlan;
    }

    public String toString() {
        return "NamedConverterResolution(" + this.valueConverter.getConverterBean().getBeanClass().getName() + ")";
    }
}

