/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.source.internal.hbm;

import jakarta.xml.bind.JAXBElement;
import java.io.Serializable;
import java.util.HashMap;
import org.hibernate.boot.MappingException;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmFilterDefinitionType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmFilterParameterType;
import org.hibernate.boot.model.source.internal.hbm.HbmLocalMetadataBuildingContext;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.internal.util.StringHelper;
import org.jboss.logging.Logger;

class FilterDefinitionBinder {
    private static final Logger log = Logger.getLogger(FilterDefinitionBinder.class);

    FilterDefinitionBinder() {
    }

    static void processFilterDefinition(HbmLocalMetadataBuildingContext context, JaxbHbmFilterDefinitionType jaxbFilterDefinitionMapping) {
        HashMap parameterMap = null;
        String condition = jaxbFilterDefinitionMapping.getCondition();
        for (Serializable content : jaxbFilterDefinitionMapping.getContent()) {
            JaxbHbmFilterParameterType jaxbParameterMapping;
            if (content instanceof String) {
                String string = (String)((Object)content);
                String contentString = string.trim();
                if (!StringHelper.isNotEmpty(contentString) || condition == null || !log.isDebugEnabled()) continue;
                log.debugf("filter-def [name=%s, origin=%s] defined multiple conditions, accepting arbitrary one", (Object)jaxbFilterDefinitionMapping.getName(), (Object)context.getOrigin().toString());
                continue;
            }
            if (content instanceof JaxbHbmFilterParameterType) {
                JaxbHbmFilterParameterType filterParameterType;
                jaxbParameterMapping = filterParameterType = (JaxbHbmFilterParameterType)content;
            } else if (content instanceof JAXBElement) {
                JAXBElement jaxbElement = (JAXBElement)content;
                jaxbParameterMapping = (JaxbHbmFilterParameterType)jaxbElement.getValue();
            } else {
                throw new MappingException("Unable to decipher filter-def content type [" + content.getClass().getName() + "]", context.getOrigin());
            }
            if (parameterMap == null) {
                parameterMap = new HashMap();
            }
            parameterMap.put(jaxbParameterMapping.getParameterName(), context.getMetadataCollector().getTypeConfiguration().getBasicTypeRegistry().getRegisteredType(jaxbParameterMapping.getParameterValueTypeName()));
        }
        context.getMetadataCollector().addFilterDefinition(new FilterDefinition(jaxbFilterDefinitionMapping.getName(), condition, parameterMap));
        log.debugf("Processed filter definition : %s", (Object)jaxbFilterDefinitionMapping.getName());
    }
}

