/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.internal.bytebuddy;

import jakarta.persistence.Transient;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.modifier.FieldPersistence;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.StubMethod;
import org.hibernate.Version;
import org.hibernate.bytecode.enhance.internal.bytebuddy.CodeTemplates;
import org.hibernate.bytecode.enhance.spi.CollectionTracker;
import org.hibernate.bytecode.enhance.spi.EnhancementInfo;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;

public final class EnhancerImplConstants {
    final ClassFileLocator adviceLocator;
    final Implementation implementationTrackChange;
    final Implementation implementationGetDirtyAttributesWithoutCollections;
    final Implementation implementationAreFieldsDirtyWithoutCollections;
    final Implementation implementationClearDirtyAttributesWithoutCollections;
    final Implementation implementationSuspendDirtyTracking;
    final Implementation implementationGetDirtyAttributes;
    final Implementation implementationAreFieldsDirty;
    final Implementation implementationGetCollectionTrackerWithoutCollections;
    final Implementation implementationClearDirtyAttributes;
    final Advice adviceInitializeLazyAttributeLoadingInterceptor;
    final Implementation implementationSetOwner;
    final Implementation implementationClearOwner;
    final Implementation implementationSetPersistenceInfo;
    final int methodModifierPUBLIC = ModifierContributor.Resolver.of(List.of(Visibility.PUBLIC)).resolve();
    final int fieldModifierPRIVATE_TRANSIENT = ModifierContributor.Resolver.of(List.of(FieldPersistence.TRANSIENT, Visibility.PRIVATE)).resolve();
    final Collection<? extends AnnotationDescription> TRANSIENT_ANNOTATION = List.of(AnnotationDescription.Builder.ofType(Transient.class).build());
    final List<Annotation> HIBERNATE_VERSION_ANNOTATION = List.of(new EnhancementInfo(){

        @Override
        public String version() {
            return Version.getVersionString();
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return EnhancementInfo.class;
        }
    });
    final TypeDefinition TypeVoid = TypeDescription.ForLoadedType.of(Void.TYPE);
    final TypeDefinition TypeBooleanPrimitive = TypeDescription.ForLoadedType.of(Boolean.TYPE);
    final TypeDefinition TypeIntegerPrimitive = TypeDescription.ForLoadedType.of(Integer.TYPE);
    final TypeDefinition TypeManagedEntity = TypeDescription.ForLoadedType.of(ManagedEntity.class);
    final TypeDefinition TypeEntityEntry = TypeDescription.ForLoadedType.of(EntityEntry.class);
    final TypeDefinition TypePersistentAttributeInterceptor = TypeDescription.ForLoadedType.of(PersistentAttributeInterceptor.class);
    final TypeDefinition TypeObject = TypeDescription.ForLoadedType.of(Object.class);
    final TypeDefinition Type_Array_String = TypeDescription.ForLoadedType.of(String[].class);
    final TypeDefinition TypeCollectionTracker = TypeDescription.ForLoadedType.of(CollectionTracker.class);

    public EnhancerImplConstants() {
        this.adviceLocator = ClassFileLocator.ForClassLoader.of((ClassLoader)CodeTemplates.class.getClassLoader());
        this.implementationTrackChange = Advice.to(CodeTemplates.TrackChange.class, (ClassFileLocator)this.adviceLocator).wrap((Implementation)StubMethod.INSTANCE);
        this.implementationGetDirtyAttributesWithoutCollections = Advice.to(CodeTemplates.GetDirtyAttributesWithoutCollections.class, (ClassFileLocator)this.adviceLocator).wrap((Implementation)StubMethod.INSTANCE);
        this.implementationAreFieldsDirtyWithoutCollections = Advice.to(CodeTemplates.AreFieldsDirtyWithoutCollections.class, (ClassFileLocator)this.adviceLocator).wrap((Implementation)StubMethod.INSTANCE);
        this.implementationClearDirtyAttributesWithoutCollections = Advice.to(CodeTemplates.ClearDirtyAttributesWithoutCollections.class, (ClassFileLocator)this.adviceLocator).wrap((Implementation)StubMethod.INSTANCE);
        this.implementationSuspendDirtyTracking = Advice.to(CodeTemplates.SuspendDirtyTracking.class, (ClassFileLocator)this.adviceLocator).wrap((Implementation)StubMethod.INSTANCE);
        this.implementationGetDirtyAttributes = Advice.to(CodeTemplates.GetDirtyAttributes.class, (ClassFileLocator)this.adviceLocator).wrap((Implementation)StubMethod.INSTANCE);
        this.implementationAreFieldsDirty = Advice.to(CodeTemplates.AreFieldsDirty.class, (ClassFileLocator)this.adviceLocator).wrap((Implementation)StubMethod.INSTANCE);
        this.implementationGetCollectionTrackerWithoutCollections = Advice.to(CodeTemplates.GetCollectionTrackerWithoutCollections.class, (ClassFileLocator)this.adviceLocator).wrap((Implementation)StubMethod.INSTANCE);
        this.implementationClearDirtyAttributes = Advice.to(CodeTemplates.ClearDirtyAttributes.class, (ClassFileLocator)this.adviceLocator).wrap((Implementation)StubMethod.INSTANCE);
        this.adviceInitializeLazyAttributeLoadingInterceptor = Advice.to(CodeTemplates.InitializeLazyAttributeLoadingInterceptor.class, (ClassFileLocator)this.adviceLocator);
        this.implementationSetOwner = Advice.to(CodeTemplates.SetOwner.class, (ClassFileLocator)this.adviceLocator).wrap((Implementation)StubMethod.INSTANCE);
        this.implementationClearOwner = Advice.to(CodeTemplates.ClearOwner.class, (ClassFileLocator)this.adviceLocator).wrap((Implementation)StubMethod.INSTANCE);
        this.implementationSetPersistenceInfo = Advice.to(CodeTemplates.SetPersistenceInfo.class, (ClassFileLocator)this.adviceLocator).wrap((Implementation)StubMethod.INSTANCE);
    }
}

