/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.cache.spi.QueryKey;
import org.hibernate.cache.spi.QueryResultsCache;
import org.hibernate.cache.spi.QueryResultsRegion;
import org.hibernate.cache.spi.SecondLevelCacheLogger;
import org.hibernate.cache.spi.TimestampsCache;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.monitor.spi.DiagnosticEvent;
import org.hibernate.event.monitor.spi.EventMonitor;

public class QueryResultsCacheImpl
implements QueryResultsCache {
    private final QueryResultsRegion cacheRegion;
    private final TimestampsCache timestampsCache;

    QueryResultsCacheImpl(QueryResultsRegion cacheRegion, TimestampsCache timestampsCache) {
        this.cacheRegion = cacheRegion;
        this.timestampsCache = timestampsCache;
    }

    @Override
    public QueryResultsRegion getRegion() {
        return this.cacheRegion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean put(QueryKey key, List<?> results, SharedSessionContractImplementor session) throws HibernateException {
        if (SecondLevelCacheLogger.L2CACHE_LOGGER.isDebugEnabled()) {
            SecondLevelCacheLogger.L2CACHE_LOGGER.debugf("Caching query results in region: %s; timestamp=%s", this.cacheRegion.getName(), session.getCacheTransactionSynchronization().getCachingTimestamp());
        }
        CacheItem cacheItem = new CacheItem(session.getCacheTransactionSynchronization().getCachingTimestamp(), QueryResultsCacheImpl.deepCopy(results));
        EventMonitor eventMonitor = session.getEventMonitor();
        DiagnosticEvent cachePutEvent = eventMonitor.beginCachePutEvent();
        try {
            session.getEventListenerManager().cachePutStart();
            this.cacheRegion.putIntoCache(key, cacheItem, session);
        }
        finally {
            eventMonitor.completeCachePutEvent(cachePutEvent, session, this.cacheRegion, true, EventMonitor.CacheActionDescription.QUERY_RESULT);
            session.getEventListenerManager().cachePutEnd();
        }
        return true;
    }

    private static <T> List<T> deepCopy(List<T> results) {
        return new ArrayList<T>(results);
    }

    @Override
    public List<?> get(QueryKey key, Set<String> spaces, SharedSessionContractImplementor session) throws HibernateException {
        CacheItem cacheItem;
        boolean loggerDebugEnabled = SecondLevelCacheLogger.L2CACHE_LOGGER.isDebugEnabled();
        if (loggerDebugEnabled) {
            SecondLevelCacheLogger.L2CACHE_LOGGER.debugf("Checking cached query results in region: %s", this.cacheRegion.getName());
        }
        if ((cacheItem = this.getCachedData(key, session)) == null) {
            if (loggerDebugEnabled) {
                SecondLevelCacheLogger.L2CACHE_LOGGER.debug("Query results were not found in cache");
            }
            return null;
        }
        if (!this.timestampsCache.isUpToDate(spaces, cacheItem.timestamp, session)) {
            if (loggerDebugEnabled) {
                SecondLevelCacheLogger.L2CACHE_LOGGER.debug("Cached query results were not up-to-date");
            }
            return null;
        }
        if (loggerDebugEnabled) {
            SecondLevelCacheLogger.L2CACHE_LOGGER.debug("Returning cached query results");
        }
        return cacheItem.results;
    }

    @Override
    public List<?> get(QueryKey key, String[] spaces, SharedSessionContractImplementor session) throws HibernateException {
        CacheItem cacheItem;
        boolean loggerDebugEnabled = SecondLevelCacheLogger.L2CACHE_LOGGER.isDebugEnabled();
        if (loggerDebugEnabled) {
            SecondLevelCacheLogger.L2CACHE_LOGGER.debugf("Checking cached query results in region: %s", this.cacheRegion.getName());
        }
        if ((cacheItem = this.getCachedData(key, session)) == null) {
            if (loggerDebugEnabled) {
                SecondLevelCacheLogger.L2CACHE_LOGGER.debug("Query results were not found in cache");
            }
            return null;
        }
        if (!this.timestampsCache.isUpToDate(spaces, cacheItem.timestamp, session)) {
            if (loggerDebugEnabled) {
                SecondLevelCacheLogger.L2CACHE_LOGGER.debug("Cached query results were not up-to-date");
            }
            return null;
        }
        if (loggerDebugEnabled) {
            SecondLevelCacheLogger.L2CACHE_LOGGER.debug("Returning cached query results");
        }
        return QueryResultsCacheImpl.deepCopy(cacheItem.results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheItem getCachedData(QueryKey key, SharedSessionContractImplementor session) {
        CacheItem cachedItem = null;
        EventMonitor eventMonitor = session.getEventMonitor();
        DiagnosticEvent cacheGetEvent = eventMonitor.beginCacheGetEvent();
        try {
            session.getEventListenerManager().cacheGetStart();
            cachedItem = (CacheItem)this.cacheRegion.getFromCache(key, session);
            eventMonitor.completeCacheGetEvent(cacheGetEvent, session, this.cacheRegion, cachedItem != null);
            session.getEventListenerManager().cacheGetEnd(cachedItem != null);
        }
        catch (Throwable throwable) {
            eventMonitor.completeCacheGetEvent(cacheGetEvent, session, this.cacheRegion, cachedItem != null);
            session.getEventListenerManager().cacheGetEnd(cachedItem != null);
            throw throwable;
        }
        return cachedItem;
    }

    public String toString() {
        return "QueryResultsCache(" + this.cacheRegion.getName() + ")";
    }

    static class CacheItem
    implements Serializable {
        private final Long timestamp;
        private final List<?> results;

        CacheItem(long timestamp, List<?> results) {
            this.timestamp = timestamp;
            this.results = results;
        }
    }
}

