/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.internal;

import java.util.Collection;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.TimestampsCache;
import org.hibernate.cache.spi.TimestampsRegion;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.monitor.spi.DiagnosticEvent;
import org.hibernate.event.monitor.spi.EventMonitor;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.jboss.logging.Logger;

public class TimestampsCacheEnabledImpl
implements TimestampsCache {
    private static final Logger log = Logger.getLogger(TimestampsCacheEnabledImpl.class);
    public static final boolean DEBUG_ENABLED = log.isDebugEnabled();
    private final TimestampsRegion timestampsRegion;

    public TimestampsCacheEnabledImpl(TimestampsRegion timestampsRegion) {
        this.timestampsRegion = timestampsRegion;
    }

    @Override
    public TimestampsRegion getRegion() {
        return this.timestampsRegion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preInvalidate(String[] spaces, SharedSessionContractImplementor session) {
        SessionFactoryImplementor factory = session.getFactory();
        RegionFactory regionFactory = factory.getCache().getRegionFactory();
        StatisticsImplementor statistics = factory.getStatistics();
        boolean stats = statistics.isStatisticsEnabled();
        Long timestamp = regionFactory.nextTimestamp() + regionFactory.getTimeout();
        SessionEventListenerManager eventListenerManager = session.getEventListenerManager();
        boolean debugEnabled = log.isDebugEnabled();
        for (String space : spaces) {
            if (debugEnabled) {
                log.debugf("Pre-invalidating space [%s], timestamp: %s", (Object)space, (Object)timestamp);
            }
            EventMonitor eventMonitor = session.getEventMonitor();
            DiagnosticEvent cachePutEvent = eventMonitor.beginCachePutEvent();
            try {
                eventListenerManager.cachePutStart();
                this.timestampsRegion.putIntoCache(space, timestamp, session);
            }
            finally {
                eventMonitor.completeCachePutEvent(cachePutEvent, session, this.timestampsRegion, true, EventMonitor.CacheActionDescription.TIMESTAMP_PRE_INVALIDATE);
                eventListenerManager.cachePutEnd();
            }
            if (!stats) continue;
            statistics.updateTimestampsCachePut();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate(String[] spaces, SharedSessionContractImplementor session) {
        StatisticsImplementor statistics = session.getFactory().getStatistics();
        boolean stats = statistics.isStatisticsEnabled();
        Long ts = session.getFactory().getCache().getRegionFactory().nextTimestamp();
        boolean debugEnabled = log.isDebugEnabled();
        for (String space : spaces) {
            if (debugEnabled) {
                log.debugf("Invalidating space [%s], timestamp: %s", (Object)space, (Object)ts);
            }
            SessionEventListenerManager eventListenerManager = session.getEventListenerManager();
            EventMonitor eventMonitor = session.getEventMonitor();
            DiagnosticEvent cachePutEvent = eventMonitor.beginCachePutEvent();
            try {
                eventListenerManager.cachePutStart();
                this.timestampsRegion.putIntoCache(space, ts, session);
            }
            finally {
                eventMonitor.completeCachePutEvent(cachePutEvent, session, this.timestampsRegion, true, EventMonitor.CacheActionDescription.TIMESTAMP_INVALIDATE);
                eventListenerManager.cachePutEnd();
                if (stats) {
                    statistics.updateTimestampsCachePut();
                }
            }
        }
    }

    @Override
    public boolean isUpToDate(String[] spaces, Long timestamp, SharedSessionContractImplementor session) {
        StatisticsImplementor statistics = session.getFactory().getStatistics();
        for (String space : spaces) {
            if (!this.isSpaceOutOfDate(space, timestamp, session, statistics)) continue;
            return false;
        }
        return true;
    }

    private boolean isSpaceOutOfDate(String space, Long timestamp, SharedSessionContractImplementor session, StatisticsImplementor statistics) {
        Long lastUpdate = this.getLastUpdateTimestampForSpace(space, session);
        if (lastUpdate == null) {
            if (statistics.isStatisticsEnabled()) {
                statistics.updateTimestampsCacheMiss();
            }
            return false;
        }
        if (DEBUG_ENABLED) {
            log.debugf("[%s] last update timestamp: %s", (Object)space, (Object)(lastUpdate + ", result set timestamp: " + timestamp));
        }
        if (statistics.isStatisticsEnabled()) {
            statistics.updateTimestampsCacheHit();
        }
        return lastUpdate >= timestamp;
    }

    @Override
    public boolean isUpToDate(Collection<String> spaces, Long timestamp, SharedSessionContractImplementor session) {
        StatisticsImplementor statistics = session.getFactory().getStatistics();
        for (String space : spaces) {
            if (!this.isSpaceOutOfDate(space, timestamp, session, statistics)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long getLastUpdateTimestampForSpace(String space, SharedSessionContractImplementor session) {
        boolean found = false;
        EventMonitor eventMonitor = session.getEventMonitor();
        DiagnosticEvent cacheGetEvent = eventMonitor.beginCacheGetEvent();
        try {
            session.getEventListenerManager().cacheGetStart();
            Long timestamp = (Long)this.timestampsRegion.getFromCache(space, session);
            found = timestamp != null;
            Long l = timestamp;
            return l;
        }
        finally {
            eventMonitor.completeCacheGetEvent(cacheGetEvent, session, this.timestampsRegion, found);
            session.getEventListenerManager().cacheGetEnd(found);
        }
    }
}

