/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection.spi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.Incubating;
import org.hibernate.collection.spi.AbstractPersistentCollection;
import org.hibernate.collection.spi.CollectionSemantics;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.type.Type;

@Incubating
public class PersistentBag<E>
extends AbstractPersistentCollection<E>
implements List<E> {
    @Deprecated(forRemoval=true, since="7")
    protected List<E> bag;
    protected Collection<E> collection;

    public PersistentBag() {
    }

    public PersistentBag(SharedSessionContractImplementor session) {
        super(session);
    }

    public PersistentBag(SharedSessionContractImplementor session, Collection<E> coll) {
        super(session);
        this.setCollection(coll);
        this.setInitialized();
        this.setDirectlyAccessible(true);
    }

    private void setCollection(Collection<E> bag) {
        List list;
        this.collection = bag;
        this.bag = bag instanceof List ? (list = (List)bag) : null;
    }

    protected List<E> bagAsList() {
        if (this.bag == null) {
            throw new IllegalStateException("Bag is not a list: " + this.collection.getClass().getName());
        }
        return this.bag;
    }

    @Override
    public boolean isWrapper(Object collection) {
        return this.collection == collection;
    }

    @Override
    public boolean empty() {
        return this.collection.isEmpty();
    }

    @Override
    public Iterator<E> entries(CollectionPersister persister) {
        return this.collection.iterator();
    }

    @Override
    public void injectLoadedState(PluralAttributeMapping attributeMapping, List<?> loadingState) {
        assert (this.collection == null);
        CollectionPersister collectionDescriptor = attributeMapping.getCollectionDescriptor();
        CollectionSemantics<?, ?> collectionSemantics = collectionDescriptor.getCollectionSemantics();
        int elementCount = loadingState == null ? 0 : loadingState.size();
        this.setCollection((Collection)collectionSemantics.instantiateRaw(elementCount, collectionDescriptor));
        if (loadingState != null) {
            for (int i = 0; i < elementCount; ++i) {
                this.collection.add(loadingState.get(i));
            }
        }
    }

    @Override
    public boolean equalsSnapshot(CollectionPersister persister) throws HibernateException {
        List<Object> instancesSn;
        List<Object> instancesBag;
        Integer hash;
        Type elementType = persister.getElementType();
        List sn = (List)((Object)this.getSnapshot());
        if (sn.size() != this.collection.size()) {
            return false;
        }
        Map<Integer, List<Object>> hashToInstancesBag = this.groupByEqualityHash(this.collection, elementType);
        Map<Integer, List<Object>> hashToInstancesSn = this.groupByEqualityHash(sn, elementType);
        if (hashToInstancesBag.size() != hashToInstancesSn.size()) {
            return false;
        }
        for (Map.Entry<Integer, List<Object>> hashToInstancesBagEntry : hashToInstancesBag.entrySet()) {
            hash = hashToInstancesBagEntry.getKey();
            instancesBag = hashToInstancesBagEntry.getValue();
            instancesSn = hashToInstancesSn.get(hash);
            if (instancesSn != null && instancesBag.size() == instancesSn.size()) continue;
            return false;
        }
        for (Map.Entry<Integer, List<Object>> hashToInstancesBagEntry : hashToInstancesBag.entrySet()) {
            hash = hashToInstancesBagEntry.getKey();
            instancesBag = hashToInstancesBagEntry.getValue();
            instancesSn = hashToInstancesSn.get(hash);
            for (Object instance : instancesBag) {
                if (this.expectOccurrences(instance, instancesBag, elementType, this.countOccurrences(instance, instancesSn, elementType))) continue;
                return false;
            }
        }
        return true;
    }

    private Map<Integer, List<Object>> groupByEqualityHash(Collection<?> searchedBag, Type elementType) {
        if (searchedBag.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Integer, List<Object>> map = new HashMap<Integer, List<Object>>();
        for (Object o : searchedBag) {
            map.computeIfAbsent(this.nullableHashCode(o, elementType), k -> new ArrayList()).add(o);
        }
        return map;
    }

    private Integer nullableHashCode(Object o, Type elementType) {
        if (o == null) {
            return null;
        }
        return elementType.getHashCode(o);
    }

    @Override
    public boolean isSnapshotEmpty(Serializable snapshot) {
        return ((Collection)((Object)snapshot)).isEmpty();
    }

    private int countOccurrences(Object element, List<Object> list, Type elementType) {
        int result = 0;
        for (Object listElement : list) {
            if (!elementType.isSame(element, listElement)) continue;
            ++result;
        }
        return result;
    }

    private boolean expectOccurrences(Object element, List<Object> list, Type elementType, int expected) {
        int result = 0;
        for (Object listElement : list) {
            if (!elementType.isSame(element, listElement) || result++ <= expected) continue;
            return false;
        }
        return result == expected;
    }

    @Override
    public Serializable getSnapshot(CollectionPersister persister) throws HibernateException {
        ArrayList<Object> clonedList = new ArrayList<Object>(this.collection.size());
        for (E item : this.collection) {
            clonedList.add(persister.getElementType().deepCopy(item, persister.getFactory()));
        }
        return clonedList;
    }

    @Override
    public Collection<E> getOrphans(Serializable snapshot, String entityName) throws HibernateException {
        List sn = (List)((Object)snapshot);
        return PersistentBag.getOrphans(sn, this.collection, entityName, this.getSession());
    }

    @Override
    public void initializeEmptyCollection(CollectionPersister persister) {
        assert (this.collection == null);
        this.setCollection((Collection)persister.getCollectionSemantics().instantiateRaw(0, persister));
        this.endRead();
    }

    @Override
    public Object disassemble(CollectionPersister persister) {
        int length = this.collection.size();
        Serializable[] result = new Serializable[length];
        int i = 0;
        for (E element : this.collection) {
            result[i++] = persister.getElementType().disassemble(element, this.getSession(), null);
        }
        return result;
    }

    @Override
    public void initializeFromCache(CollectionPersister collectionDescriptor, Object disassembled, Object owner) throws HibernateException {
        assert (this.collection == null);
        Serializable[] array = (Serializable[])disassembled;
        int size = array.length;
        this.setCollection((Collection)collectionDescriptor.getCollectionSemantics().instantiateRaw(size, collectionDescriptor));
        for (Serializable item : array) {
            Object element = collectionDescriptor.getElementType().assemble(item, this.getSession(), owner);
            if (element == null) continue;
            this.collection.add(element);
        }
    }

    @Override
    public boolean needsRecreate(CollectionPersister persister) {
        return !persister.isOneToMany();
    }

    @Override
    public Iterator<?> getDeletes(CollectionPersister persister, boolean indexIsFormula) throws HibernateException {
        Type elementType = persister.getElementType();
        ArrayList deletes = new ArrayList();
        List sn = (List)((Object)this.getSnapshot());
        Iterator olditer = sn.iterator();
        int i = 0;
        Iterator<E> bagiter = this.collection.iterator();
        while (olditer.hasNext()) {
            Object old = olditer.next();
            Iterator<E> newiter = this.collection.iterator();
            boolean found = false;
            if (this.collection.size() > i && i++ > 0 && elementType.isSame(old, bagiter.next())) {
                found = true;
            } else {
                while (newiter.hasNext()) {
                    if (!elementType.isSame(old, newiter.next())) continue;
                    found = true;
                    break;
                }
            }
            if (found) continue;
            deletes.add(old);
        }
        return deletes.iterator();
    }

    @Override
    public boolean needsInserting(Object entry, int i, Type elemType) throws HibernateException {
        List sn = (List)((Object)this.getSnapshot());
        if (sn.size() > i && elemType.isSame(sn.get(i), entry)) {
            return false;
        }
        for (Object old : sn) {
            if (!elemType.isSame(old, entry)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isRowUpdatePossible() {
        return false;
    }

    @Override
    public boolean needsUpdating(Object entry, int i, Type elemType) {
        return false;
    }

    @Override
    public int size() {
        return this.readSize() ? this.getCachedSize() : this.collection.size();
    }

    @Override
    public boolean isEmpty() {
        return this.readSize() ? this.getCachedSize() == 0 : this.collection.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        Boolean exists = this.readElementExistence(object);
        return exists == null ? this.collection.contains(object) : exists.booleanValue();
    }

    @Override
    public Iterator<E> iterator() {
        this.read();
        return new AbstractPersistentCollection.IteratorProxy<E>(this.collection.iterator());
    }

    @Override
    public Object[] toArray() {
        this.read();
        return this.collection.toArray();
    }

    @Override
    public <A> A[] toArray(A[] a) {
        this.read();
        return this.collection.toArray(a);
    }

    @Override
    public boolean add(E object) {
        if (!this.isOperationQueueEnabled()) {
            this.write();
            return this.collection.add(object);
        }
        this.queueOperation(new SimpleAdd(object));
        return true;
    }

    @Override
    public boolean remove(Object o) {
        this.initialize(true);
        if (this.collection.remove(o)) {
            this.elementRemoved = true;
            this.dirty();
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.read();
        return this.collection.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> values) {
        if (values.isEmpty()) {
            return false;
        }
        if (!this.isOperationQueueEnabled()) {
            this.write();
            return this.collection.addAll(values);
        }
        for (E value : values) {
            this.queueOperation(new SimpleAdd(value));
        }
        return values.size() > 0;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (c.size() > 0) {
            this.initialize(true);
            if (this.collection.removeAll(c)) {
                this.elementRemoved = true;
                this.dirty();
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.initialize(true);
        if (this.collection.retainAll(c)) {
            this.dirty();
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.isClearQueueEnabled()) {
            this.queueOperation(new Clear());
        } else {
            this.initialize(true);
            if (!this.collection.isEmpty()) {
                this.collection.clear();
                this.dirty();
            }
        }
    }

    @Override
    public Object getIndex(Object entry, int i, CollectionPersister persister) {
        throw new UnsupportedOperationException("Bags don't have indexes : " + persister.getRole());
    }

    @Override
    public Object getElement(Object entry) {
        return entry;
    }

    @Override
    public Object getSnapshotElement(Object entry, int i) {
        List sn = (List)((Object)this.getSnapshot());
        return sn.get(i);
    }

    public int occurrences(Object o) {
        this.read();
        Iterator<E> itr = this.collection.iterator();
        int result = 0;
        while (itr.hasNext()) {
            if (!o.equals(itr.next())) continue;
            ++result;
        }
        return result;
    }

    @Override
    public void add(int i, E o) {
        this.write();
        this.bagAsList().add(i, o);
    }

    @Override
    public boolean addAll(int i, Collection<? extends E> c) {
        if (c.size() > 0) {
            this.write();
            return this.bagAsList().addAll(i, c);
        }
        return false;
    }

    @Override
    public E get(int i) {
        this.read();
        return this.bagAsList().get(i);
    }

    @Override
    public int indexOf(Object o) {
        this.read();
        return this.bagAsList().indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        this.read();
        return this.bagAsList().lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        this.read();
        return new AbstractPersistentCollection.ListIteratorProxy(this.bagAsList().listIterator());
    }

    @Override
    public ListIterator<E> listIterator(int i) {
        this.read();
        return new AbstractPersistentCollection.ListIteratorProxy(this.bagAsList().listIterator(i));
    }

    @Override
    public E remove(int i) {
        this.write();
        return this.bagAsList().remove(i);
    }

    @Override
    public E set(int i, E o) {
        this.write();
        return this.bagAsList().set(i, o);
    }

    @Override
    public List<E> subList(int start, int end) {
        this.read();
        return new AbstractPersistentCollection.ListProxy(this.bagAsList().subList(start, end));
    }

    @Override
    public boolean entryExists(Object entry, int i) {
        return entry != null;
    }

    public String toString() {
        this.read();
        return this.collection.toString();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    final class SimpleAdd
    extends AbstractPersistentCollection.AbstractValueDelayedOperation {
        public SimpleAdd(E addedValue) {
            super(addedValue, null);
        }

        @Override
        public void operate() {
            if (!PersistentBag.this.collection.contains(this.getAddedInstance())) {
                PersistentBag.this.collection.add(this.getAddedInstance());
            }
        }
    }

    final class Clear
    implements AbstractPersistentCollection.DelayedOperation<E> {
        Clear() {
        }

        @Override
        public void operate() {
            PersistentBag.this.collection.clear();
        }

        @Override
        public E getAddedInstance() {
            return null;
        }

        @Override
        public E getOrphan() {
            throw new UnsupportedOperationException("queued clear cannot be used with orphan delete");
        }
    }

    final class SimpleRemove
    extends AbstractPersistentCollection.AbstractValueDelayedOperation {
        public SimpleRemove(E orphan) {
            super(null, orphan);
        }

        @Override
        public void operate() {
            PersistentBag.this.collection.remove(this.getOrphan());
        }
    }
}

