/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection.spi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.Incubating;
import org.hibernate.collection.spi.AbstractPersistentCollection;
import org.hibernate.collection.spi.CollectionSemantics;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.EventType;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.type.Type;

@Incubating
public class PersistentIdentifierBag<E>
extends AbstractPersistentCollection<E>
implements List<E> {
    @Deprecated(forRemoval=true, since="7")
    protected List<E> values;
    protected Map<Integer, Object> identifiers;
    protected Collection<E> collection;

    public PersistentIdentifierBag() {
    }

    public PersistentIdentifierBag(SharedSessionContractImplementor session) {
        super(session);
    }

    public PersistentIdentifierBag(SharedSessionContractImplementor session, Collection<E> coll) {
        super(session);
        this.setCollection(coll);
        this.setInitialized();
        this.setDirectlyAccessible(true);
        this.identifiers = new HashMap<Integer, Object>();
    }

    private void setCollection(Collection<E> bag) {
        List list;
        this.collection = bag;
        this.values = bag instanceof List ? (list = (List)bag) : null;
    }

    protected List<E> bagAsList() {
        if (this.values == null) {
            throw new IllegalStateException("Bag is not a list: " + this.collection.getClass().getName());
        }
        return this.values;
    }

    @Override
    public void initializeFromCache(CollectionPersister persister, Object disassembled, Object owner) throws HibernateException {
        Serializable[] array = (Serializable[])disassembled;
        int size = array.length;
        assert (this.identifiers == null);
        assert (this.collection == null);
        this.identifiers = new HashMap<Integer, Object>();
        this.setCollection((Collection)persister.getCollectionSemantics().instantiateRaw(size, persister));
        for (int i = 0; i < size; i += 2) {
            this.identifiers.put(i / 2, persister.getIdentifierType().assemble(array[i], this.getSession(), owner));
            this.collection.add(persister.getElementType().assemble(array[i + 1], this.getSession(), owner));
        }
    }

    @Override
    public Object getIdentifier(Object entry, int i) {
        return this.identifiers.get(i);
    }

    @Override
    public boolean isWrapper(Object collection) {
        return this.collection == collection;
    }

    @Override
    public boolean add(E o) {
        this.write();
        this.collection.add(o);
        return true;
    }

    @Override
    public void clear() {
        this.initialize(true);
        if (!this.collection.isEmpty() || !this.identifiers.isEmpty()) {
            this.collection.clear();
            this.identifiers.clear();
            this.dirty();
        }
    }

    @Override
    public boolean contains(Object o) {
        this.read();
        return this.collection.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.read();
        return this.collection.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.readSize() ? this.getCachedSize() == 0 : this.collection.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        this.read();
        return new AbstractPersistentCollection.IteratorProxy<E>(this.collection.iterator());
    }

    @Override
    public boolean remove(Object o) {
        this.initialize(true);
        int index = this.bagAsList().indexOf(o);
        if (index >= 0) {
            this.beforeRemove(index);
            this.bagAsList().remove(index);
            this.elementRemoved = true;
            this.dirty();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection c) {
        if (c.size() > 0) {
            boolean result = false;
            for (Object element : c) {
                if (!this.remove(element)) continue;
                result = true;
            }
            return result;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.initialize(true);
        if (this.collection.retainAll(c)) {
            this.dirty();
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.readSize() ? this.getCachedSize() : this.collection.size();
    }

    @Override
    public Object[] toArray() {
        this.read();
        return this.collection.toArray();
    }

    @Override
    public <A> A[] toArray(A[] a) {
        this.read();
        return this.collection.toArray(a);
    }

    @Override
    public Object disassemble(CollectionPersister persister) {
        Serializable[] result = new Serializable[this.collection.size() * 2];
        int i = 0;
        int j = 0;
        for (E value : this.collection) {
            result[i++] = persister.getIdentifierType().disassemble(this.identifiers.get(j), this.getSession(), null);
            result[i++] = persister.getElementType().disassemble(value, this.getSession(), null);
            ++j;
        }
        return result;
    }

    @Override
    public boolean empty() {
        return this.collection.isEmpty();
    }

    @Override
    public Iterator<E> entries(CollectionPersister persister) {
        return this.collection.iterator();
    }

    @Override
    public boolean entryExists(Object entry, int i) {
        return entry != null;
    }

    @Override
    public boolean equalsSnapshot(CollectionPersister persister) throws HibernateException {
        Type elementType = persister.getElementType();
        Map snap = (Map)((Object)this.getSnapshot());
        if (snap.size() != this.collection.size()) {
            return false;
        }
        int i = 0;
        for (E value : this.collection) {
            Object id;
            if ((id = this.identifiers.get(i++)) == null) {
                return false;
            }
            Object old = snap.get(id);
            if (!elementType.isDirty(old, value, this.getSession())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSnapshotEmpty(Serializable snapshot) {
        return ((Map)((Object)snapshot)).isEmpty();
    }

    @Override
    public Iterator<?> getDeletes(CollectionPersister persister, boolean indexIsFormula) throws HibernateException {
        Map snap = (Map)((Object)this.getSnapshot());
        ArrayList deletes = new ArrayList(snap.keySet());
        int i = 0;
        for (E value : this.collection) {
            if (value != null) {
                deletes.remove(this.identifiers.get(i));
            }
            ++i;
        }
        return deletes.iterator();
    }

    @Override
    public Object getIndex(Object entry, int i, CollectionPersister persister) {
        throw new UnsupportedOperationException("Bags don't have indexes");
    }

    @Override
    public Object getElement(Object entry) {
        return entry;
    }

    @Override
    public Object getSnapshotElement(Object entry, int i) {
        Map snap = (Map)((Object)this.getSnapshot());
        Object id = this.identifiers.get(i);
        return snap.get(id);
    }

    @Override
    public boolean needsInserting(Object entry, int i, Type elemType) throws HibernateException {
        Map snap = (Map)((Object)this.getSnapshot());
        Object id = this.identifiers.get(i);
        return entry != null && (id == null || snap.get(id) == null);
    }

    @Override
    public boolean needsUpdating(Object entry, int i, Type elemType) throws HibernateException {
        if (entry == null) {
            return false;
        }
        Map snap = (Map)((Object)this.getSnapshot());
        Object id = this.identifiers.get(i);
        if (id == null) {
            return false;
        }
        Object old = snap.get(id);
        return old != null && elemType.isDirty(old, entry, this.getSession());
    }

    @Override
    public Serializable getSnapshot(CollectionPersister persister) throws HibernateException {
        HashMap<Object, Object> map = CollectionHelper.mapOfSize(this.collection.size());
        Iterator<E> iter = this.collection.iterator();
        int i = 0;
        while (iter.hasNext()) {
            E value = iter.next();
            map.put(this.identifiers.get(i++), persister.getElementType().deepCopy(value, persister.getFactory()));
        }
        return map;
    }

    @Override
    public Collection<E> getOrphans(Serializable snapshot, String entityName) throws HibernateException {
        Map sn = (Map)((Object)snapshot);
        return PersistentIdentifierBag.getOrphans(sn.values(), this.collection, entityName, this.getSession());
    }

    @Override
    public void initializeEmptyCollection(CollectionPersister persister) {
        assert (this.identifiers == null);
        this.identifiers = new HashMap<Integer, Object>();
        this.setCollection((Collection)persister.getCollectionSemantics().instantiateRaw(0, persister));
        this.endRead();
    }

    @Override
    public void preInsert(CollectionPersister persister) throws HibernateException {
        Iterator<E> itr = this.collection.iterator();
        int i = 0;
        while (itr.hasNext()) {
            Integer loc;
            E entry = itr.next();
            if (this.identifiers.containsKey(loc = Integer.valueOf(i++))) continue;
            Object id = persister.getGenerator().generate(this.getSession(), entry, null, EventType.INSERT);
            this.identifiers.put(loc, id);
        }
    }

    @Override
    public void add(int index, E element) {
        this.write();
        this.beforeAdd(index);
        this.bagAsList().add(index, element);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        if (c.size() > 0) {
            for (E element : c) {
                this.add(index++, element);
            }
            return true;
        }
        return false;
    }

    @Override
    public E get(int index) {
        this.read();
        return this.bagAsList().get(index);
    }

    @Override
    public int indexOf(Object o) {
        this.read();
        return this.bagAsList().indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        this.read();
        return this.bagAsList().lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        this.read();
        return new AbstractPersistentCollection.ListIteratorProxy(this.bagAsList().listIterator());
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        this.read();
        return new AbstractPersistentCollection.ListIteratorProxy(this.bagAsList().listIterator(index));
    }

    private void beforeRemove(int index) {
        Object removedId = this.identifiers.get(index);
        int last = this.collection.size() - 1;
        for (int i = index; i < last; ++i) {
            Object id = this.identifiers.get(i + 1);
            if (id == null) {
                this.identifiers.remove(i);
                continue;
            }
            this.identifiers.put(i, id);
        }
        this.identifiers.put(last, removedId);
    }

    private void beforeAdd(int index) {
        for (int i = index; i < this.collection.size(); ++i) {
            this.identifiers.put(i + 1, this.identifiers.get(i));
        }
        this.identifiers.remove(index);
    }

    @Override
    public E remove(int index) {
        this.write();
        this.beforeRemove(index);
        return this.bagAsList().remove(index);
    }

    @Override
    public E set(int index, E element) {
        this.write();
        return this.bagAsList().set(index, element);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        this.read();
        return new AbstractPersistentCollection.ListProxy(this.bagAsList().subList(fromIndex, toIndex));
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (c.size() > 0) {
            this.write();
            return this.collection.addAll(c);
        }
        return false;
    }

    @Override
    public void afterRowInsert(CollectionPersister persister, Object entry, int i) throws HibernateException {
    }

    @Override
    public void injectLoadedState(PluralAttributeMapping attributeMapping, List<?> loadingState) {
        assert (this.identifiers == null);
        assert (this.collection == null);
        CollectionPersister collectionDescriptor = attributeMapping.getCollectionDescriptor();
        CollectionSemantics<?, ?> collectionSemantics = collectionDescriptor.getCollectionSemantics();
        int elementCount = loadingState == null ? 0 : loadingState.size();
        this.identifiers = new HashMap<Integer, Object>();
        this.setCollection((Collection)collectionSemantics.instantiateRaw(elementCount, collectionDescriptor));
        for (int i = 0; i < loadingState.size(); ++i) {
            Object[] row = (Object[])loadingState.get(i);
            Object identifier = row[0];
            Object element = row[1];
            Object old = this.identifiers.put(this.collection.size(), identifier);
            if (old != null) continue;
            this.collection.add(element);
        }
    }
}

