/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import jakarta.persistence.TemporalType;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.dialect.BooleanDecoder;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DmlTargetColumnQualifierSupport;
import org.hibernate.dialect.FunctionalDependencyAnalysisSupport;
import org.hibernate.dialect.FunctionalDependencyAnalysisSupportImpl;
import org.hibernate.dialect.NullOrdering;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.TrimFunction;
import org.hibernate.dialect.identity.HSQLIdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.OffsetFetchLimitHandler;
import org.hibernate.dialect.sequence.HSQLSequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.dialect.sql.ast.HSQLSqlAstTranslator;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.dialect.temptable.TemporaryTableKind;
import org.hibernate.dialect.unique.CreateTableUniqueDelegate;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelperBuilder;
import org.hibernate.engine.jdbc.env.spi.NameQualifierSupport;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtractor;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.query.common.TemporalUnit;
import org.hibernate.query.sqm.CastType;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.mutation.internal.temptable.LocalTemporaryTableInsertStrategy;
import org.hibernate.query.sqm.mutation.internal.temptable.LocalTemporaryTableMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.AfterUseAction;
import org.hibernate.query.sqm.mutation.spi.BeforeUseAction;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableInsertStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorHSQLDBDatabaseImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.type.spi.TypeConfiguration;

public class HSQLDialect
extends Dialect {
    private static final DatabaseVersion MINIMUM_VERSION = DatabaseVersion.make(2, 6, 1);
    private final UniqueDelegate uniqueDelegate = new CreateTableUniqueDelegate(this);
    private final HSQLIdentityColumnSupport identityColumnSupport = new HSQLIdentityColumnSupport(this.getVersion());
    private static final ViolatedConstraintNameExtractor EXTRACTOR_20 = new TemplatedViolatedConstraintNameExtractor(sqle -> switch (JdbcExceptionHelper.extractErrorCode(sqle)) {
        case -177, -157, -104, -9, -8 -> TemplatedViolatedConstraintNameExtractor.extractUsingTemplate("; ", " table: ", sqle.getMessage());
        case -10 -> TemplatedViolatedConstraintNameExtractor.extractUsingTemplate(" column: ", "\n", sqle.getMessage());
        default -> null;
    });

    public HSQLDialect(DialectResolutionInfo info) {
        super(info);
    }

    public HSQLDialect() {
        this(MINIMUM_VERSION);
    }

    public HSQLDialect(DatabaseVersion version) {
        super(version);
    }

    @Override
    protected DatabaseVersion getMinimumSupportedVersion() {
        return MINIMUM_VERSION;
    }

    @Override
    protected void registerDefaultKeywords() {
        super.registerDefaultKeywords();
        this.registerKeyword("period");
    }

    @Override
    protected String columnType(int sqlTypeCode) {
        return switch (sqlTypeCode) {
            case 2011 -> "clob";
            default -> super.columnType(sqlTypeCode);
        };
    }

    @Override
    protected Integer resolveSqlTypeCode(String typeName, String baseTypeName, TypeConfiguration typeConfiguration) {
        return switch (baseTypeName) {
            case "DOUBLE" -> 8;
            default -> super.resolveSqlTypeCode(typeName, baseTypeName, typeConfiguration);
        };
    }

    @Override
    public int getDefaultStatementBatchSize() {
        return 15;
    }

    @Override
    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionFactory.avg_castingNonDoubleArguments(this, SqlAstNodeRenderingMode.DEFAULT);
        functionFactory.cot();
        functionFactory.radians();
        functionFactory.degrees();
        functionFactory.log10();
        functionFactory.rand();
        functionFactory.trunc_dateTrunc_trunc();
        functionFactory.pi();
        functionFactory.soundex();
        functionFactory.reverse();
        functionFactory.space();
        functionFactory.repeat();
        functionFactory.translate();
        functionFactory.bitand();
        functionFactory.bitor();
        functionFactory.bitxor();
        functionFactory.bitnot();
        functionFactory.yearMonthDay();
        functionFactory.hourMinuteSecond();
        functionFactory.dayofweekmonthyear();
        functionFactory.weekQuarter();
        functionFactory.daynameMonthname();
        functionFactory.lastDay();
        functionFactory.trim1();
        functionFactory.toCharNumberDateTimestamp();
        functionFactory.concat_pipeOperator();
        functionFactory.localtimeLocaltimestamp();
        functionFactory.bitLength();
        functionFactory.octetLength();
        functionFactory.ascii();
        functionFactory.chr_char();
        functionFactory.instr();
        functionFactory.substr();
        functionFactory.position();
        functionFactory.nowCurdateCurtime();
        functionFactory.insert();
        functionFactory.overlay();
        functionFactory.median();
        functionFactory.stddevPopSamp();
        functionFactory.varPopSamp();
        functionFactory.addMonths();
        functionFactory.monthsBetween();
        functionFactory.collate_quoted();
        functionFactory.sysdate();
        functionFactory.rownum();
        functionFactory.listagg_groupConcat();
        functionFactory.array_hsql();
        functionFactory.arrayAggregate();
        functionFactory.arrayPosition_hsql();
        functionFactory.arrayPositions_hsql();
        functionFactory.arrayLength_cardinality();
        functionFactory.arrayConcat_operator();
        functionFactory.arrayPrepend_operator();
        functionFactory.arrayAppend_operator();
        functionFactory.arrayContains_hsql();
        functionFactory.arrayIntersects_hsql();
        functionFactory.arrayGet_unnest();
        functionFactory.arraySet_hsql();
        functionFactory.arrayRemove_hsql();
        functionFactory.arrayRemoveIndex_unnest(false);
        functionFactory.arraySlice_unnest();
        functionFactory.arrayReplace_unnest();
        functionFactory.arrayTrim_trim_array();
        functionFactory.arrayFill_hsql();
        functionFactory.arrayToString_hsql();
        if (this.getVersion().isSameOrAfter(2, 7)) {
            functionFactory.jsonObject_hsqldb();
            functionFactory.jsonArray_hsqldb();
            functionFactory.jsonArrayAgg_hsqldb();
            functionFactory.jsonObjectAgg_h2();
        }
        functionFactory.unnest("c1", "c2");
        functionFactory.generateSeries_recursive(this.getMaximumSeriesSize(), true, false);
        functionContributions.getFunctionRegistry().register("trim", new TrimFunction(this, functionContributions.getTypeConfiguration(), SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER));
        functionFactory.hex("hex(?1)");
    }

    protected int getMaximumSeriesSize() {
        return 258;
    }

    @Override
    public @Nullable String getDefaultOrdinalityColumnName() {
        return "c2";
    }

    @Override
    public String currentTime() {
        return "localtime";
    }

    @Override
    public String currentTimestamp() {
        return "localtimestamp";
    }

    @Override
    public String currentTimestampWithTimeZone() {
        return "current_timestamp";
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            @Override
            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new HSQLSqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    @Override
    public String castPattern(CastType from, CastType to) {
        switch (to) {
            case INTEGER: 
            case LONG: {
                String result = BooleanDecoder.toInteger(from);
                if (result == null) break;
                return result;
            }
            case BOOLEAN: {
                String result;
                String string = result = from == CastType.STRING ? this.buildStringToBooleanCastDecode("true", "false") : BooleanDecoder.toBoolean(from);
                if (result == null) break;
                return result;
            }
            case INTEGER_BOOLEAN: {
                String result;
                String string = result = from == CastType.STRING ? this.buildStringToBooleanCastDecode("1", "0") : BooleanDecoder.toIntegerBoolean(from);
                if (result == null) break;
                return result;
            }
            case YN_BOOLEAN: {
                String result;
                String string = result = from == CastType.STRING ? this.buildStringToBooleanCastDecode("'Y'", "'N'") : BooleanDecoder.toYesNoBoolean(from);
                if (result == null) break;
                return result;
            }
            case TF_BOOLEAN: {
                String result;
                String string = result = from == CastType.STRING ? this.buildStringToBooleanCastDecode("'T'", "'F'") : BooleanDecoder.toTrueFalseBoolean(from);
                if (result == null) break;
                return result;
            }
            case STRING: {
                String result = BooleanDecoder.toString(from);
                if (result == null) break;
                return "trim(" + result + ")";
            }
        }
        return super.castPattern(from, to);
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        StringBuilder pattern = new StringBuilder();
        boolean castTo = temporalType != TemporalType.TIMESTAMP && !unit.isDateUnit();
        switch (unit) {
            case NANOSECOND: 
            case NATIVE: {
                pattern.append("timestampadd(sql_tsi_frac_second,?2,");
                break;
            }
            case WEEK: {
                pattern.append("dateadd('day',?2*7,");
                break;
            }
            case SECOND: {
                pattern.append("timestampadd(sql_tsi_frac_second, ?2*1e9,");
                break;
            }
            default: {
                pattern.append("dateadd('?1',?2,");
            }
        }
        if (castTo) {
            pattern.append("cast(?3 as timestamp)");
        } else {
            pattern.append("?3");
        }
        pattern.append(")");
        return pattern.toString();
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        StringBuilder pattern = new StringBuilder();
        boolean castFrom = fromTemporalType != TemporalType.TIMESTAMP && !unit.isDateUnit();
        boolean castTo = toTemporalType != TemporalType.TIMESTAMP && !unit.isDateUnit();
        switch (unit) {
            case NANOSECOND: 
            case NATIVE: {
                pattern.append("timestampdiff(sql_tsi_frac_second");
                break;
            }
            case WEEK: {
                pattern.append("(datediff('day'");
            }
            default: {
                pattern.append("datediff('?1'");
            }
        }
        pattern.append(',');
        if (castFrom) {
            pattern.append("cast(?2 as timestamp)");
        } else {
            pattern.append("?2");
        }
        pattern.append(',');
        if (castTo) {
            pattern.append("cast(?3 as timestamp)");
        } else {
            pattern.append("?3");
        }
        pattern.append(")");
        if (unit == TemporalUnit.WEEK) {
            pattern.append("/7)");
        }
        return pattern.toString();
    }

    @Override
    public String extractPattern(TemporalUnit unit) {
        return unit == TemporalUnit.EPOCH ? "unix_timestamp(?2)" : super.extractPattern(unit);
    }

    @Override
    public boolean supportsDistinctFromPredicate() {
        return true;
    }

    @Override
    public boolean supportsLockTimeouts() {
        return false;
    }

    @Override
    public LimitHandler getLimitHandler() {
        return OffsetFetchLimitHandler.INSTANCE;
    }

    @Override
    public boolean supportsIfExistsAfterTableName() {
        return false;
    }

    @Override
    public boolean supportsIfExistsBeforeTableName() {
        return true;
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return HSQLSequenceSupport.INSTANCE;
    }

    @Override
    public String getQuerySequencesString() {
        return "select * from information_schema.sequences";
    }

    @Override
    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return SequenceInformationExtractorHSQLDBDatabaseImpl.INSTANCE;
    }

    @Override
    public boolean supportsStandardArrays() {
        return true;
    }

    @Override
    public ViolatedConstraintNameExtractor getViolatedConstraintNameExtractor() {
        return EXTRACTOR_20;
    }

    @Override
    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return (sqlException, message, sql) -> switch (JdbcExceptionHelper.extractErrorCode(sqlException)) {
            case -10 -> new ConstraintViolationException(message, sqlException, sql, ConstraintViolationException.ConstraintKind.NOT_NULL, this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException));
            case -104 -> new ConstraintViolationException(message, sqlException, sql, ConstraintViolationException.ConstraintKind.UNIQUE, this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException));
            case -157 -> new ConstraintViolationException(message, sqlException, sql, ConstraintViolationException.ConstraintKind.CHECK, this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException));
            case -177 -> new ConstraintViolationException(message, sqlException, sql, ConstraintViolationException.ConstraintKind.FOREIGN_KEY, this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException));
            default -> null;
        };
    }

    @Override
    public String getSelectClauseNullString(int sqlType, TypeConfiguration typeConfiguration) {
        return switch (sqlType) {
            case -1, 1, 12 -> "cast(null as varchar(100))";
            case -4, -3, -2 -> "cast(null as varbinary(100))";
            case 2005 -> "cast(null as clob)";
            case 2004 -> "cast(null as blob)";
            case 91 -> "cast(null as date)";
            case 93, 2014 -> "cast(null as timestamp)";
            case 16 -> "cast(null as boolean)";
            case -7 -> "cast(null as bit)";
            case 92 -> "cast(null as time)";
            default -> "cast(null as int)";
        };
    }

    @Override
    public NullOrdering getNullOrdering() {
        return NullOrdering.FIRST;
    }

    @Override
    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new LocalTemporaryTableMutationStrategy(TemporaryTable.createIdTable(rootEntityDescriptor, basename -> "session.HT_" + basename, this, runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    @Override
    public SqmMultiTableInsertStrategy getFallbackSqmInsertStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new LocalTemporaryTableInsertStrategy(TemporaryTable.createEntityTable(rootEntityDescriptor, name -> "session.HTE_" + name, this, runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    @Override
    public TemporaryTableKind getSupportedTemporaryTableKind() {
        return TemporaryTableKind.LOCAL;
    }

    @Override
    public String getTemporaryTableCreateCommand() {
        return "declare local temporary table";
    }

    @Override
    public AfterUseAction getTemporaryTableAfterUseAction() {
        return AfterUseAction.DROP;
    }

    @Override
    public BeforeUseAction getTemporaryTableBeforeUseAction() {
        return BeforeUseAction.CREATE;
    }

    @Override
    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    @Override
    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "values current_timestamp";
    }

    @Override
    public boolean doesRoundTemporalOnOverflow() {
        return false;
    }

    @Override
    public boolean supportsCommentOn() {
        return true;
    }

    @Override
    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return true;
    }

    @Override
    public boolean doesRepeatableReadCauseReadersToBlockWriters() {
        return true;
    }

    @Override
    public boolean supportsLobValueChangePropagation() {
        return false;
    }

    @Override
    public void appendBooleanValueString(SqlAppender appender, boolean bool) {
        appender.appendSql(bool);
    }

    @Override
    public boolean supportsTupleCounts() {
        return true;
    }

    @Override
    public boolean supportsTupleDistinctCounts() {
        return true;
    }

    @Override
    public boolean supportsOffsetInSubquery() {
        return true;
    }

    @Override
    public boolean supportsLateral() {
        return true;
    }

    @Override
    public boolean supportsRecursiveCTE() {
        return this.getVersion().isSameOrAfter(2);
    }

    @Override
    public boolean requiresFloatCastingOfIntegerDivision() {
        return true;
    }

    @Override
    public boolean supportsValuesList() {
        return true;
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return this.identityColumnSupport;
    }

    @Override
    public NameQualifierSupport getNameQualifierSupport() {
        return NameQualifierSupport.SCHEMA;
    }

    @Override
    public boolean supportsNamedParameters(DatabaseMetaData databaseMetaData) {
        return false;
    }

    @Override
    public FunctionalDependencyAnalysisSupport getFunctionalDependencyAnalysisSupport() {
        return FunctionalDependencyAnalysisSupportImpl.TABLE_REFERENCE;
    }

    @Override
    public boolean dropConstraints() {
        return false;
    }

    @Override
    public String getCascadeConstraintsString() {
        return " cascade ";
    }

    @Override
    public void appendDatetimeFormat(SqlAppender appender, String format) {
        appender.appendSql(OracleDialect.datetimeFormat(format, false, false).replace("MMMM", "MONTH").replace("EEEE", "DAY").replace("SSSSSS", "FF").replace("SSSSS", "FF").replace("SSSS", "FF").replace("SSS", "FF").replace("SS", "FF").replace("S", "FF").result());
    }

    @Override
    public String translateExtractField(TemporalUnit unit) {
        switch (unit) {
            case WEEK: {
                return "week_of_year";
            }
        }
        return unit.toString();
    }

    @Override
    public IdentifierHelper buildIdentifierHelper(IdentifierHelperBuilder builder, DatabaseMetaData dbMetaData) throws SQLException {
        builder.setAutoQuoteInitialUnderscore(true);
        builder.setAutoQuoteDollar(true);
        return super.buildIdentifierHelper(builder, dbMetaData);
    }

    @Override
    public UniqueDelegate getUniqueDelegate() {
        return this.uniqueDelegate;
    }

    @Override
    public String quoteCollation(String collation) {
        return "\"" + collation + "\"";
    }

    @Override
    public DmlTargetColumnQualifierSupport getDmlTargetColumnQualifierSupport() {
        return DmlTargetColumnQualifierSupport.TABLE_ALIAS;
    }

    @Override
    public String getFromDualForSelectOnly() {
        return " from " + this.getDual();
    }

    @Override
    public boolean supportsFilterClause() {
        return true;
    }

    @Override
    public boolean supportsArrayConstructor() {
        return true;
    }

    @Override
    public boolean supportsRowValueConstructorSyntax() {
        return false;
    }

    @Override
    public boolean supportsWithClauseInSubquery() {
        return false;
    }

    @Override
    public boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return false;
    }

    @Override
    public boolean supportsRowValueConstructorSyntaxInInList() {
        return false;
    }
}

