/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.internal.util.config.ConfigurationHelper;

public class OracleServerConfiguration {
    private final boolean autonomous;
    private final boolean extended;
    private final boolean applicationContinuity;
    private final int driverMajorVersion;
    private final int driverMinorVersion;

    public boolean isAutonomous() {
        return this.autonomous;
    }

    public boolean isExtended() {
        return this.extended;
    }

    public boolean isApplicationContinuity() {
        return this.applicationContinuity;
    }

    public int getDriverMajorVersion() {
        return this.driverMajorVersion;
    }

    public int getDriverMinorVersion() {
        return this.driverMinorVersion;
    }

    public OracleServerConfiguration(boolean autonomous, boolean extended) {
        this(autonomous, extended, false, 19, 0);
    }

    public OracleServerConfiguration(boolean autonomous, boolean extended, int driverMajorVersion, int driverMinorVersion) {
        this(autonomous, extended, false, driverMajorVersion, driverMinorVersion);
    }

    public OracleServerConfiguration(boolean autonomous, boolean extended, boolean applicationContinuity, int driverMajorVersion, int driverMinorVersion) {
        this.autonomous = autonomous;
        this.extended = extended;
        this.applicationContinuity = applicationContinuity;
        this.driverMajorVersion = driverMajorVersion;
        this.driverMinorVersion = driverMinorVersion;
    }

    public static OracleServerConfiguration fromDialectResolutionInfo(DialectResolutionInfo info) {
        int minorVersion;
        int majorVersion;
        boolean applicationContinuity;
        boolean autonomous;
        boolean extended;
        Map<String, Object> configuration = info.getConfigurationValues();
        boolean defaultExtended = ConfigurationHelper.getBoolean("hibernate.dialect.oracle.extended_string_size", configuration, false);
        boolean defaultAutonomous = ConfigurationHelper.getBoolean("hibernate.dialect.oracle.is_autonomous", configuration, false);
        boolean defaultContinuity = ConfigurationHelper.getBoolean("hibernate.dialect.oracle.application_continuity", configuration, false);
        DatabaseMetaData databaseMetaData = info.getDatabaseMetadata();
        if (databaseMetaData == null) {
            extended = defaultExtended;
            autonomous = defaultAutonomous;
            applicationContinuity = defaultContinuity;
            try {
                Driver driver = DriverManager.getDriver("jdbc:oracle:thin:");
                majorVersion = driver.getMajorVersion();
                minorVersion = driver.getMinorVersion();
            }
            catch (SQLException ex) {
                majorVersion = 19;
                minorVersion = 0;
            }
        } else {
            majorVersion = databaseMetaData.getDriverMajorVersion();
            minorVersion = databaseMetaData.getDriverMinorVersion();
            try {
                Connection connection = databaseMetaData.getConnection();
                try (Statement statement = connection.createStatement();){
                    applicationContinuity = OracleServerConfiguration.determineApplicationContinuity(connection, statement);
                    autonomous = OracleServerConfiguration.isAutonomous(statement);
                    extended = OracleServerConfiguration.isExtended(statement);
                }
            }
            catch (SQLException sqle) {
                extended = defaultExtended;
                autonomous = defaultAutonomous;
                applicationContinuity = defaultContinuity;
            }
        }
        return new OracleServerConfiguration(autonomous, extended, applicationContinuity, majorVersion, minorVersion);
    }

    private static boolean isExtended(Statement statement) {
        boolean bl;
        block8: {
            ResultSet resultSet = statement.executeQuery("select cast('string' as varchar2(32000)) from dual");
            try {
                resultSet.next();
                bl = true;
                if (resultSet == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    return false;
                }
            }
            resultSet.close();
        }
        return bl;
    }

    private static Boolean determineApplicationContinuity(Connection connection, Statement statement) {
        try {
            Class<?> statisticReportTypeEnum = Class.forName("oracle.jdbc.replay.ReplayableConnection$StatisticsReportType", false, Thread.currentThread().getContextClassLoader());
            Object forCurrentConnection = statisticReportTypeEnum.getField("FOR_CURRENT_CONNECTION").get(null);
            Method getReplayStatistics = connection.getClass().getMethod("getReplayStatistics", statisticReportTypeEnum);
            Class<?> replayStatistics = getReplayStatistics.getReturnType();
            Method getTotalRequests = replayStatistics.getMethod("getTotalRequests", new Class[0]);
            Method getTotalProtectedCalls = replayStatistics.getMethod("getTotalProtectedCalls", new Class[0]);
            Object before = getReplayStatistics.invoke((Object)connection, forCurrentConnection);
            Long totalRequestsBefore = (Long)getTotalRequests.invoke(before, new Object[0]);
            Long protectedCallsBefore = (Long)getTotalProtectedCalls.invoke(before, new Object[0]);
            try (ResultSet resultSet = statement.executeQuery("select 1");){
                resultSet.next();
            }
            Object after = getReplayStatistics.invoke((Object)connection, forCurrentConnection);
            Long totalRequestsAfter = (Long)getTotalRequests.invoke(after, new Object[0]);
            Long protectedCallsAfter = (Long)getTotalProtectedCalls.invoke(after, new Object[0]);
            return totalRequestsAfter > totalRequestsBefore && protectedCallsAfter > protectedCallsBefore;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isAutonomous(Statement statement) {
        boolean bl;
        block8: {
            ResultSet resultSet = statement.executeQuery("select sys_context('USERENV','CLOUD_SERVICE') from dual");
            try {
                boolean bl2 = bl = resultSet.next() && OracleServerConfiguration.isAutonomous(resultSet.getString(1));
                if (resultSet == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    return false;
                }
            }
            resultSet.close();
        }
        return bl;
    }

    private static boolean isAutonomous(String type) {
        boolean bl;
        block9: {
            block8: {
                if (type == null) break block8;
                switch (type) {
                    case "OLTP": 
                    case "DWCS": 
                    case "JDCS": {
                        break;
                    }
                    default: {
                        break block8;
                    }
                }
                bl = true;
                break block9;
            }
            bl = false;
        }
        return bl;
    }
}

