/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import jakarta.persistence.TemporalType;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.hibernate.HibernateException;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.dialect.AbstractTransactSQLDialect;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DmlTargetColumnQualifierSupport;
import org.hibernate.dialect.NationalizationSupport;
import org.hibernate.dialect.SybaseDriverKind;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.CountFunction;
import org.hibernate.dialect.function.IntegralTimestampaddFunction;
import org.hibernate.dialect.function.SybaseTruncFunction;
import org.hibernate.dialect.identity.AbstractTransactSQLIdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.identity.SybaseJconnIdentityColumnSupport;
import org.hibernate.dialect.sql.ast.SybaseSqlAstTranslator;
import org.hibernate.dialect.sql.ast.SybaseSqmToSqlAstConverter;
import org.hibernate.dialect.unique.SkipNullableUniqueDelegate;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.internal.DefaultSchemaNameResolver;
import org.hibernate.engine.jdbc.env.spi.IdentifierCaseStrategy;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelperBuilder;
import org.hibernate.engine.jdbc.env.spi.NameQualifierSupport;
import org.hibernate.engine.jdbc.env.spi.SchemaNameResolver;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.procedure.internal.JTDSCallableStatementSupport;
import org.hibernate.procedure.internal.SybaseCallableStatementSupport;
import org.hibernate.procedure.spi.CallableStatementSupport;
import org.hibernate.query.common.TemporalUnit;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.sqm.CastType;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.sql.SqmTranslator;
import org.hibernate.query.sqm.sql.SqmTranslatorFactory;
import org.hibernate.query.sqm.sql.StandardSqmTranslatorFactory;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.type.JavaObjectType;
import org.hibernate.type.NullType;
import org.hibernate.type.descriptor.DateTimeUtils;
import org.hibernate.type.descriptor.jdbc.BlobJdbcType;
import org.hibernate.type.descriptor.jdbc.ClobJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.NClobJdbcType;
import org.hibernate.type.descriptor.jdbc.ObjectNullAsBinaryTypeJdbcType;
import org.hibernate.type.descriptor.jdbc.TinyIntAsSmallIntJdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;

public class SybaseDialect
extends AbstractTransactSQLDialect {
    private static final DatabaseVersion MINIMUM_VERSION = DatabaseVersion.make(16, 0);
    private static final int IN_LIST_SIZE_LIMIT = 250000;
    private static final int PARAM_COUNT_LIMIT = 2000;
    private final UniqueDelegate uniqueDelegate = new SkipNullableUniqueDelegate(this);
    private final SybaseDriverKind driverKind;
    @Deprecated(forRemoval=true)
    protected final boolean jtdsDriver;
    private final SchemaNameResolver schemaNameResolver;

    public SybaseDialect() {
        this(MINIMUM_VERSION);
    }

    public SybaseDialect(DatabaseVersion version) {
        super(version);
        this.driverKind = SybaseDriverKind.OTHER;
        this.jtdsDriver = true;
        this.schemaNameResolver = SybaseDialect.determineSchemaNameResolver(this.driverKind);
    }

    private static SchemaNameResolver determineSchemaNameResolver(SybaseDriverKind driverKind) {
        return driverKind != SybaseDriverKind.JCONNECT ? new JTDSSchemaNameResolver() : DefaultSchemaNameResolver.INSTANCE;
    }

    public SybaseDialect(DialectResolutionInfo info) {
        super(info);
        this.driverKind = SybaseDriverKind.determineKind(info);
        this.jtdsDriver = this.driverKind == SybaseDriverKind.JTDS;
        this.schemaNameResolver = SybaseDialect.determineSchemaNameResolver(this.driverKind);
    }

    @Override
    protected DatabaseVersion getMinimumSupportedVersion() {
        return MINIMUM_VERSION;
    }

    public SybaseDriverKind getDriverKind() {
        return this.driverKind;
    }

    @Override
    public JdbcType resolveSqlTypeDescriptor(String columnTypeName, int jdbcTypeCode, int precision, int scale, JdbcTypeRegistry jdbcTypeRegistry) {
        switch (jdbcTypeCode) {
            case 2: 
            case 3: {
                if (precision != 19 || scale != 0) break;
                return jdbcTypeRegistry.getDescriptor(-5);
            }
        }
        return super.resolveSqlTypeDescriptor(columnTypeName, jdbcTypeCode, precision, scale, jdbcTypeRegistry);
    }

    @Override
    public int resolveSqlTypeLength(String columnTypeName, int jdbcTypeCode, int precision, int scale, int displaySize) {
        return switch (jdbcTypeCode) {
            case 1, 7, 8, 12 -> displaySize;
            default -> super.resolveSqlTypeLength(columnTypeName, jdbcTypeCode, precision, scale, displaySize);
        };
    }

    @Override
    public SqmTranslatorFactory getSqmTranslatorFactory() {
        return new StandardSqmTranslatorFactory(){

            @Override
            public SqmTranslator<SelectStatement> createSelectTranslator(SqmSelectStatement<?> sqmSelectStatement, QueryOptions queryOptions, DomainParameterXref domainParameterXref, QueryParameterBindings domainParameterBindings, LoadQueryInfluencers loadQueryInfluencers, SqlAstCreationContext creationContext, boolean deduplicateSelectionItems) {
                return new SybaseSqmToSqlAstConverter<SelectStatement>(sqmSelectStatement, queryOptions, domainParameterXref, domainParameterBindings, loadQueryInfluencers, creationContext, deduplicateSelectionItems);
            }
        };
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            @Override
            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, org.hibernate.sql.ast.tree.Statement statement) {
                return new SybaseSqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    @Override
    public boolean supportsNullPrecedence() {
        return false;
    }

    @Override
    public int getInExpressionCountLimit() {
        return 250000;
    }

    @Override
    public int getParameterCountLimit() {
        return 2000;
    }

    @Override
    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        JdbcTypeRegistry jdbcTypeRegistry = typeContributions.getTypeConfiguration().getJdbcTypeRegistry();
        if (this.driverKind == SybaseDriverKind.JTDS) {
            jdbcTypeRegistry.addDescriptor(-6, TinyIntAsSmallIntJdbcType.INSTANCE);
            jdbcTypeRegistry.addDescriptor(2005, ClobJdbcType.CLOB_BINDING);
            jdbcTypeRegistry.addDescriptor(2011, NClobJdbcType.NCLOB_BINDING);
        } else {
            jdbcTypeRegistry.addDescriptor(2005, ClobJdbcType.STREAM_BINDING_EXTRACTING);
            jdbcTypeRegistry.addDescriptor(2011, ClobJdbcType.STREAM_BINDING_EXTRACTING);
        }
        jdbcTypeRegistry.addDescriptor(2004, BlobJdbcType.PRIMITIVE_ARRAY_BINDING);
        typeContributions.contributeJdbcType(ObjectNullAsBinaryTypeJdbcType.INSTANCE);
        typeContributions.contributeType(new JavaObjectType((JdbcType)ObjectNullAsBinaryTypeJdbcType.INSTANCE, typeContributions.getTypeConfiguration().getJavaTypeRegistry().getDescriptor((Type)((Object)Object.class))));
        typeContributions.contributeType(new NullType((JdbcType)ObjectNullAsBinaryTypeJdbcType.INSTANCE, typeContributions.getTypeConfiguration().getJavaTypeRegistry().getDescriptor((Type)((Object)Object.class))));
    }

    @Override
    public NationalizationSupport getNationalizationSupport() {
        return super.getNationalizationSupport();
    }

    @Override
    public boolean stripsTrailingSpacesFromChar() {
        return true;
    }

    @Override
    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionFactory.stddev();
        functionFactory.variance();
        functionFactory.stddevPopSamp_stdevp();
        functionFactory.varPopSamp_varp();
        functionFactory.stddevPopSamp();
        functionFactory.varPopSamp();
        functionFactory.round_round();
        functionContributions.getFunctionRegistry().register("count", new CountFunction(this, functionContributions.getTypeConfiguration(), SqlAstNodeRenderingMode.DEFAULT, "count_big", "+", "varchar(16384)", false));
        functionFactory.avg_castingNonDoubleArguments(this, SqlAstNodeRenderingMode.DEFAULT);
        functionFactory.locate_charindex();
        functionFactory.replace_strReplace();
        functionFactory.everyAny_minMaxCase();
        functionFactory.octetLength_pattern("datalength(?1)");
        functionFactory.bitLength_pattern("datalength(?1)*8");
        functionContributions.getFunctionRegistry().register("timestampadd", new IntegralTimestampaddFunction(this, functionContributions.getTypeConfiguration()));
        functionContributions.getFunctionRegistry().register("trunc", new SybaseTruncFunction(functionContributions.getTypeConfiguration()));
        functionContributions.getFunctionRegistry().registerAlternateKey("truncate", "trunc");
    }

    @Override
    public String getNullColumnString() {
        return " null";
    }

    @Override
    public boolean canCreateSchema() {
        return false;
    }

    @Override
    public SchemaNameResolver getSchemaNameResolver() {
        return this.schemaNameResolver;
    }

    @Override
    public String getCurrentSchemaCommand() {
        return "select user_name()";
    }

    @Override
    public int getMaxIdentifierLength() {
        return 128;
    }

    @Override
    public String castPattern(CastType from, CastType to) {
        if (to == CastType.STRING) {
            switch (from) {
                case DATE: {
                    return "substring(convert(varchar,?1,23),1,10)";
                }
                case TIME: {
                    return "convert(varchar,?1,8)";
                }
                case TIMESTAMP: {
                    return "convert(varchar,?1,140)";
                }
            }
        }
        return super.castPattern(from, to);
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, TemporalAccessor temporalAccessor, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("convert(date,'");
                DateTimeUtils.appendAsDate(appender, temporalAccessor);
                appender.appendSql("',140)");
                break;
            }
            case TIME: {
                appender.appendSql("convert(time,'");
                DateTimeUtils.appendAsTime(appender, temporalAccessor, this.supportsTemporalLiteralOffset(), jdbcTimeZone);
                appender.appendSql("',8)");
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("convert(datetime,'");
                DateTimeUtils.appendAsTimestampWithMillis(appender, temporalAccessor, this.supportsTemporalLiteralOffset(), jdbcTimeZone);
                appender.appendSql("',140)");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, Date date, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("convert(date,'");
                DateTimeUtils.appendAsDate(appender, date);
                appender.appendSql("',140)");
                break;
            }
            case TIME: {
                appender.appendSql("convert(time,'");
                DateTimeUtils.appendAsLocalTime(appender, date);
                appender.appendSql("',8)");
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("convert(datetime,'");
                DateTimeUtils.appendAsTimestampWithMillis(appender, date, jdbcTimeZone);
                appender.appendSql("',140)");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, Calendar calendar, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("convert(date,'");
                DateTimeUtils.appendAsDate(appender, calendar);
                appender.appendSql("',140)");
                break;
            }
            case TIME: {
                appender.appendSql("convert(time,'");
                DateTimeUtils.appendAsLocalTime(appender, calendar);
                appender.appendSql("',8)");
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("convert(datetime,'");
                DateTimeUtils.appendAsTimestampWithMillis(appender, calendar, jdbcTimeZone);
                appender.appendSql("',140)");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public String translateExtractField(TemporalUnit unit) {
        return switch (unit) {
            case TemporalUnit.WEEK -> "calweekofyear";
            default -> super.translateExtractField(unit);
        };
    }

    @Override
    public String extractPattern(TemporalUnit unit) {
        return unit == TemporalUnit.EPOCH ? "datediff(second, '1970-01-01 00:00:00', ?2)" : "datepart(?1,?2)";
    }

    @Override
    public boolean supportsFractionalTimestampArithmetic() {
        return false;
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        return "dateadd(?1,?2,?3)";
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        return "datediff(?1,?2,?3)";
    }

    @Override
    public void appendDatetimeFormat(SqlAppender appender, String format) {
        throw new UnsupportedOperationException("format() function not supported on Sybase");
    }

    @Override
    public boolean supportsStandardCurrentTimestampFunction() {
        return false;
    }

    @Override
    public IdentifierHelper buildIdentifierHelper(IdentifierHelperBuilder builder, DatabaseMetaData dbMetaData) throws SQLException {
        builder.setUnquotedCaseStrategy(IdentifierCaseStrategy.MIXED);
        if (dbMetaData == null) {
            builder.setQuotedCaseStrategy(IdentifierCaseStrategy.MIXED);
        }
        return super.buildIdentifierHelper(builder, dbMetaData);
    }

    @Override
    public NameQualifierSupport getNameQualifierSupport() {
        return NameQualifierSupport.BOTH;
    }

    @Override
    public UniqueDelegate getUniqueDelegate() {
        return this.uniqueDelegate;
    }

    @Override
    public CallableStatementSupport getCallableStatementSupport() {
        return this.driverKind == SybaseDriverKind.JTDS ? JTDSCallableStatementSupport.INSTANCE : SybaseCallableStatementSupport.INSTANCE;
    }

    @Override
    public boolean supportsNamedParameters(DatabaseMetaData databaseMetaData) throws SQLException {
        return this.driverKind == SybaseDriverKind.JTDS && super.supportsNamedParameters(databaseMetaData);
    }

    @Override
    public String getAlterColumnTypeString(String columnName, String columnType, String columnDefinition) {
        return "modify " + columnName + " " + columnType;
    }

    @Override
    public boolean supportsAlterColumnType() {
        return true;
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return this.driverKind == SybaseDriverKind.JTDS ? AbstractTransactSQLIdentityColumnSupport.INSTANCE : SybaseJconnIdentityColumnSupport.INSTANCE;
    }

    @Override
    public DmlTargetColumnQualifierSupport getDmlTargetColumnQualifierSupport() {
        return DmlTargetColumnQualifierSupport.TABLE_ALIAS;
    }

    @Override
    public boolean supportsFromClauseInUpdate() {
        return true;
    }

    @Override
    public boolean supportsRowValueConstructorSyntax() {
        return false;
    }

    @Override
    public boolean supportsWithClause() {
        return false;
    }

    @Override
    public boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return false;
    }

    @Override
    public boolean supportsRowValueConstructorSyntaxInInList() {
        return false;
    }

    private static class JTDSSchemaNameResolver
    implements SchemaNameResolver {
        private JTDSSchemaNameResolver() {
        }

        @Override
        public String resolveSchemaName(Connection connection, Dialect dialect) throws SQLException {
            String command = dialect.getCurrentSchemaCommand();
            if (command == null) {
                throw new HibernateException("Use of DefaultSchemaNameResolver requires Dialect to provide the proper SQL statement/command but provided Dialect [" + dialect.getClass().getName() + "] did not return anything from Dialect#getCurrentSchemaCommand");
            }
            try (Statement statement = connection.createStatement();){
                String string;
                block13: {
                    ResultSet resultSet = statement.executeQuery(command);
                    try {
                        String string2 = string = resultSet.next() ? resultSet.getString(1) : null;
                        if (resultSet == null) break block13;
                    }
                    catch (Throwable throwable) {
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    resultSet.close();
                }
                return string;
            }
        }
    }
}

