/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.Collections;
import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.CastFunction;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.query.sqm.CastType;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.function.FunctionKind;
import org.hibernate.query.sqm.function.FunctionRenderer;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.query.sqm.produce.function.internal.PatternRenderer;
import org.hibernate.query.sqm.sql.internal.AbstractSqmPathInterpretation;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Distinct;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.SqlTupleContainer;
import org.hibernate.sql.ast.tree.expression.Star;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.spi.TypeConfiguration;

public class CountFunction
extends AbstractSqmSelfRenderingFunctionDescriptor {
    private final Dialect dialect;
    private final SqlAstNodeRenderingMode defaultArgumentRenderingMode;
    private final String countFunctionName;
    private final String concatOperator;
    private final String concatArgumentCastType;
    private final boolean castDistinctStringConcat;
    private final String distinctArgumentCastType;

    public CountFunction(Dialect dialect, TypeConfiguration typeConfiguration, SqlAstNodeRenderingMode defaultArgumentRenderingMode, String concatOperator) {
        this(dialect, typeConfiguration, defaultArgumentRenderingMode, concatOperator, null, false);
    }

    public CountFunction(Dialect dialect, TypeConfiguration typeConfiguration, SqlAstNodeRenderingMode defaultArgumentRenderingMode, String concatOperator, String concatArgumentCastType, boolean castDistinctStringConcat) {
        this(dialect, typeConfiguration, defaultArgumentRenderingMode, "count", concatOperator, concatArgumentCastType, castDistinctStringConcat, concatArgumentCastType);
    }

    public CountFunction(Dialect dialect, TypeConfiguration typeConfiguration, SqlAstNodeRenderingMode defaultArgumentRenderingMode, String countFunctionName, String concatOperator, String concatArgumentCastType, boolean castDistinctStringConcat) {
        this(dialect, typeConfiguration, defaultArgumentRenderingMode, countFunctionName, concatOperator, concatArgumentCastType, castDistinctStringConcat, concatArgumentCastType);
    }

    public CountFunction(Dialect dialect, TypeConfiguration typeConfiguration, SqlAstNodeRenderingMode defaultArgumentRenderingMode, String countFunctionName, String concatOperator, String concatArgumentCastType, boolean castDistinctStringConcat, String distinctArgumentCastType) {
        super("count", FunctionKind.AGGREGATE, StandardArgumentsValidators.exactly(1), StandardFunctionReturnTypeResolvers.invariant(typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.LONG)), null);
        this.dialect = dialect;
        this.defaultArgumentRenderingMode = defaultArgumentRenderingMode;
        this.countFunctionName = countFunctionName;
        this.concatOperator = concatOperator;
        this.concatArgumentCastType = concatArgumentCastType;
        this.castDistinctStringConcat = castDistinctStringConcat;
        this.distinctArgumentCastType = distinctArgumentCastType;
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        this.render(sqlAppender, sqlAstArguments, null, returnType, walker);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, Predicate filter, ReturnableType<?> returnType, SqlAstTranslator<?> translator) {
        boolean caseWrapper = filter != null && !translator.getSessionFactory().getJdbcServices().getDialect().supportsFilterClause();
        SqlAstNode arg = sqlAstArguments.get(0);
        sqlAppender.appendSql(this.countFunctionName);
        sqlAppender.appendSql('(');
        if (arg instanceof Distinct) {
            Distinct distinct = (Distinct)arg;
            sqlAppender.appendSql("distinct ");
            Expression distinctArg = distinct.getExpression();
            SqlTuple tuple = SqlTupleContainer.getSqlTuple(distinctArg);
            if (tuple != null) {
                List<? extends Expression> expressions = tuple.getExpressions();
                if (expressions.size() == 1) {
                    this.renderSimpleArgument(sqlAppender, filter, translator, caseWrapper, expressions.get(0));
                } else if (!this.dialect.supportsTupleDistinctCounts()) {
                    FunctionRenderer chrFunction = (FunctionRenderer)((Object)translator.getSessionFactory().getQueryEngine().getSqmFunctionRegistry().findFunctionDescriptor("chr"));
                    List<QueryLiteral<Integer>> chrArguments = List.of(new QueryLiteral<Integer>(0, translator.getSessionFactory().getTypeConfiguration().getBasicTypeForJavaType(Integer.class)));
                    if (caseWrapper) {
                        translator.getCurrentClauseStack().push(Clause.WHERE);
                        sqlAppender.appendSql("case when ");
                        filter.accept(translator);
                        sqlAppender.appendSql(" then ");
                        translator.getCurrentClauseStack().pop();
                    }
                    if (this.castDistinctStringConcat) {
                        sqlAppender.appendSql("cast(");
                    }
                    sqlAppender.appendSql("coalesce(nullif(coalesce(");
                    boolean needsConcat = this.renderCastedArgument(sqlAppender, translator, expressions.get(0));
                    int argumentNumber = 1;
                    int i = 1;
                    while (i < expressions.size()) {
                        if (needsConcat) {
                            sqlAppender.appendSql(this.concatOperator);
                            sqlAppender.appendSql("''");
                        }
                        sqlAppender.appendSql(',');
                        chrFunction.render(sqlAppender, chrArguments, returnType, translator);
                        sqlAppender.appendSql("),''),");
                        chrFunction.render(sqlAppender, chrArguments, returnType, translator);
                        sqlAppender.appendSql(this.concatOperator);
                        sqlAppender.appendSql("'");
                        sqlAppender.appendSql(argumentNumber);
                        sqlAppender.appendSql("')");
                        sqlAppender.appendSql(this.concatOperator);
                        chrFunction.render(sqlAppender, chrArguments, returnType, translator);
                        sqlAppender.appendSql(this.concatOperator);
                        sqlAppender.appendSql("coalesce(nullif(coalesce(");
                        needsConcat = this.renderCastedArgument(sqlAppender, translator, expressions.get(i));
                        ++i;
                        ++argumentNumber;
                    }
                    if (needsConcat) {
                        sqlAppender.appendSql(this.concatOperator);
                        sqlAppender.appendSql("''");
                    }
                    sqlAppender.appendSql(',');
                    chrFunction.render(sqlAppender, chrArguments, returnType, translator);
                    sqlAppender.appendSql("),''),");
                    chrFunction.render(sqlAppender, chrArguments, returnType, translator);
                    sqlAppender.appendSql(this.concatOperator);
                    sqlAppender.appendSql("'");
                    sqlAppender.appendSql(argumentNumber);
                    sqlAppender.appendSql("')");
                    if (this.castDistinctStringConcat) {
                        sqlAppender.appendSql(" as ");
                        sqlAppender.appendSql(this.distinctArgumentCastType);
                        sqlAppender.appendSql(')');
                    }
                    if (caseWrapper) {
                        sqlAppender.appendSql(" else null end");
                    }
                } else {
                    this.renderTupleCountSupported(sqlAppender, filter, translator, caseWrapper, tuple, expressions, this.dialect.requiresParensForTupleDistinctCounts());
                }
            } else {
                this.renderSimpleArgument(sqlAppender, filter, translator, caseWrapper, distinctArg);
            }
        } else if (this.canReplaceWithStar(arg, translator)) {
            this.renderSimpleArgument(sqlAppender, filter, translator, caseWrapper, Star.INSTANCE);
        } else {
            SqlTuple tuple = SqlTupleContainer.getSqlTuple(arg);
            if (tuple != null) {
                List<? extends Expression> expressions = tuple.getExpressions();
                if (expressions.size() == 1) {
                    this.renderSimpleArgument(sqlAppender, filter, translator, caseWrapper, expressions.get(0));
                } else if (!this.dialect.supportsTupleCounts()) {
                    sqlAppender.appendSql("case when ");
                    if (caseWrapper) {
                        translator.getCurrentClauseStack().push(Clause.WHERE);
                        filter.accept(translator);
                        translator.getCurrentClauseStack().pop();
                        sqlAppender.appendSql(" and ");
                    }
                    translator.render(expressions.get(0), this.defaultArgumentRenderingMode);
                    sqlAppender.appendSql(" is not null");
                    for (int i = 1; i < expressions.size(); ++i) {
                        sqlAppender.appendSql(" and ");
                        translator.render(expressions.get(i), this.defaultArgumentRenderingMode);
                        sqlAppender.appendSql(" is not null");
                    }
                    sqlAppender.appendSql(" then 1 else null end");
                } else {
                    this.renderTupleCountSupported(sqlAppender, filter, translator, caseWrapper, tuple, expressions, this.dialect.requiresParensForTupleCounts());
                }
            } else {
                this.renderSimpleArgument(sqlAppender, filter, translator, caseWrapper, arg);
            }
        }
        sqlAppender.appendSql(')');
        if (filter != null && !caseWrapper) {
            translator.getCurrentClauseStack().push(Clause.WHERE);
            sqlAppender.appendSql(" filter (where ");
            filter.accept(translator);
            sqlAppender.appendSql(')');
            translator.getCurrentClauseStack().pop();
        }
    }

    private void renderTupleCountSupported(SqlAppender sqlAppender, Predicate filter, SqlAstTranslator<?> translator, boolean caseWrapper, SqlTuple tuple, List<? extends Expression> expressions, boolean requiresParenthesis) {
        if (caseWrapper) {
            if (requiresParenthesis) {
                sqlAppender.appendSql('(');
                this.renderSimpleArgument(sqlAppender, filter, translator, true, Star.INSTANCE);
                sqlAppender.appendSql(',');
                this.renderCommaSeparatedList(sqlAppender, translator, expressions);
                sqlAppender.appendSql(')');
            } else {
                this.renderSimpleArgument(sqlAppender, filter, translator, true, Star.INSTANCE);
                sqlAppender.appendSql(',');
                this.renderCommaSeparatedList(sqlAppender, translator, expressions);
            }
        } else if (requiresParenthesis) {
            translator.render(tuple, this.defaultArgumentRenderingMode);
        } else {
            this.renderCommaSeparatedList(sqlAppender, translator, expressions);
        }
    }

    private void renderCommaSeparatedList(SqlAppender sqlAppender, SqlAstTranslator<?> translator, List<? extends Expression> expressions) {
        translator.render(expressions.get(0), this.defaultArgumentRenderingMode);
        for (int i = 1; i < expressions.size(); ++i) {
            sqlAppender.appendSql(',');
            translator.render(expressions.get(i), this.defaultArgumentRenderingMode);
        }
    }

    private void renderSimpleArgument(SqlAppender sqlAppender, Predicate filter, SqlAstTranslator<?> translator, boolean caseWrapper, SqlAstNode realArg) {
        if (caseWrapper) {
            translator.getCurrentClauseStack().push(Clause.WHERE);
            sqlAppender.appendSql("case when ");
            filter.accept(translator);
            translator.getCurrentClauseStack().pop();
            sqlAppender.appendSql(" then ");
            if (realArg instanceof Star) {
                sqlAppender.appendSql("1");
            } else {
                translator.render(realArg, this.defaultArgumentRenderingMode);
            }
            sqlAppender.appendSql(" else null end");
        } else {
            translator.render(realArg, this.defaultArgumentRenderingMode);
        }
    }

    private boolean renderCastedArgument(SqlAppender sqlAppender, SqlAstTranslator<?> translator, Expression realArg) {
        if (this.concatArgumentCastType == null) {
            translator.render(realArg, this.defaultArgumentRenderingMode);
            return true;
        }
        JdbcMapping sourceMapping = realArg.getExpressionType().getSingleJdbcMapping();
        CastType sourceType = sourceMapping.getCastType();
        if (sourceType == CastType.STRING) {
            translator.render(realArg, this.defaultArgumentRenderingMode);
            return false;
        }
        if (sourceType == CastType.OTHER && sourceMapping.getJdbcType().isArray()) {
            CastFunction.renderCastArrayToString(sqlAppender, realArg, this.dialect, translator);
            return false;
        }
        String cast = this.dialect.castPattern(sourceType, CastType.STRING);
        new PatternRenderer(cast.replace("?2", this.concatArgumentCastType)).render(sqlAppender, Collections.singletonList(realArg), translator);
        return false;
    }

    private boolean canReplaceWithStar(SqlAstNode arg, SqlAstTranslator<?> translator) {
        if (arg instanceof AbstractSqmPathInterpretation) {
            AbstractSqmPathInterpretation pathInterpretation = (AbstractSqmPathInterpretation)arg;
            TableGroup tableGroup = pathInterpretation.getTableGroup();
            Expression sqlExpression = pathInterpretation.getSqlExpression();
            JdbcMappingContainer expressionType = sqlExpression.getExpressionType();
            boolean isNonNullable = expressionType instanceof EntityIdentifierMapping;
            if (isNonNullable && tableGroup.canUseInnerJoins() && !this.hasJoinsAlteringNullability(tableGroup)) {
                QuerySpec querySpec = (QuerySpec)translator.getCurrentQueryPart();
                for (TableGroup root : querySpec.getFromClause().getRoots()) {
                    Boolean result = this.hasNeighbouringJoinsAlteringNullability(root, tableGroup);
                    if (result == null) continue;
                    return result == false;
                }
                return true;
            }
        }
        return false;
    }

    private Boolean hasNeighbouringJoinsAlteringNullability(TableGroup tableGroup, TableGroup targetTableGroup) {
        TableGroupJoin tableGroupJoin;
        int i;
        if (tableGroup == targetTableGroup) {
            return Boolean.FALSE;
        }
        List<TableGroupJoin> tableGroupJoins = tableGroup.getTableGroupJoins();
        int tableGroupIndex = -1;
        for (i = 0; i < tableGroupJoins.size(); ++i) {
            tableGroupJoin = tableGroupJoins.get(i);
            Boolean result = this.hasNeighbouringJoinsAlteringNullability(tableGroupJoin.getJoinedGroup(), targetTableGroup);
            if (result == Boolean.TRUE) {
                return Boolean.TRUE;
            }
            if (result == null) continue;
            tableGroupIndex = i;
            break;
        }
        if (tableGroupIndex != -1) {
            for (i = 0; i < tableGroupJoins.size(); ++i) {
                if (i == tableGroupIndex || !this.hasJoinsAlteringNullability(tableGroupJoin = tableGroupJoins.get(i))) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return null;
    }

    private boolean hasJoinsAlteringNullability(TableGroup tableGroup) {
        block3: for (TableGroupJoin tableGroupJoin : tableGroup.getTableGroupJoins()) {
            switch (tableGroupJoin.getJoinType()) {
                case INNER: 
                case LEFT: 
                case CROSS: {
                    if (!this.hasJoinsAlteringNullability(tableGroupJoin.getJoinedGroup())) continue block3;
                    return true;
                }
            }
            return true;
        }
        return false;
    }

    private boolean hasJoinsAlteringNullability(TableGroupJoin neighbourJoin) {
        switch (neighbourJoin.getJoinType()) {
            case INNER: 
            case LEFT: 
            case CROSS: {
                return this.hasJoinsAlteringNullability(neighbourJoin.getJoinedGroup());
            }
            default: {
                return true;
            }
        }
    }

    @Override
    public String getArgumentListSignature() {
        return "([distinct ]{arg|*})";
    }
}

