/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.Collections;
import java.util.List;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.query.sqm.CastType;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.function.FunctionKind;
import org.hibernate.query.sqm.produce.function.ArgumentTypesValidator;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Distinct;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Overflow;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.SortSpecification;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.spi.TypeConfiguration;

public class ListaggStringAggEmulation
extends AbstractSqmSelfRenderingFunctionDescriptor {
    public static final String FUNCTION_NAME = "listagg";
    private final String functionName;
    private final String stringType;
    private final boolean withinGroupClause;

    public ListaggStringAggEmulation(String functionName, String stringType, boolean withinGroupClause, TypeConfiguration typeConfiguration) {
        super(FUNCTION_NAME, FunctionKind.ORDERED_SET_AGGREGATE, new ArgumentTypesValidator(StandardArgumentsValidators.exactly(2), FunctionParameterType.STRING, FunctionParameterType.STRING), StandardFunctionReturnTypeResolvers.invariant(typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.STRING)), StandardFunctionArgumentTypeResolvers.invariant(typeConfiguration, FunctionParameterType.STRING, FunctionParameterType.STRING));
        this.functionName = functionName;
        this.stringType = stringType;
        this.withinGroupClause = withinGroupClause;
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        this.render(sqlAppender, sqlAstArguments, null, Collections.emptyList(), returnType, walker);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, Predicate filter, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        this.render(sqlAppender, sqlAstArguments, filter, Collections.emptyList(), returnType, walker);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, Predicate filter, List<SortSpecification> withinGroup, ReturnableType<?> returnType, SqlAstTranslator<?> translator) {
        Expression arg;
        boolean caseWrapper = filter != null && !translator.getSessionFactory().getJdbcServices().getDialect().supportsFilterClause();
        sqlAppender.appendSql(this.functionName);
        sqlAppender.appendSql('(');
        SqlAstNode firstArg = sqlAstArguments.get(0);
        if (firstArg instanceof Distinct) {
            Distinct distinct = (Distinct)firstArg;
            sqlAppender.appendSql("distinct ");
            arg = distinct.getExpression();
        } else {
            arg = (Expression)firstArg;
        }
        if (caseWrapper) {
            translator.getCurrentClauseStack().push(Clause.WHERE);
            sqlAppender.appendSql("case when ");
            filter.accept(translator);
            sqlAppender.appendSql(" then ");
            this.renderAsString(sqlAppender, translator, arg);
            sqlAppender.appendSql(" else null end");
            translator.getCurrentClauseStack().pop();
        } else {
            this.renderAsString(sqlAppender, translator, arg);
        }
        if (sqlAstArguments.size() != 1) {
            SqlAstNode separator = sqlAstArguments.get(1);
            if (separator instanceof Overflow) {
                Overflow overflow = (Overflow)separator;
                separator = overflow.getSeparatorExpression();
            }
            sqlAppender.appendSql(',');
            separator.accept(translator);
            if (!this.withinGroupClause && withinGroup != null && !withinGroup.isEmpty()) {
                translator.getCurrentClauseStack().push(Clause.WITHIN_GROUP);
                sqlAppender.appendSql(" order by ");
                withinGroup.get(0).accept(translator);
                for (int i = 1; i < withinGroup.size(); ++i) {
                    sqlAppender.appendSql(',');
                    withinGroup.get(i).accept(translator);
                }
                translator.getCurrentClauseStack().pop();
            }
        }
        sqlAppender.appendSql(')');
        if (this.withinGroupClause && withinGroup != null && !withinGroup.isEmpty()) {
            translator.getCurrentClauseStack().push(Clause.WITHIN_GROUP);
            sqlAppender.appendSql(" within group (order by ");
            withinGroup.get(0).accept(translator);
            for (int i = 1; i < withinGroup.size(); ++i) {
                sqlAppender.appendSql(',');
                withinGroup.get(i).accept(translator);
            }
            sqlAppender.appendSql(')');
            translator.getCurrentClauseStack().pop();
        }
        if (!caseWrapper && filter != null) {
            translator.getCurrentClauseStack().push(Clause.WHERE);
            sqlAppender.appendSql(" filter (where ");
            filter.accept(translator);
            sqlAppender.appendSql(')');
            translator.getCurrentClauseStack().pop();
        }
    }

    private void renderAsString(SqlAppender sqlAppender, SqlAstTranslator<?> translator, Expression expression) {
        JdbcMapping sourceMapping = expression.getExpressionType().getSingleJdbcMapping();
        if (sourceMapping.getCastType() == CastType.STRING) {
            expression.accept(translator);
        } else {
            sqlAppender.appendSql("cast(");
            expression.accept(translator);
            sqlAppender.appendSql(" as ");
            sqlAppender.appendSql(this.stringType);
            sqlAppender.appendSql(')');
        }
    }
}

