/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.dialect.function.array.DdlTypeHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.query.sqm.produce.function.FunctionArgumentTypeResolver;
import org.hibernate.query.sqm.produce.function.internal.AbstractFunctionArgumentTypeResolver;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.type.BasicPluralType;

public class ArrayAndElementArgumentTypeResolver
extends AbstractFunctionArgumentTypeResolver {
    public static final FunctionArgumentTypeResolver DEFAULT_INSTANCE = new ArrayAndElementArgumentTypeResolver(0, 1);
    private final int arrayIndex;
    private final int[] elementIndexes;

    public ArrayAndElementArgumentTypeResolver(int arrayIndex, int ... elementIndexes) {
        this.arrayIndex = arrayIndex;
        this.elementIndexes = elementIndexes;
    }

    @Override
    public @Nullable MappingModelExpressible<?> resolveFunctionArgumentType(List<? extends SqmTypedNode<?>> arguments, int argumentIndex, SqmToSqlAstConverter converter) {
        JdbcMapping jdbcMapping;
        SqmExpression sqmExpression;
        MappingModelExpressible<?> expressible;
        SqmTypedNode<?> node;
        if (argumentIndex == this.arrayIndex) {
            for (int elementIndex : this.elementIndexes) {
                SqmExpression sqmExpression2;
                MappingModelExpressible<?> expressible2;
                SqmTypedNode<?> node2 = arguments.get(elementIndex);
                if (!(node2 instanceof SqmExpression) || (expressible2 = converter.determineValueMapping(sqmExpression2 = (SqmExpression)node2)) == null) continue;
                return DdlTypeHelper.resolveArrayType((DomainType)((Object)expressible2.getSingleJdbcMapping()), converter.getCreationContext().getTypeConfiguration());
            }
        } else if (ArrayHelper.contains(this.elementIndexes, argumentIndex) && (node = arguments.get(this.arrayIndex)) instanceof SqmExpression && (expressible = converter.determineValueMapping(sqmExpression = (SqmExpression)node)) != null && (jdbcMapping = expressible.getSingleJdbcMapping()) instanceof BasicPluralType) {
            BasicPluralType basicPluralType = (BasicPluralType)jdbcMapping;
            return basicPluralType.getElementType();
        }
        return null;
    }
}

