/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.List;
import org.hibernate.dialect.function.array.ArrayToStringFunction;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.SqlTypes;
import org.hibernate.type.spi.TypeConfiguration;

public class HSQLArrayToStringFunction
extends ArrayToStringFunction {
    public HSQLArrayToStringFunction(TypeConfiguration typeConfiguration) {
        super(typeConfiguration);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        Expression arrayExpression = (Expression)sqlAstArguments.get(0);
        Expression separatorExpression = (Expression)sqlAstArguments.get(1);
        Expression defaultExpression = sqlAstArguments.size() > 2 ? (Expression)sqlAstArguments.get(2) : null;
        BasicPluralType pluralType = (BasicPluralType)arrayExpression.getExpressionType().getSingleJdbcMapping();
        int ddlTypeCode = pluralType.getElementType().getJdbcType().getDdlTypeCode();
        boolean needsCast = !SqlTypes.isStringType(ddlTypeCode);
        sqlAppender.append("case when ");
        arrayExpression.accept(walker);
        sqlAppender.append(" is not null then coalesce((select group_concat(");
        if (defaultExpression != null) {
            sqlAppender.append("coalesce(");
        }
        if (needsCast) {
            if (ddlTypeCode == 16) {
                sqlAppender.append("lower(");
            }
            sqlAppender.append("cast(");
        }
        sqlAppender.append("t.val");
        if (needsCast) {
            sqlAppender.append(" as longvarchar)");
            if (ddlTypeCode == 16) {
                sqlAppender.append(')');
            }
        }
        if (defaultExpression != null) {
            sqlAppender.append(",");
            defaultExpression.accept(walker);
            sqlAppender.append(")");
        }
        sqlAppender.append(" order by t.idx separator ");
        walker.render(separatorExpression, SqlAstNodeRenderingMode.INLINE_PARAMETERS);
        sqlAppender.append(") from unnest(");
        arrayExpression.accept(walker);
        sqlAppender.append(") with ordinality t(val,idx)),'') end");
    }
}

