/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.lock;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.StaleObjectStateException;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.sql.SimpleSelect;
import org.hibernate.stat.spi.StatisticsImplementor;

public abstract class AbstractSelectLockingStrategy
implements LockingStrategy {
    private final EntityPersister lockable;
    private final LockMode lockMode;
    private final String waitForeverSql;
    private String noWaitSql;
    private String skipLockedSql;

    protected AbstractSelectLockingStrategy(EntityPersister lockable, LockMode lockMode) {
        this.lockable = lockable;
        this.lockMode = lockMode;
        this.waitForeverSql = this.generateLockString(-1);
    }

    protected EntityPersister getLockable() {
        return this.lockable;
    }

    protected LockMode getLockMode() {
        return this.lockMode;
    }

    protected String generateLockString(int lockTimeout) {
        SessionFactoryImplementor factory = this.lockable.getFactory();
        LockOptions lockOptions = new LockOptions(this.lockMode);
        lockOptions.setTimeOut(lockTimeout);
        SimpleSelect select = new SimpleSelect(factory).setLockOptions(lockOptions).setTableName(this.lockable.getRootTableName()).addColumn(this.lockable.getRootTableIdentifierColumnNames()[0]).addRestriction(this.lockable.getRootTableIdentifierColumnNames());
        if (this.lockable.isVersioned()) {
            select.addRestriction(this.lockable.getVersionColumnName());
        }
        if (factory.getSessionFactoryOptions().isCommentsEnabled()) {
            select.setComment(String.valueOf((Object)this.lockMode) + " lock " + this.lockable.getEntityName());
        }
        return select.toStatementString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock(Object id, Object version, Object object, int timeout, SharedSessionContractImplementor session) throws StaleObjectStateException, JDBCException {
        String sql = this.determineSql(timeout);
        SessionFactoryImplementor factory = session.getFactory();
        EntityPersister lockable = this.getLockable();
        try {
            JdbcCoordinator jdbcCoordinator = session.getJdbcCoordinator();
            PreparedStatement st = jdbcCoordinator.getStatementPreparer().prepareStatement(sql);
            try {
                lockable.getIdentifierType().nullSafeSet(st, id, 1, session);
                if (lockable.isVersioned()) {
                    lockable.getVersionType().nullSafeSet(st, version, lockable.getIdentifierType().getColumnSpan(factory.getRuntimeMetamodels()) + 1, session);
                }
                ResultSet rs = jdbcCoordinator.getResultSetReturn().extract(st, sql);
                try {
                    if (!rs.next()) {
                        StatisticsImplementor statistics = factory.getStatistics();
                        if (statistics.isStatisticsEnabled()) {
                            statistics.optimisticFailure(lockable.getEntityName());
                        }
                        throw new StaleObjectStateException(lockable.getEntityName(), id);
                    }
                }
                finally {
                    jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(rs, st);
                }
            }
            finally {
                jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(st);
                jdbcCoordinator.afterStatementExecution();
            }
        }
        catch (SQLException sqle) {
            throw this.convertException(object, this.jdbcException(id, session, sqle, sql));
        }
    }

    private JDBCException jdbcException(Object id, SharedSessionContractImplementor session, SQLException sqle, String sql) {
        return session.getJdbcServices().getSqlExceptionHelper().convert(sqle, "could not lock: " + MessageHelper.infoString(this.lockable, id, session.getFactory()), sql);
    }

    protected HibernateException convertException(Object entity, JDBCException ex) {
        return ex;
    }

    protected String determineSql(int timeout) {
        switch (timeout) {
            case -1: {
                return this.waitForeverSql;
            }
            case 0: {
                return this.getNoWaitSql();
            }
            case -2: {
                return this.getSkipLockedSql();
            }
        }
        return this.generateLockString(timeout);
    }

    protected String getNoWaitSql() {
        if (this.noWaitSql == null) {
            this.noWaitSql = this.generateLockString(0);
        }
        return this.noWaitSql;
    }

    protected String getSkipLockedSql() {
        if (this.skipLockedSql == null) {
            this.skipLockedSql = this.generateLockString(-2);
        }
        return this.skipLockedSql;
    }
}

