/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.sql.ast;

import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.from.DerivedTableReference;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class SpannerSqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    private boolean correlated;

    public SpannerSqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    @Override
    protected AbstractSqlAstTranslator.LockStrategy determineLockingStrategy(QuerySpec querySpec, AbstractSqlAstTranslator.ForUpdateClause forUpdateClause, Boolean followOnLocking) {
        return AbstractSqlAstTranslator.LockStrategy.NONE;
    }

    @Override
    protected void renderForUpdateClause(QuerySpec querySpec, AbstractSqlAstTranslator.ForUpdateClause forUpdateClause) {
    }

    @Override
    public void visitOffsetFetchClause(QueryPart queryPart) {
        this.renderLimitOffsetClause(queryPart);
    }

    @Override
    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        this.renderComparisonEmulateIntersect(lhs, operator, rhs);
    }

    @Override
    protected void renderSelectTupleComparison(List<SqlSelection> lhsExpressions, SqlTuple tuple, ComparisonOperator operator) {
        this.emulateSelectTupleComparison(lhsExpressions, tuple.getExpressions(), operator, true);
    }

    @Override
    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("'0' || '0'");
        } else {
            if (expression instanceof Summarization) {
                throw new UnsupportedOperationException("Summarization is not supported by DBMS");
            }
            expression.accept(this);
        }
    }

    @Override
    public void visitSelectClause(SelectClause selectClause) {
        this.getClauseStack().push(Clause.SELECT);
        try {
            this.appendSql("select ");
            if (this.correlated) {
                this.appendSql("as struct ");
            }
            if (selectClause.isDistinct()) {
                this.appendSql("distinct ");
            }
            this.visitSqlSelections(selectClause);
        }
        finally {
            this.getClauseStack().pop();
        }
    }

    @Override
    protected void renderDerivedTableReference(DerivedTableReference tableReference) {
        boolean correlated = tableReference.isLateral();
        boolean oldCorrelated = this.correlated;
        if (correlated) {
            this.correlated = true;
            this.appendSql("unnest(array");
        }
        tableReference.accept(this);
        if (correlated) {
            this.correlated = oldCorrelated;
            this.appendSql(')');
        }
    }
}

