/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.sql.ast;

import java.util.List;
import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.query.IllegalQueryOperationException;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.expression.BinaryArithmeticExpression;
import org.hibernate.sql.ast.tree.expression.CaseSearchedExpression;
import org.hibernate.sql.ast.tree.expression.CaseSimpleExpression;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.UnionTableReference;
import org.hibernate.sql.ast.tree.from.ValuesTableReference;
import org.hibernate.sql.ast.tree.insert.ConflictClause;
import org.hibernate.sql.ast.tree.insert.InsertSelectStatement;
import org.hibernate.sql.ast.tree.insert.Values;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class SybaseSqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    private static final String UNION_ALL = " union all ";

    public SybaseSqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    @Override
    protected void visitInsertStatementOnly(InsertSelectStatement statement) {
        if (statement.getConflictClause() == null || statement.getConflictClause().isDoNothing()) {
            super.visitInsertStatementOnly(statement);
        } else {
            this.visitInsertStatementEmulateMerge(statement);
            this.appendSql(';');
        }
    }

    @Override
    protected void renderDeleteClause(DeleteStatement statement) {
        this.appendSql("delete ");
        Stack<Clause> clauseStack = this.getClauseStack();
        try {
            clauseStack.push(Clause.DELETE);
            this.renderDmlTargetTableExpression(statement.getTargetTable());
        }
        finally {
            clauseStack.pop();
        }
        this.visitFromClause(statement.getFromClause());
    }

    @Override
    protected void renderFromClauseAfterUpdateSet(UpdateStatement statement) {
        this.visitFromClause(statement.getFromClause());
    }

    @Override
    protected void visitConflictClause(ConflictClause conflictClause) {
        if (conflictClause != null && conflictClause.isDoUpdate() && conflictClause.getConstraintName() != null) {
            throw new IllegalQueryOperationException("Insert conflict 'do update' clause with constraint name is not supported");
        }
    }

    @Override
    protected void visitAnsiCaseSearchedExpression(CaseSearchedExpression caseSearchedExpression, Consumer<Expression> resultRenderer) {
        if (this.getParameterRenderingMode() == SqlAstNodeRenderingMode.DEFAULT && this.areAllResultsParameters(caseSearchedExpression)) {
            List<CaseSearchedExpression.WhenFragment> whenFragments = caseSearchedExpression.getWhenFragments();
            Expression firstResult = whenFragments.get(0).getResult();
            super.visitAnsiCaseSearchedExpression(caseSearchedExpression, e -> {
                if (e == firstResult) {
                    this.renderCasted((Expression)e);
                } else {
                    resultRenderer.accept((Expression)e);
                }
            });
        } else {
            super.visitAnsiCaseSearchedExpression(caseSearchedExpression, resultRenderer);
        }
    }

    @Override
    protected void visitAnsiCaseSimpleExpression(CaseSimpleExpression caseSimpleExpression, Consumer<Expression> resultRenderer) {
        if (this.getParameterRenderingMode() == SqlAstNodeRenderingMode.DEFAULT && this.areAllResultsParameters(caseSimpleExpression)) {
            List<CaseSimpleExpression.WhenFragment> whenFragments = caseSimpleExpression.getWhenFragments();
            Expression firstResult = whenFragments.get(0).getResult();
            super.visitAnsiCaseSimpleExpression(caseSimpleExpression, e -> {
                if (e == firstResult) {
                    this.renderCasted((Expression)e);
                } else {
                    resultRenderer.accept((Expression)e);
                }
            });
        } else {
            super.visitAnsiCaseSimpleExpression(caseSimpleExpression, resultRenderer);
        }
    }

    @Override
    protected boolean renderNamedTableReference(NamedTableReference tableReference, LockMode lockMode) {
        String tableExpression = tableReference.getTableExpression();
        if (tableReference instanceof UnionTableReference && lockMode != LockMode.NONE && tableExpression.charAt(0) == '(') {
            int unionIndex;
            int searchIndex = 0;
            while ((unionIndex = tableExpression.indexOf(UNION_ALL, searchIndex)) != -1) {
                this.append(tableExpression, searchIndex, unionIndex);
                this.renderLockHint(lockMode);
                this.appendSql(UNION_ALL);
                searchIndex = unionIndex + UNION_ALL.length();
            }
            this.append(tableExpression, searchIndex, tableExpression.length() - 1);
            this.renderLockHint(lockMode);
            this.appendSql(" )");
            this.registerAffectedTable(tableReference);
            this.renderTableReferenceIdentificationVariable(tableReference);
        } else {
            super.renderNamedTableReference(tableReference, lockMode);
            this.renderLockHint(lockMode);
        }
        return true;
    }

    private void renderLockHint(LockMode lockMode) {
        if (LockMode.READ.lessThan(lockMode)) {
            this.appendSql(" holdlock");
        }
    }

    @Override
    protected AbstractSqlAstTranslator.LockStrategy determineLockingStrategy(QuerySpec querySpec, AbstractSqlAstTranslator.ForUpdateClause forUpdateClause, Boolean followOnLocking) {
        return AbstractSqlAstTranslator.LockStrategy.CLAUSE;
    }

    @Override
    protected void renderForUpdateClause(QuerySpec querySpec, AbstractSqlAstTranslator.ForUpdateClause forUpdateClause) {
    }

    @Override
    protected void visitValuesList(List<Values> valuesList) {
        this.visitValuesListEmulateSelectUnion(valuesList);
    }

    @Override
    public void visitValuesTableReference(ValuesTableReference tableReference) {
        this.append('(');
        this.visitValuesListEmulateSelectUnion(tableReference.getValuesList());
        this.append(')');
        this.renderDerivedTableReferenceIdentificationVariable(tableReference);
    }

    @Override
    public void visitOffsetFetchClause(QueryPart queryPart) {
        this.assertRowsOnlyFetchClauseType(queryPart);
        if (!queryPart.isRoot() && queryPart.getOffsetClauseExpression() != null) {
            throw new IllegalArgumentException("Can't emulate offset clause in subquery");
        }
    }

    @Override
    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        this.renderComparisonEmulateIntersect(lhs, operator, rhs);
    }

    @Override
    protected void renderSelectTupleComparison(List<SqlSelection> lhsExpressions, SqlTuple tuple, ComparisonOperator operator) {
        this.emulateSelectTupleComparison(lhsExpressions, tuple.getExpressions(), operator, true);
    }

    @Override
    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("dummy_.x");
        } else {
            if (expression instanceof Summarization) {
                throw new UnsupportedOperationException("Summarization is not supported by DBMS");
            }
            expression.accept(this);
        }
    }

    @Override
    public void visitBinaryArithmeticExpression(BinaryArithmeticExpression arithmeticExpression) {
        this.appendSql('(');
        this.visitArithmeticOperand(arithmeticExpression.getLeftHandOperand());
        this.appendSql(arithmeticExpression.getOperator().getOperatorSqlTextString());
        this.visitArithmeticOperand(arithmeticExpression.getRightHandOperand());
        this.appendSql(')');
    }

    @Override
    protected boolean needsRowsToSkip() {
        return true;
    }

    @Override
    protected boolean needsMaxRows() {
        return true;
    }
}

