/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.AssertionFailure;
import org.hibernate.CustomEntityDirtinessStrategy;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.bytecode.enhance.spi.interceptor.EnhancementAsProxyLazinessInterceptor;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.internal.EntityEntryExtraStateHolder;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.spi.CachedNaturalIdValueSource;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityEntryExtraState;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SelfDirtinessTracker;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.internal.util.ImmutableBitSet;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.type.TypeHelper;

public abstract class AbstractEntityEntry
implements Serializable,
EntityEntry {
    protected final Object id;
    protected Object[] loadedState;
    protected Object version;
    protected final EntityPersister persister;
    protected transient EntityKey cachedEntityKey;
    protected final transient Object rowId;
    protected final transient PersistenceContext persistenceContext;
    protected transient @Nullable ImmutableBitSet maybeLazySet;
    protected EntityEntryExtraState next;
    private transient int compressedState;

    public AbstractEntityEntry(Status status, Object[] loadedState, Object rowId, Object id, Object version, LockMode lockMode, boolean existsInDatabase, EntityPersister persister, boolean disableVersionIncrement, PersistenceContext persistenceContext) {
        this.setCompressedValue(EnumState.STATUS, status);
        this.setCompressedValue(EnumState.PREVIOUS_STATUS, null);
        if (status != Status.READ_ONLY) {
            this.loadedState = loadedState;
        }
        this.id = id;
        this.rowId = rowId;
        this.setCompressedValue(BooleanState.EXISTS_IN_DATABASE, existsInDatabase);
        this.version = version;
        this.setCompressedValue(EnumState.LOCK_MODE, lockMode);
        this.setCompressedValue(BooleanState.IS_BEING_REPLICATED, disableVersionIncrement);
        this.persister = persister;
        this.persistenceContext = persistenceContext;
    }

    protected AbstractEntityEntry(SessionFactoryImplementor factory, String entityName, Object id, Status status, Status previousStatus, Object[] loadedState, Object[] deletedState, Object version, LockMode lockMode, boolean existsInDatabase, boolean isBeingReplicated, PersistenceContext persistenceContext) {
        this.persister = factory == null ? null : factory.getMappingMetamodel().getEntityDescriptor(entityName);
        this.id = id;
        this.setCompressedValue(EnumState.STATUS, status);
        this.setCompressedValue(EnumState.PREVIOUS_STATUS, previousStatus);
        this.loadedState = loadedState;
        this.setDeletedState(deletedState);
        this.version = version;
        this.setCompressedValue(EnumState.LOCK_MODE, lockMode);
        this.setCompressedValue(BooleanState.EXISTS_IN_DATABASE, existsInDatabase);
        this.setCompressedValue(BooleanState.IS_BEING_REPLICATED, isBeingReplicated);
        this.rowId = null;
        this.persistenceContext = persistenceContext;
    }

    @Override
    public LockMode getLockMode() {
        return this.getCompressedValue(EnumState.LOCK_MODE);
    }

    @Override
    public void setLockMode(LockMode lockMode) {
        this.setCompressedValue(EnumState.LOCK_MODE, lockMode);
    }

    @Override
    public Status getStatus() {
        return this.getCompressedValue(EnumState.STATUS);
    }

    private Status getPreviousStatus() {
        return this.getCompressedValue(EnumState.PREVIOUS_STATUS);
    }

    @Override
    public void setStatus(Status status) {
        Status currentStatus;
        if (status == Status.READ_ONLY) {
            this.loadedState = null;
        }
        if ((currentStatus = this.getStatus()) != status) {
            this.setCompressedValue(EnumState.PREVIOUS_STATUS, currentStatus);
            this.setCompressedValue(EnumState.STATUS, status);
        }
    }

    @Override
    public final Object getId() {
        return this.id;
    }

    @Override
    public final Object[] getLoadedState() {
        return this.loadedState;
    }

    @Override
    public Object[] getDeletedState() {
        EntityEntryExtraStateHolder extra = this.getExtraState(EntityEntryExtraStateHolder.class);
        return extra == null ? null : extra.getDeletedState();
    }

    @Override
    public void setDeletedState(Object[] deletedState) {
        EntityEntryExtraStateHolder existingExtra = this.getExtraState(EntityEntryExtraStateHolder.class);
        if (existingExtra != null) {
            existingExtra.setDeletedState(deletedState);
        } else if (deletedState != null) {
            EntityEntryExtraStateHolder newExtra = new EntityEntryExtraStateHolder();
            newExtra.setDeletedState(deletedState);
            this.addExtraState(newExtra);
        }
    }

    @Override
    public boolean isExistsInDatabase() {
        return this.getCompressedValue(BooleanState.EXISTS_IN_DATABASE);
    }

    @Override
    public final Object getVersion() {
        return this.version;
    }

    @Override
    public void postInsert(Object version) {
        this.version = version;
    }

    @Override
    public final EntityPersister getPersister() {
        return this.persister;
    }

    @Override
    public EntityKey getEntityKey() {
        if (this.cachedEntityKey == null) {
            if (this.getId() == null) {
                throw new IllegalStateException("cannot generate an EntityKey when id is null.");
            }
            this.cachedEntityKey = new EntityKey(this.getId(), this.getPersister());
        }
        return this.cachedEntityKey;
    }

    @Override
    public String getEntityName() {
        return this.persister == null ? null : this.persister.getEntityName();
    }

    @Override
    public boolean isBeingReplicated() {
        return this.getCompressedValue(BooleanState.IS_BEING_REPLICATED);
    }

    @Override
    public Object getRowId() {
        return this.rowId;
    }

    @Override
    public void postUpdate(Object entity, Object[] updatedState, Object nextVersion) {
        this.loadedState = updatedState;
        this.setLockMode(LockMode.WRITE);
        if (this.persister.isVersioned()) {
            this.version = nextVersion;
            this.persister.setValue(entity, this.persister.getVersionProperty(), nextVersion);
        }
        ManagedTypeHelper.processIfSelfDirtinessTracker(entity, AbstractEntityEntry::clearDirtyAttributes);
        ManagedTypeHelper.processIfManagedEntity(entity, AbstractEntityEntry::useTracker);
        SharedSessionContractImplementor session = this.getPersistenceContext().getSession();
        session.getFactory().getCustomEntityDirtinessStrategy().resetDirty(entity, this.persister, (SessionImplementor)session);
    }

    private static void clearDirtyAttributes(SelfDirtinessTracker entity) {
        entity.$$_hibernate_clearDirtyAttributes();
    }

    private static void useTracker(ManagedEntity entity) {
        entity.$$_hibernate_setUseTracker(true);
    }

    @Override
    public void postDelete() {
        this.setCompressedValue(EnumState.PREVIOUS_STATUS, this.getStatus());
        this.setCompressedValue(EnumState.STATUS, Status.GONE);
        this.setCompressedValue(BooleanState.EXISTS_IN_DATABASE, false);
    }

    @Override
    public void postInsert(Object[] insertedState) {
        this.setCompressedValue(BooleanState.EXISTS_IN_DATABASE, true);
    }

    @Override
    public boolean isNullifiable(boolean earlyInsert, SharedSessionContractImplementor session) {
        if (this.getStatus() == Status.SAVING) {
            return true;
        }
        if (earlyInsert) {
            return !this.isExistsInDatabase();
        }
        return session.getPersistenceContextInternal().containsNullifiableEntityKey(this::getEntityKey);
    }

    @Override
    public Object getLoadedValue(String propertyName) {
        if (this.loadedState == null || propertyName == null) {
            return null;
        }
        int index = this.propertyIndex(propertyName);
        return index < 0 ? null : this.loadedState[index];
    }

    private int propertyIndex(String propertyName) {
        AttributeMapping attributeMapping = this.persister.findAttributeMapping(propertyName);
        return attributeMapping != null ? attributeMapping.getStateArrayPosition() : -1;
    }

    @Override
    public void overwriteLoadedStateCollectionValue(String propertyName, PersistentCollection<?> collection) {
        if (this.getStatus() != Status.READ_ONLY) {
            assert (propertyName != null);
            assert (this.loadedState != null);
            this.loadedState[this.propertyIndex((String)propertyName)] = collection;
        }
    }

    @Override
    public boolean requiresDirtyCheck(Object entity) {
        return this.isModifiableEntity() && !this.isUnequivocallyNonDirty(entity);
    }

    private boolean isUnequivocallyNonDirty(Object entity) {
        return ManagedTypeHelper.isSelfDirtinessTracker(entity) ? this.isNonDirtyViaTracker(entity) : this.isNonDirtyViaCustomStrategy(entity);
    }

    private boolean isNonDirtyViaCustomStrategy(Object entity) {
        PersistentAttributeInterceptor interceptor;
        if (ManagedTypeHelper.isPersistentAttributeInterceptable(entity) && (interceptor = ManagedTypeHelper.asPersistentAttributeInterceptable(entity).$$_hibernate_getInterceptor()) instanceof EnhancementAsProxyLazinessInterceptor) {
            return true;
        }
        SessionImplementor session = (SessionImplementor)this.getPersistenceContext().getSession();
        CustomEntityDirtinessStrategy customEntityDirtinessStrategy = session.getFactory().getCustomEntityDirtinessStrategy();
        return customEntityDirtinessStrategy.canDirtyCheck(entity, this.getPersister(), session) && !customEntityDirtinessStrategy.isDirty(entity, this.getPersister(), session);
    }

    private boolean isNonDirtyViaTracker(Object entity) {
        boolean uninitializedProxy;
        if (ManagedTypeHelper.isPersistentAttributeInterceptable(entity)) {
            PersistentAttributeInterceptor interceptor = ManagedTypeHelper.asPersistentAttributeInterceptable(entity).$$_hibernate_getInterceptor();
            if (interceptor instanceof EnhancementAsProxyLazinessInterceptor) {
                EnhancementAsProxyLazinessInterceptor lazinessInterceptor = (EnhancementAsProxyLazinessInterceptor)interceptor;
                return !lazinessInterceptor.hasWrittenFieldNames();
            }
            uninitializedProxy = false;
        } else {
            uninitializedProxy = ManagedTypeHelper.isHibernateProxy(entity) ? HibernateProxy.extractLazyInitializer(entity).isUninitialized() : false;
        }
        return uninitializedProxy || !this.persister.hasCollections() && !this.persister.hasMutableProperties() && !ManagedTypeHelper.asSelfDirtinessTracker(entity).$$_hibernate_hasDirtyAttributes() && ManagedTypeHelper.asManagedEntity(entity).$$_hibernate_useTracker();
    }

    @Override
    public boolean isModifiableEntity() {
        Status status = this.getStatus();
        Status previousStatus = this.getPreviousStatus();
        return this.persister.isMutable() && status != Status.READ_ONLY && (status != Status.DELETED || previousStatus != Status.READ_ONLY);
    }

    @Override
    public void forceLocked(Object entity, Object nextVersion) {
        this.loadedState[this.persister.getVersionProperty()] = this.version = nextVersion;
        this.setLockMode(LockMode.PESSIMISTIC_FORCE_INCREMENT);
        this.persister.setValue(entity, this.getPersister().getVersionProperty(), nextVersion);
    }

    @Override
    public boolean isReadOnly() {
        Status status = this.getStatus();
        if (status != Status.MANAGED && status != Status.READ_ONLY) {
            throw new HibernateException("instance was not in a valid state");
        }
        return status == Status.READ_ONLY;
    }

    @Override
    public void setReadOnly(boolean readOnly, Object entity) {
        if (readOnly != this.isReadOnly()) {
            if (readOnly) {
                this.setStatus(Status.READ_ONLY);
                this.loadedState = null;
            } else {
                if (!this.persister.isMutable()) {
                    throw new IllegalStateException("Cannot make an entity of immutable type '" + this.persister.getEntityName() + "' modifiable");
                }
                this.setStatus(Status.MANAGED);
                this.loadedState = this.persister.getValues(entity);
                TypeHelper.deepCopy(this.loadedState, this.persister.getPropertyTypes(), this.persister.getPropertyCheckability(), this.loadedState, this.getPersistenceContext().getSession());
                if (this.persister.hasNaturalIdentifier()) {
                    this.getPersistenceContext().getNaturalIdResolutions().manageLocalResolution(this.id, this.persister.getNaturalIdMapping().extractNaturalIdFromEntityState(this.loadedState), this.persister, CachedNaturalIdValueSource.LOAD);
                }
            }
        }
    }

    @Override
    public @Nullable ImmutableBitSet getMaybeLazySet() {
        return this.maybeLazySet;
    }

    @Override
    public void setMaybeLazySet(@Nullable ImmutableBitSet maybeLazySet) {
        this.maybeLazySet = maybeLazySet;
    }

    @Override
    public String toString() {
        return "EntityEntry" + MessageHelper.infoString(this.getPersister().getEntityName(), this.id) + "(" + String.valueOf((Object)this.getStatus()) + ")";
    }

    @Override
    public void serialize(ObjectOutputStream oos) throws IOException {
        Status previousStatus = this.getPreviousStatus();
        oos.writeObject(this.getEntityName());
        oos.writeObject(this.id);
        oos.writeObject(this.getStatus().name());
        oos.writeObject(previousStatus == null ? "" : previousStatus.name());
        oos.writeObject(this.loadedState);
        oos.writeObject(this.getDeletedState());
        oos.writeObject(this.version);
        oos.writeObject(this.getLockMode().toString());
        oos.writeBoolean(this.isExistsInDatabase());
        oos.writeBoolean(this.isBeingReplicated());
    }

    @Override
    public void addExtraState(EntityEntryExtraState extraState) {
        if (this.next == null) {
            this.next = extraState;
        } else {
            this.next.addExtraState(extraState);
        }
    }

    @Override
    public <T extends EntityEntryExtraState> T getExtraState(Class<T> extraStateType) {
        if (this.next == null) {
            return null;
        }
        if (extraStateType.isAssignableFrom(this.next.getClass())) {
            return (T)this.next;
        }
        return this.next.getExtraState(extraStateType);
    }

    public PersistenceContext getPersistenceContext() {
        return this.persistenceContext;
    }

    protected <E extends Enum<E>> void setCompressedValue(EnumState<E> state, E value) {
        this.compressedState &= state.getUnsetMask();
        this.compressedState |= state.getValue(value) << state.getOffset();
    }

    protected <E extends Enum<E>> E getCompressedValue(EnumState<E> state) {
        int index = ((this.compressedState & state.getMask()) >> state.getOffset()) - 1;
        return (E)(index == -1 ? null : state.getEnumConstants()[index]);
    }

    protected void setCompressedValue(BooleanState state, boolean value) {
        this.compressedState &= state.getUnsetMask();
        this.compressedState |= state.getValue(value) << state.getOffset();
    }

    protected boolean getCompressedValue(BooleanState state) {
        return (this.compressedState & state.getMask()) >> state.getOffset() == 1;
    }

    protected static class EnumState<E extends Enum<E>> {
        protected static final EnumState<LockMode> LOCK_MODE = new EnumState<LockMode>(0, LockMode.class);
        protected static final EnumState<Status> STATUS = new EnumState<Status>(4, Status.class);
        protected static final EnumState<Status> PREVIOUS_STATUS = new EnumState<Status>(8, Status.class);
        protected final int offset;
        protected final E[] enumConstants;
        protected final int mask;
        protected final int unsetMask;

        private EnumState(int offset, Class<E> enumType) {
            Enum[] enumConstants = (Enum[])enumType.getEnumConstants();
            if (enumConstants.length > 15) {
                throw new AssertionFailure("Cannot store enum type " + enumType.getName() + " in compressed state as it has too many values.");
            }
            this.offset = offset;
            this.enumConstants = enumConstants;
            this.mask = 15 << offset;
            this.unsetMask = 0xFFFF & ~this.mask;
        }

        private int getValue(E value) {
            return value != null ? ((Enum)value).ordinal() + 1 : 0;
        }

        private int getOffset() {
            return this.offset;
        }

        private int getMask() {
            return this.mask;
        }

        private int getUnsetMask() {
            return this.unsetMask;
        }

        private E[] getEnumConstants() {
            return this.enumConstants;
        }
    }

    protected static enum BooleanState {
        EXISTS_IN_DATABASE(13),
        IS_BEING_REPLICATED(14);

        private final int offset;
        private final int mask;
        private final int unsetMask;

        private BooleanState(int offset) {
            this.offset = offset;
            this.mask = 1 << offset;
            this.unsetMask = 0xFFFF & ~this.mask;
        }

        private int getValue(boolean value) {
            return value ? 1 : 0;
        }

        private int getOffset() {
            return this.offset;
        }

        private int getMask() {
            return this.mask;
        }

        private int getUnsetMask() {
            return this.unsetMask;
        }
    }
}

