/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import org.hibernate.cache.MutableCacheKeyBuilder;
import org.hibernate.cache.spi.access.CachedDomainDataAccess;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.monitor.spi.DiagnosticEvent;
import org.hibernate.event.monitor.spi.EventMonitor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.JavaType;

public final class CacheHelper {
    private CacheHelper() {
    }

    public static Object fromSharedCache(SharedSessionContractImplementor session, Object cacheKey, EntityPersister persister, CachedDomainDataAccess cacheAccess) {
        return CacheHelper.fromSharedCache(session, cacheKey, persister, false, cacheAccess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object fromSharedCache(SharedSessionContractImplementor session, Object cacheKey, EntityPersister persister, boolean isNaturalKey, CachedDomainDataAccess cacheAccess) {
        SessionEventListenerManager eventListenerManager = session.getEventListenerManager();
        Object cachedValue = null;
        eventListenerManager.cacheGetStart();
        EventMonitor eventMonitor = session.getEventMonitor();
        DiagnosticEvent cacheGetEvent = eventMonitor.beginCacheGetEvent();
        try {
            cachedValue = cacheAccess.get(session, cacheKey);
            eventMonitor.completeCacheGetEvent(cacheGetEvent, session, cacheAccess.getRegion(), persister, isNaturalKey, cachedValue != null);
            eventListenerManager.cacheGetEnd(cachedValue != null);
        }
        catch (Throwable throwable) {
            eventMonitor.completeCacheGetEvent(cacheGetEvent, session, cacheAccess.getRegion(), persister, isNaturalKey, cachedValue != null);
            eventListenerManager.cacheGetEnd(cachedValue != null);
            throw throwable;
        }
        return cachedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object fromSharedCache(SharedSessionContractImplementor session, Object cacheKey, CollectionPersister persister, CachedDomainDataAccess cacheAccess) {
        SessionEventListenerManager eventListenerManager = session.getEventListenerManager();
        Object cachedValue = null;
        eventListenerManager.cacheGetStart();
        EventMonitor eventMonitor = session.getEventMonitor();
        DiagnosticEvent cacheGetEvent = eventMonitor.beginCacheGetEvent();
        try {
            cachedValue = cacheAccess.get(session, cacheKey);
            eventMonitor.completeCacheGetEvent(cacheGetEvent, session, cacheAccess.getRegion(), persister, cachedValue != null);
            eventListenerManager.cacheGetEnd(cachedValue != null);
        }
        catch (Throwable throwable) {
            eventMonitor.completeCacheGetEvent(cacheGetEvent, session, cacheAccess.getRegion(), persister, cachedValue != null);
            eventListenerManager.cacheGetEnd(cachedValue != null);
            throw throwable;
        }
        return cachedValue;
    }

    public static void addBasicValueToCacheKey(MutableCacheKeyBuilder cacheKey, Object value, JdbcMapping jdbcMapping, SharedSessionContractImplementor session) {
        Object convertedValue;
        JavaType javaType;
        BasicValueConverter converter = jdbcMapping.getValueConverter();
        if (converter == null) {
            javaType = jdbcMapping.getJavaTypeDescriptor();
            convertedValue = value;
        } else {
            javaType = converter.getRelationalJavaType();
            convertedValue = converter.toRelationalValue(value);
        }
        if (convertedValue == null) {
            cacheKey.addValue(null);
            cacheKey.addHashCode(0);
        } else {
            cacheKey.addValue(javaType.getMutabilityPlan().disassemble(convertedValue, session));
            cacheKey.addHashCode(javaType.extractHashCode(convertedValue));
        }
    }
}

