/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.batch;

import java.lang.invoke.MethodHandles;
import org.hibernate.Internal;
import org.hibernate.internal.log.SubSystemLogging;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;

@SubSystemLogging(name="org.hibernate.orm.jdbc.batch", description="Logging related to JDBC batch execution")
@Internal
@MessageLogger(projectCode="HHH")
@ValidIdRange(min=100501, max=101000)
public interface JdbcBatchLogging
extends BasicLogger {
    public static final String NAME = "org.hibernate.orm.jdbc.batch";
    public static final Logger BATCH_LOGGER = Logger.getLogger((String)"org.hibernate.orm.jdbc.batch");
    public static final JdbcBatchLogging BATCH_MESSAGE_LOGGER = (JdbcBatchLogging)Logger.getMessageLogger((MethodHandles.Lookup)MethodHandles.lookup(), JdbcBatchLogging.class, (String)"org.hibernate.orm.jdbc.batch");

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=100502, value="Unable to release batch statement")
    public void unableToReleaseBatchStatement();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=100503, value="On release of batch it still contained JDBC statements")
    public void batchContainedStatementsOnRelease();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Created JDBC batch (%s) - [%s]")
    public void createBatch(int var1, String var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Adding to JDBC batch (%s / %s) - [%s]")
    public void addToBatch(int var1, int var2, String var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Executing JDBC batch (%s / %s) - [%s]")
    public void executeBatch(int var1, int var2, String var3);
}

