/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.connections.internal;

import java.util.Map;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.SimpleDatabaseVersion;
import org.hibernate.engine.jdbc.connections.internal.ConnectionProviderInitiator;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.DatabaseConnectionInfo;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;

public class DatabaseConnectionInfoImpl
implements DatabaseConnectionInfo {
    public static final String DEFAULT = "undefined/unknown";
    private final Class<?> connectionProviderClass;
    protected final String jdbcUrl;
    protected final String jdbcDriver;
    protected final DatabaseVersion dialectVersion;
    protected final String autoCommitMode;
    protected final String isolationLevel;
    protected final Integer poolMinSize;
    protected final Integer poolMaxSize;

    public DatabaseConnectionInfoImpl(Class<? extends ConnectionProvider> connectionProviderClass, String jdbcUrl, String jdbcDriver, DatabaseVersion dialectVersion, String autoCommitMode, String isolationLevel, Integer poolMinSize, Integer poolMaxSize) {
        this.connectionProviderClass = connectionProviderClass;
        this.jdbcUrl = StringHelper.nullIfEmpty(jdbcUrl);
        this.jdbcDriver = StringHelper.nullIfEmpty(jdbcDriver);
        this.dialectVersion = dialectVersion;
        this.autoCommitMode = StringHelper.nullIfEmpty(autoCommitMode);
        this.isolationLevel = StringHelper.nullIfEmpty(isolationLevel);
        this.poolMinSize = poolMinSize;
        this.poolMaxSize = poolMaxSize;
    }

    public DatabaseConnectionInfoImpl(Map<String, Object> settings, Dialect dialect) {
        this(null, DatabaseConnectionInfoImpl.determineUrl(settings), DatabaseConnectionInfoImpl.determineDriver(settings), dialect.getVersion(), DatabaseConnectionInfoImpl.determineAutoCommitMode(settings), DatabaseConnectionInfoImpl.determineIsolationLevel(settings), null, DatabaseConnectionInfoImpl.determinePoolMaxSize(settings));
    }

    public DatabaseConnectionInfoImpl(Dialect dialect) {
        this(null, null, null, dialect.getVersion(), null, null, null, null);
    }

    @Override
    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    @Override
    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    @Override
    public DatabaseVersion getDialectVersion() {
        return this.dialectVersion;
    }

    @Override
    public String getAutoCommitMode() {
        return this.autoCommitMode;
    }

    @Override
    public String getIsolationLevel() {
        return this.isolationLevel;
    }

    @Override
    public Integer getPoolMinSize() {
        return this.poolMinSize;
    }

    @Override
    public Integer getPoolMaxSize() {
        return this.poolMaxSize;
    }

    @Override
    public String toInfoString() {
        return "\tDatabase JDBC URL [" + DatabaseConnectionInfoImpl.handleEmpty(this.jdbcUrl) + "]\n\tDatabase driver: " + DatabaseConnectionInfoImpl.handleEmpty(this.jdbcDriver) + "\n\tDatabase version: " + DatabaseConnectionInfoImpl.handleEmpty(this.dialectVersion) + "\n\tAutocommit mode: " + DatabaseConnectionInfoImpl.handleEmpty(this.autoCommitMode) + "\n\tIsolation level: " + DatabaseConnectionInfoImpl.handleEmpty(this.isolationLevel) + "\n\tPool: " + DatabaseConnectionInfoImpl.handleEmpty(this.connectionProviderClass) + "\n\tMinimum pool size: " + DatabaseConnectionInfoImpl.handleEmpty(this.poolMinSize) + "\n\tMaximum pool size: " + DatabaseConnectionInfoImpl.handleEmpty(this.poolMaxSize);
    }

    private static String handleEmpty(String value) {
        return StringHelper.isNotEmpty(value) ? value : DEFAULT;
    }

    private static String handleEmpty(DatabaseVersion dialectVersion) {
        return dialectVersion != null ? dialectVersion.toString() : SimpleDatabaseVersion.ZERO_VERSION.toString();
    }

    private static String handleEmpty(Integer value) {
        return value != null ? value.toString() : DEFAULT;
    }

    private static String handleEmpty(Class<?> value) {
        return value != null ? value.getSimpleName() : DEFAULT;
    }

    private static String determineUrl(Map<String, Object> settings) {
        return (String)NullnessHelper.coalesceSuppliedValues(() -> ConfigurationHelper.getString("jakarta.persistence.jdbc.url", settings), () -> ConfigurationHelper.getString("hibernate.connection.url", settings), () -> ConfigurationHelper.getString("javax.persistence.jdbc.url", settings));
    }

    private static String determineDriver(Map<String, Object> settings) {
        return (String)NullnessHelper.coalesceSuppliedValues(() -> ConfigurationHelper.getString("jakarta.persistence.jdbc.driver", settings), () -> ConfigurationHelper.getString("hibernate.connection.driver_class", settings), () -> ConfigurationHelper.getString("javax.persistence.jdbc.driver", settings));
    }

    private static String determineAutoCommitMode(Map<String, Object> settings) {
        return ConfigurationHelper.getString("hibernate.connection.autocommit", settings);
    }

    private static String determineIsolationLevel(Map<String, Object> settings) {
        return ConnectionProviderInitiator.toIsolationNiceName(ConnectionProviderInitiator.interpretIsolation(settings.get("hibernate.connection.isolation")));
    }

    private static Integer determinePoolMaxSize(Map<String, Object> settings) {
        return ConfigurationHelper.getInteger("hibernate.connection.pool_size", settings);
    }
}

