/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.connections.internal;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hibernate.HibernateException;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.dialect.Database;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.SimpleDatabaseVersion;
import org.hibernate.engine.jdbc.connections.internal.ConnectionCreator;
import org.hibernate.engine.jdbc.connections.internal.ConnectionCreatorFactory;
import org.hibernate.engine.jdbc.connections.internal.ConnectionCreatorFactoryImpl;
import org.hibernate.engine.jdbc.connections.internal.ConnectionProviderInitiator;
import org.hibernate.engine.jdbc.connections.internal.ConnectionValidator;
import org.hibernate.engine.jdbc.connections.internal.DatabaseConnectionInfoImpl;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProviderConfigurationException;
import org.hibernate.engine.jdbc.connections.spi.DatabaseConnectionInfo;
import org.hibernate.internal.log.ConnectionInfoLogger;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.UnknownUnwrapTypeException;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.ServiceException;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.Stoppable;

public class DriverManagerConnectionProviderImpl
implements ConnectionProvider,
Configurable,
Stoppable,
ServiceRegistryAwareService,
ConnectionValidator {
    public static final String MIN_SIZE = "hibernate.connection.min_pool_size";
    public static final String INITIAL_SIZE = "hibernate.connection.initial_pool_size";
    public static final String VALIDATION_INTERVAL = "hibernate.connection.pool_validation_interval";
    public static final String INIT_SQL = "hibernate.connection.init_sql";
    public static final String CONNECTION_CREATOR_FACTORY = "hibernate.connection.creator_factory_class";
    private volatile PoolState state;
    private static DatabaseConnectionInfo dbInfo;
    private volatile ServiceRegistryImplementor serviceRegistry;

    @Override
    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Override
    public void configure(Map<String, Object> configurationValues) {
        ConnectionInfoLogger.INSTANCE.usingHibernateBuiltInConnectionPool();
        PooledConnections pool = this.buildPool(configurationValues, this.serviceRegistry);
        long validationInterval = ConfigurationHelper.getLong(VALIDATION_INTERVAL, configurationValues, 30);
        this.state = new PoolState(pool, validationInterval);
    }

    private PooledConnections buildPool(Map<String, Object> configurationValues, ServiceRegistryImplementor serviceRegistry) {
        boolean autoCommit = ConfigurationHelper.getBoolean("hibernate.connection.autocommit", configurationValues);
        int minSize = ConfigurationHelper.getInt(MIN_SIZE, configurationValues, 1);
        int maxSize = ConfigurationHelper.getInt("hibernate.connection.pool_size", configurationValues, 20);
        int initialSize = ConfigurationHelper.getInt(INITIAL_SIZE, configurationValues, minSize);
        ConnectionCreator creator = DriverManagerConnectionProviderImpl.buildCreator(configurationValues, serviceRegistry);
        return new PooledConnections.Builder(creator, autoCommit).initialSize(initialSize).minSize(minSize).maxSize(maxSize).validator(this).build();
    }

    private static ConnectionCreator buildCreator(Map<String, Object> configurationValues, ServiceRegistryImplementor serviceRegistry) {
        String url = DriverManagerConnectionProviderImpl.jdbcUrl(configurationValues);
        String driverClassName = (String)configurationValues.get("hibernate.connection.driver_class");
        boolean success = false;
        Driver driver = null;
        if (driverClassName != null) {
            driver = DriverManagerConnectionProviderImpl.loadDriverIfPossible(driverClassName, serviceRegistry);
            success = true;
        } else {
            for (Database database : Database.values()) {
                if (!database.matchesUrl(url) || (driverClassName = database.getDriverClassName(url)) == null) continue;
                try {
                    DriverManagerConnectionProviderImpl.loadDriverIfPossible(driverClassName, serviceRegistry);
                    success = true;
                }
                catch (Exception exception) {}
                break;
            }
        }
        String driverList = success ? driverClassName : DriverManagerConnectionProviderImpl.driverList();
        Properties connectionProps = ConnectionProviderInitiator.getConnectionProperties(configurationValues);
        boolean autoCommit = ConfigurationHelper.getBoolean("hibernate.connection.autocommit", configurationValues);
        Integer isolation = ConnectionProviderInitiator.extractIsolation(configurationValues);
        String initSql = (String)configurationValues.get(INIT_SQL);
        ConnectionCreatorFactory factory = DriverManagerConnectionProviderImpl.getConnectionCreatorFactory(configurationValues, serviceRegistry);
        dbInfo = new DatabaseConnectionInfoImpl(DriverManagerConnectionProviderImpl.class, url, driverList, SimpleDatabaseVersion.ZERO_VERSION, Boolean.toString(autoCommit), isolation != null ? ConnectionProviderInitiator.toIsolationNiceName(isolation) : null, ConfigurationHelper.getInt(MIN_SIZE, configurationValues, 1), ConfigurationHelper.getInt("hibernate.connection.pool_size", configurationValues, 20));
        return factory.create(driver, serviceRegistry, url, connectionProps, autoCommit, isolation, initSql, configurationValues);
    }

    private static String driverList() {
        ConnectionInfoLogger.INSTANCE.jdbcDriverNotSpecified();
        StringBuilder list = new StringBuilder();
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            if (!list.isEmpty()) {
                list.append(", ");
            }
            list.append(drivers.nextElement().getClass().getName());
        }
        return list.toString();
    }

    private static String jdbcUrl(Map<String, Object> configurationValues) {
        String url = (String)configurationValues.get("hibernate.connection.url");
        if (url == null) {
            throw new ConnectionProviderConfigurationException("No JDBC URL specified by property 'jakarta.persistence.jdbc.url'");
        }
        return url;
    }

    private static ConnectionCreatorFactory getConnectionCreatorFactory(Map<String, Object> configurationValues, ServiceRegistryImplementor serviceRegistry) {
        ConnectionCreatorFactory instance;
        Object connectionCreatorFactory = configurationValues.get(CONNECTION_CREATOR_FACTORY);
        ConnectionCreatorFactory factory = connectionCreatorFactory instanceof ConnectionCreatorFactory ? (instance = (ConnectionCreatorFactory)connectionCreatorFactory) : (connectionCreatorFactory != null ? DriverManagerConnectionProviderImpl.loadConnectionCreatorFactory(connectionCreatorFactory.toString(), serviceRegistry) : null);
        return factory == null ? ConnectionCreatorFactoryImpl.INSTANCE : factory;
    }

    private static Driver loadDriverIfPossible(String driverClassName, ServiceRegistryImplementor serviceRegistry) {
        if (driverClassName == null) {
            ConnectionInfoLogger.INSTANCE.debug("No driver class specified");
            return null;
        }
        if (serviceRegistry != null) {
            Class driverClass = serviceRegistry.requireService(ClassLoaderService.class).classForName(driverClassName);
            try {
                return (Driver)driverClass.newInstance();
            }
            catch (Exception e) {
                throw new ServiceException("Specified JDBC Driver " + driverClassName + " could not be loaded", e);
            }
        }
        try {
            return (Driver)Class.forName(driverClassName).newInstance();
        }
        catch (Exception e1) {
            throw new ServiceException("Specified JDBC Driver " + driverClassName + " could not be loaded", e1);
        }
    }

    private static ConnectionCreatorFactory loadConnectionCreatorFactory(String connectionCreatorFactoryClassName, ServiceRegistryImplementor serviceRegistry) {
        if (connectionCreatorFactoryClassName == null) {
            ConnectionInfoLogger.INSTANCE.debug("No connection creator factory class specified");
            return null;
        }
        if (serviceRegistry != null) {
            Class factoryClass = serviceRegistry.requireService(ClassLoaderService.class).classForName(connectionCreatorFactoryClassName);
            try {
                return (ConnectionCreatorFactory)factoryClass.newInstance();
            }
            catch (Exception e) {
                throw new ServiceException("Specified ConnectionCreatorFactory " + connectionCreatorFactoryClassName + " could not be loaded", e);
            }
        }
        try {
            return (ConnectionCreatorFactory)Class.forName(connectionCreatorFactoryClassName).newInstance();
        }
        catch (Exception e1) {
            throw new ServiceException("Specified ConnectionCreatorFactory " + connectionCreatorFactoryClassName + " could not be loaded", e1);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.state == null) {
            throw new IllegalStateException("Cannot get a connection as the driver manager is not properly initialized");
        }
        return this.state.getConnection();
    }

    @Override
    public void closeConnection(Connection connection) throws SQLException {
        if (this.state == null) {
            throw new IllegalStateException("Cannot close a connection as the driver manager is not properly initialized");
        }
        this.state.closeConnection(connection);
    }

    @Override
    public boolean supportsAggressiveRelease() {
        return false;
    }

    @Override
    public DatabaseConnectionInfo getDatabaseConnectionInfo(Dialect dialect) {
        return new DatabaseConnectionInfoImpl(DriverManagerConnectionProviderImpl.class, dbInfo.getJdbcUrl(), dbInfo.getJdbcDriver(), dialect.getVersion(), dbInfo.getAutoCommitMode(), dbInfo.getIsolationLevel(), dbInfo.getPoolMinSize(), dbInfo.getPoolMaxSize());
    }

    @Override
    public boolean isUnwrappableAs(Class<?> unwrapType) {
        return ConnectionProvider.class.equals(unwrapType) || DriverManagerConnectionProviderImpl.class.isAssignableFrom(unwrapType);
    }

    @Override
    public <T> T unwrap(Class<T> unwrapType) {
        if (ConnectionProvider.class.equals(unwrapType) || DriverManagerConnectionProviderImpl.class.isAssignableFrom(unwrapType)) {
            return (T)this;
        }
        throw new UnknownUnwrapTypeException(unwrapType);
    }

    protected int getOpenConnections() {
        return this.state.pool.allConnections.size() - this.state.pool.availableConnections.size();
    }

    protected void validateConnectionsReturned() {
        int allocationCount = this.getOpenConnections();
        if (allocationCount != 0) {
            ConnectionInfoLogger.INSTANCE.error("Connection leak detected: there are " + allocationCount + " unclosed connections");
        }
    }

    protected void validateConnections(ConnectionValidator validator) {
        this.state.validateConnections(validator);
    }

    @Override
    public void stop() {
        if (this.state != null) {
            this.state.stop();
            this.validateConnectionsReturned();
        }
    }

    protected void finalize() throws Throwable {
        if (this.state != null) {
            this.state.stop();
        }
        super.finalize();
    }

    @Override
    public boolean isValid(Connection connection) throws SQLException {
        return true;
    }

    public static class PooledConnections {
        private final ConcurrentLinkedQueue<Connection> allConnections = new ConcurrentLinkedQueue();
        private final ConcurrentLinkedQueue<Connection> availableConnections = new ConcurrentLinkedQueue();
        private final ConnectionCreator connectionCreator;
        private final ConnectionValidator connectionValidator;
        private final boolean autoCommit;
        private final int minSize;
        private final int maxSize;
        private volatile boolean primed;

        private PooledConnections(Builder builder) {
            ConnectionInfoLogger.INSTANCE.debugf("Initializing Connection pool with %s Connections", builder.initialSize);
            this.connectionCreator = builder.connectionCreator;
            this.connectionValidator = builder.connectionValidator == null ? ConnectionValidator.ALWAYS_VALID : builder.connectionValidator;
            this.autoCommit = builder.autoCommit;
            this.maxSize = builder.maxSize;
            this.minSize = builder.minSize;
            this.addConnections(builder.initialSize);
        }

        private void validate() {
            int size = this.size();
            if (!this.primed && size >= this.minSize) {
                ConnectionInfoLogger.INSTANCE.debug("Connection pool now considered primed; min-size will be maintained");
                this.primed = true;
            }
            if (size < this.minSize && this.primed) {
                int numberToBeAdded = this.minSize - size;
                ConnectionInfoLogger.INSTANCE.debugf("Adding %s Connections to the pool", numberToBeAdded);
                this.addConnections(numberToBeAdded);
            } else if (size > this.maxSize) {
                int numberToBeRemoved = size - this.maxSize;
                ConnectionInfoLogger.INSTANCE.debugf("Removing %s Connections from the pool", numberToBeRemoved);
                this.removeConnections(numberToBeRemoved);
            }
        }

        private void add(Connection conn) {
            Connection connection = this.releaseConnection(conn);
            if (connection != null) {
                this.availableConnections.offer(connection);
            }
        }

        private Connection releaseConnection(Connection conn) {
            SQLException t = null;
            try {
                conn.setAutoCommit(true);
                conn.clearWarnings();
                if (this.connectionValidator.isValid(conn)) {
                    return conn;
                }
            }
            catch (SQLException ex) {
                t = ex;
            }
            this.closeConnection(conn, t);
            ConnectionInfoLogger.INSTANCE.debug("Connection release failed. Closing pooled connection", t);
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Connection poll() {
            Connection conn;
            do {
                if ((conn = this.availableConnections.poll()) != null) continue;
                ConcurrentLinkedQueue<Connection> concurrentLinkedQueue = this.allConnections;
                synchronized (concurrentLinkedQueue) {
                    if (this.allConnections.size() < this.maxSize) {
                        this.addConnections(1);
                        return this.poll();
                    }
                }
                throw new HibernateException("The internal connection pool has reached its maximum size and no connection is currently available");
            } while ((conn = this.prepareConnection(conn)) == null);
            return conn;
        }

        protected Connection prepareConnection(Connection conn) {
            SQLException t = null;
            try {
                conn.setAutoCommit(this.autoCommit);
                if (this.connectionValidator.isValid(conn)) {
                    return conn;
                }
            }
            catch (SQLException ex) {
                t = ex;
            }
            this.closeConnection(conn, t);
            ConnectionInfoLogger.INSTANCE.debug("Connection preparation failed. Closing pooled connection", t);
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void closeConnection(Connection conn, Throwable t) {
            try {
                conn.close();
            }
            catch (SQLException ex) {
                ConnectionInfoLogger.INSTANCE.unableToClosePooledConnection(ex);
                if (t != null) {
                    t.addSuppressed(ex);
                }
            }
            finally {
                this.allConnections.remove(conn);
            }
        }

        public void close() throws SQLException {
            try {
                int allocationCount = this.allConnections.size() - this.availableConnections.size();
                if (allocationCount > 0) {
                    ConnectionInfoLogger.INSTANCE.error("Connection leak detected: there are " + allocationCount + " unclosed connections upon shutting down pool " + this.getUrl());
                }
            }
            finally {
                this.removeConnections(Integer.MAX_VALUE);
            }
        }

        public int size() {
            return this.allConnections.size();
        }

        protected void removeConnections(int numberToBeRemoved) {
            Connection connection;
            for (int i = 0; i < numberToBeRemoved && (connection = this.availableConnections.poll()) != null; ++i) {
                this.closeConnection(connection, null);
            }
        }

        protected void addConnections(int numberOfConnections) {
            for (int i = 0; i < numberOfConnections; ++i) {
                Connection connection = this.connectionCreator.createConnection();
                this.allConnections.add(connection);
                this.availableConnections.add(connection);
            }
        }

        public String getUrl() {
            return this.connectionCreator.getUrl();
        }

        private static class Builder {
            private final ConnectionCreator connectionCreator;
            private ConnectionValidator connectionValidator;
            private final boolean autoCommit;
            private int initialSize = 1;
            private int minSize = 1;
            private int maxSize = 20;

            private Builder(ConnectionCreator connectionCreator, boolean autoCommit) {
                this.connectionCreator = connectionCreator;
                this.autoCommit = autoCommit;
            }

            private Builder initialSize(int initialSize) {
                this.initialSize = initialSize;
                return this;
            }

            private Builder minSize(int minSize) {
                this.minSize = minSize;
                return this;
            }

            private Builder maxSize(int maxSize) {
                this.maxSize = maxSize;
                return this;
            }

            private Builder validator(ConnectionValidator connectionValidator) {
                this.connectionValidator = connectionValidator;
                return this;
            }

            private PooledConnections build() {
                return new PooledConnections(this);
            }
        }
    }

    private static class PoolState
    implements Runnable {
        private final ReadWriteLock statelock = new ReentrantReadWriteLock();
        private volatile boolean active = false;
        private ScheduledExecutorService executorService;
        private final PooledConnections pool;
        private final long validationInterval;

        private PoolState(PooledConnections pool, long validationInterval) {
            this.pool = pool;
            this.validationInterval = validationInterval;
        }

        private void startIfNeeded() {
            if (this.active) {
                return;
            }
            this.statelock.writeLock().lock();
            try {
                if (this.active) {
                    return;
                }
                this.executorService = Executors.newSingleThreadScheduledExecutor(new ValidationThreadFactory());
                this.executorService.scheduleWithFixedDelay(this, this.validationInterval, this.validationInterval, TimeUnit.SECONDS);
                this.active = true;
            }
            finally {
                this.statelock.writeLock().unlock();
            }
        }

        @Override
        public void run() {
            if (this.active) {
                this.pool.validate();
            }
        }

        private void stop() {
            this.statelock.writeLock().lock();
            try {
                if (!this.active) {
                    return;
                }
                ConnectionInfoLogger.INSTANCE.cleaningUpConnectionPool(this.pool.getUrl());
                this.active = false;
                if (this.executorService != null) {
                    this.executorService.shutdown();
                }
                this.executorService = null;
                try {
                    this.pool.close();
                }
                catch (SQLException e) {
                    ConnectionInfoLogger.INSTANCE.unableToDestroyConnectionPool(e);
                }
            }
            finally {
                this.statelock.writeLock().unlock();
            }
        }

        private Connection getConnection() {
            this.startIfNeeded();
            this.statelock.readLock().lock();
            try {
                Connection connection = this.pool.poll();
                return connection;
            }
            finally {
                this.statelock.readLock().unlock();
            }
        }

        private void closeConnection(Connection conn) {
            if (conn == null) {
                return;
            }
            this.startIfNeeded();
            this.statelock.readLock().lock();
            try {
                this.pool.add(conn);
            }
            finally {
                this.statelock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void validateConnections(ConnectionValidator validator) {
            if (!this.active) {
                return;
            }
            this.statelock.writeLock().lock();
            try {
                RuntimeException ex = null;
                for (Connection connection : this.pool.allConnections) {
                    SQLException e = null;
                    boolean isValid = false;
                    try {
                        isValid = validator.isValid(connection);
                    }
                    catch (SQLException sqlException) {
                        e = sqlException;
                    }
                    if (isValid) continue;
                    this.pool.closeConnection(connection, e);
                    if (ex == null) {
                        ex = new RuntimeException(e);
                        continue;
                    }
                    if (e == null) continue;
                    ex.addSuppressed(e);
                }
                if (ex != null) {
                    throw ex;
                }
            }
            finally {
                this.statelock.writeLock().unlock();
            }
        }
    }

    private static class ValidationThreadFactory
    implements ThreadFactory {
        private ValidationThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            thread.setName("Hibernate Connection Pool Validation Thread");
            return thread;
        }
    }
}

