/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.profile;

import java.util.Map;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.profile.Association;
import org.hibernate.engine.profile.Fetch;
import org.hibernate.engine.profile.FetchProfile;
import org.hibernate.metamodel.MappingMetamodel;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.AttributeMappingsList;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.sql.results.graph.FetchOptions;

public class DefaultFetchProfile
extends FetchProfile {
    public static final @UnknownKeyFor @NonNull @Initialized String HIBERNATE_DEFAULT_PROFILE = "org.hibernate.defaultProfile";
    private final @UnknownKeyFor @NonNull @Initialized MappingMetamodel metamodels;

    public DefaultFetchProfile(@UnknownKeyFor @NonNull @Initialized MappingMetamodel metamodels) {
        super(HIBERNATE_DEFAULT_PROFILE);
        this.metamodels = metamodels;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Fetch getFetchByRole(@UnknownKeyFor @NonNull @Initialized String role) {
        FetchOptions fetchOptions;
        AttributeMapping attributeMapping;
        int last = role.lastIndexOf(46);
        String entityName = role.substring(0, last);
        String property = role.substring(last + 1);
        EntityPersister entity = this.metamodels.getEntityDescriptor(entityName);
        if (entity != null && (attributeMapping = entity.findAttributeMapping(property)) != null && !attributeMapping.isPluralAttributeMapping() && (fetchOptions = attributeMapping.getMappedFetchOptions()).getStyle() == FetchStyle.JOIN && fetchOptions.getTiming() == FetchTiming.IMMEDIATE) {
            return new Fetch(new Association(entity.getEntityPersister(), role), FetchStyle.JOIN, FetchTiming.IMMEDIATE);
        }
        return super.getFetchByRole(role);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean hasSubselectLoadableCollectionsEnabled(@UnknownKeyFor @NonNull @Initialized EntityPersister persister) {
        AttributeMappingsList attributeMappings = persister.getAttributeMappings();
        for (int i = 0; i < attributeMappings.size(); ++i) {
            AttributeMapping attributeMapping = attributeMappings.get(i);
            if (attributeMapping.getMappedFetchOptions().getStyle() != FetchStyle.SUBSELECT) continue;
            return true;
        }
        return false;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Fetch> getFetches() {
        throw new UnsupportedOperationException("DefaultFetchProfile has implicit fetches");
    }
}

