/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.sql.Connection;
import java.util.TimeZone;
import java.util.function.UnaryOperator;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.ConnectionAcquisitionMode;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.FlushMode;
import org.hibernate.Interceptor;
import org.hibernate.Session;
import org.hibernate.SessionBuilder;
import org.hibernate.SessionEventListener;
import org.hibernate.resource.jdbc.spi.PhysicalConnectionHandlingMode;
import org.hibernate.resource.jdbc.spi.StatementInspector;

public abstract class AbstractDelegatingSessionBuilder
implements SessionBuilder {
    private final @UnknownKeyFor @NonNull @Initialized SessionBuilder delegate;

    public AbstractDelegatingSessionBuilder(@UnknownKeyFor @NonNull @Initialized SessionBuilder delegate) {
        this.delegate = delegate;
    }

    protected @UnknownKeyFor @NonNull @Initialized SessionBuilder getThis() {
        return this;
    }

    protected @UnknownKeyFor @NonNull @Initialized SessionBuilder delegate() {
        return this.delegate;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Session openSession() {
        return this.delegate.openSession();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized SessionBuilder interceptor(@UnknownKeyFor @NonNull @Initialized Interceptor interceptor) {
        this.delegate.interceptor(interceptor);
        return this;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized SessionBuilder noInterceptor() {
        this.delegate.noInterceptor();
        return this;
    }

    @Override
    @Deprecated
    public @UnknownKeyFor @NonNull @Initialized SessionBuilder statementInspector(@UnknownKeyFor @NonNull @Initialized StatementInspector statementInspector) {
        this.delegate.statementInspector(statementInspector);
        return this;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized SessionBuilder statementInspector(@UnknownKeyFor @NonNull @Initialized UnaryOperator<@UnknownKeyFor @NonNull @Initialized String> operator) {
        this.delegate.statementInspector(operator);
        return this;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized SessionBuilder connection(@UnknownKeyFor @NonNull @Initialized Connection connection) {
        this.delegate.connection(connection);
        return this;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized SessionBuilder autoJoinTransactions(@UnknownKeyFor @NonNull @Initialized boolean autoJoinTransactions) {
        this.delegate.autoJoinTransactions(autoJoinTransactions);
        return this;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized SessionBuilder autoClose(@UnknownKeyFor @NonNull @Initialized boolean autoClose) {
        this.delegate.autoClose(autoClose);
        return this;
    }

    @Override
    @Deprecated(forRemoval=true)
    public @UnknownKeyFor @NonNull @Initialized SessionBuilder tenantIdentifier(@UnknownKeyFor @NonNull @Initialized String tenantIdentifier) {
        this.delegate.tenantIdentifier(tenantIdentifier);
        return this;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized SessionBuilder tenantIdentifier(@UnknownKeyFor @NonNull @Initialized Object tenantIdentifier) {
        this.delegate.tenantIdentifier(tenantIdentifier);
        return this;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized SessionBuilder eventListeners(SessionEventListener ... listeners) {
        this.delegate.eventListeners(listeners);
        return this;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized SessionBuilder clearEventListeners() {
        this.delegate.clearEventListeners();
        return this;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized SessionBuilder jdbcTimeZone(@UnknownKeyFor @NonNull @Initialized TimeZone timeZone) {
        this.delegate.jdbcTimeZone(timeZone);
        return this;
    }

    @Override
    @Deprecated
    public @UnknownKeyFor @NonNull @Initialized SessionBuilder connectionHandlingMode(@UnknownKeyFor @NonNull @Initialized PhysicalConnectionHandlingMode mode) {
        this.delegate.connectionHandlingMode(mode);
        return this;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized SessionBuilder connectionHandling(@UnknownKeyFor @NonNull @Initialized ConnectionAcquisitionMode acquisitionMode, @UnknownKeyFor @NonNull @Initialized ConnectionReleaseMode releaseMode) {
        this.delegate.connectionHandling(acquisitionMode, releaseMode);
        return this;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized SessionBuilder autoClear(@UnknownKeyFor @NonNull @Initialized boolean autoClear) {
        this.delegate.autoClear(autoClear);
        return this;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized SessionBuilder flushMode(@UnknownKeyFor @NonNull @Initialized FlushMode flushMode) {
        this.delegate.flushMode(flushMode);
        return this;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized SessionBuilder identifierRollback(@UnknownKeyFor @NonNull @Initialized boolean identifierRollback) {
        this.delegate.identifierRollback(identifierRollback);
        return this;
    }
}

