/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.hibernate.AssertionFailure;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.Type;

public final class CollectionKey
implements Serializable {
    private final @UnknownKeyFor @NonNull @Initialized String role;
    private final @UnknownKeyFor @NonNull @Initialized Object key;
    private final @Nullable @UnknownKeyFor @Initialized Type keyType;
    private final @UnknownKeyFor @NonNull @Initialized SessionFactoryImplementor factory;
    private final @UnknownKeyFor @NonNull @Initialized int hashCode;

    public CollectionKey(@UnknownKeyFor @NonNull @Initialized CollectionPersister persister, @UnknownKeyFor @NonNull @Initialized Object key) {
        this(persister.getRole(), key, persister.getKeyType().getTypeForEqualsHashCode(), persister.getFactory());
    }

    private CollectionKey(@UnknownKeyFor @NonNull @Initialized String role, @Nullable @UnknownKeyFor @Initialized Object key, @Nullable @UnknownKeyFor @Initialized Type keyType, @UnknownKeyFor @NonNull @Initialized SessionFactoryImplementor factory) {
        this.role = role;
        if (key == null) {
            throw new AssertionFailure("null identifier for collection of role (" + role + ")");
        }
        this.key = key;
        this.keyType = keyType;
        this.factory = factory;
        this.hashCode = this.generateHashCode();
    }

    private @UnknownKeyFor @NonNull @Initialized int generateHashCode() {
        int result = 17;
        result = 37 * result + this.role.hashCode();
        result = 37 * result + (this.keyType == null ? this.key.hashCode() : this.keyType.getHashCode(this.key, this.factory));
        return result;
    }

    public @UnknownKeyFor @NonNull @Initialized String getRole() {
        return this.role;
    }

    public @UnknownKeyFor @NonNull @Initialized Object getKey() {
        return this.key;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        CollectionPersister collectionDescriptor = this.factory.getMappingMetamodel().getCollectionDescriptor(this.role);
        return "CollectionKey" + MessageHelper.collectionInfoString(collectionDescriptor, this.key, this.factory);
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || CollectionKey.class != other.getClass()) {
            return false;
        }
        CollectionKey that = (CollectionKey)other;
        return that.role.equals(this.role) && (this.key == that.key || this.keyType == null ? this.key.equals(that.key) : this.keyType.isEqual(this.key, that.key, this.factory));
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return this.hashCode;
    }

    public void serialize(@UnknownKeyFor @NonNull @Initialized ObjectOutputStream oos) throws @UnknownKeyFor @NonNull @Initialized IOException {
        oos.writeObject(this.role);
        oos.writeObject(this.key);
        oos.writeObject(this.keyType);
    }

    public static @UnknownKeyFor @NonNull @Initialized CollectionKey deserialize(@UnknownKeyFor @NonNull @Initialized ObjectInputStream ois, @UnknownKeyFor @NonNull @Initialized SessionImplementor session) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized ClassNotFoundException {
        return new CollectionKey((String)ois.readObject(), ois.readObject(), (Type)ois.readObject(), (SessionFactoryImplementor)session.getFactory());
    }
}

