/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Supplier;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.Filter;
import org.hibernate.Internal;
import org.hibernate.UnknownProfileException;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.profile.Fetch;
import org.hibernate.engine.profile.FetchProfile;
import org.hibernate.engine.spi.EffectiveEntityGraph;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.internal.FilterImpl;
import org.hibernate.internal.SessionCreationOptions;
import org.hibernate.loader.ast.spi.CascadingFetchProfile;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;

public class LoadQueryInfluencers
implements Serializable {
    private final @UnknownKeyFor @NonNull @Initialized SessionFactoryImplementor sessionFactory;
    private @UnknownKeyFor @NonNull @Initialized CascadingFetchProfile enabledCascadingFetchProfile;
    private @Nullable @UnknownKeyFor @Initialized HashSet<@UnknownKeyFor @NonNull @Initialized String> enabledFetchProfileNames;
    private @Nullable @UnknownKeyFor @Initialized TreeMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Filter> enabledFilters;
    private @UnknownKeyFor @NonNull @Initialized boolean subselectFetchEnabled;
    private @UnknownKeyFor @NonNull @Initialized int batchSize = -1;
    private final @UnknownKeyFor @NonNull @Initialized EffectiveEntityGraph effectiveEntityGraph;
    private @UnknownKeyFor @NonNull @Initialized Boolean readOnly;

    public LoadQueryInfluencers(@UnknownKeyFor @NonNull @Initialized SessionFactoryImplementor sessionFactory) {
        this.sessionFactory = sessionFactory;
        this.batchSize = sessionFactory.getSessionFactoryOptions().getDefaultBatchFetchSize();
        this.subselectFetchEnabled = sessionFactory.getSessionFactoryOptions().isSubselectFetchEnabled();
        this.effectiveEntityGraph = new EffectiveEntityGraph();
    }

    public LoadQueryInfluencers(@UnknownKeyFor @NonNull @Initialized SessionFactoryImplementor sessionFactory, @UnknownKeyFor @NonNull @Initialized SessionCreationOptions options) {
        this.sessionFactory = sessionFactory;
        this.batchSize = options.getDefaultBatchFetchSize();
        this.subselectFetchEnabled = options.isSubselectFetchEnabled();
        this.effectiveEntityGraph = new EffectiveEntityGraph();
        for (FilterDefinition filterDefinition : sessionFactory.getAutoEnabledFilters()) {
            FilterImpl filter = new FilterImpl(filterDefinition);
            if (this.enabledFilters == null) {
                this.enabledFilters = new TreeMap();
            }
            this.enabledFilters.put(filterDefinition.getFilterName(), filter);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized EffectiveEntityGraph applyEntityGraph(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized RootGraphImplementor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> rootGraph, @Nullable @UnknownKeyFor @Initialized GraphSemantic graphSemantic) {
        EffectiveEntityGraph effectiveEntityGraph = this.getEffectiveEntityGraph();
        if (graphSemantic != null) {
            if (rootGraph == null) {
                throw new IllegalArgumentException("Graph semantic specified, but no RootGraph was supplied");
            }
            effectiveEntityGraph.applyGraph(rootGraph, graphSemantic);
        }
        return effectiveEntityGraph;
    }

    public @UnknownKeyFor @NonNull @Initialized SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T fromInternalFetchProfile(@UnknownKeyFor @NonNull @Initialized CascadingFetchProfile profile, @UnknownKeyFor @NonNull @Initialized Supplier<T> supplier) {
        CascadingFetchProfile previous = this.enabledCascadingFetchProfile;
        this.enabledCascadingFetchProfile = profile;
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            this.enabledCascadingFetchProfile = previous;
        }
    }

    public @UnknownKeyFor @NonNull @Initialized CascadingFetchProfile getEnabledCascadingFetchProfile() {
        return this.enabledCascadingFetchProfile;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean hasEnabledCascadingFetchProfile() {
        return this.enabledCascadingFetchProfile != null;
    }

    public void setEnabledCascadingFetchProfile(@UnknownKeyFor @NonNull @Initialized CascadingFetchProfile enabledCascadingFetchProfile) {
        this.enabledCascadingFetchProfile = enabledCascadingFetchProfile;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean hasEnabledFilters() {
        return this.enabledFilters != null && !this.enabledFilters.isEmpty();
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Filter> getEnabledFilters() {
        TreeMap<String, Filter> enabledFilters = this.enabledFilters;
        if (enabledFilters == null) {
            return Collections.emptyMap();
        }
        for (Filter filter : enabledFilters.values()) {
            filter.validate();
        }
        return enabledFilters;
    }

    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getEnabledFilterNames() {
        return this.enabledFilters == null ? Collections.emptySet() : Collections.unmodifiableSet(this.enabledFilters.keySet());
    }

    public @Nullable @UnknownKeyFor @Initialized Filter getEnabledFilter(@UnknownKeyFor @NonNull @Initialized String filterName) {
        return this.enabledFilters == null ? null : this.enabledFilters.get(filterName);
    }

    public @UnknownKeyFor @NonNull @Initialized Filter enableFilter(@UnknownKeyFor @NonNull @Initialized String filterName) {
        FilterImpl filter = new FilterImpl(this.sessionFactory.getFilterDefinition(filterName));
        if (this.enabledFilters == null) {
            this.enabledFilters = new TreeMap();
        }
        this.enabledFilters.put(filterName, filter);
        return filter;
    }

    public void disableFilter(@UnknownKeyFor @NonNull @Initialized String filterName) {
        if (this.enabledFilters != null) {
            this.enabledFilters.remove(filterName);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized Object getFilterParameterValue(@UnknownKeyFor @NonNull @Initialized String filterParameterName) {
        String[] parsed = LoadQueryInfluencers.parseFilterParameterName(filterParameterName);
        if (this.enabledFilters == null) {
            throw new IllegalArgumentException("Filter [" + parsed[0] + "] currently not enabled");
        }
        FilterImpl filter = (FilterImpl)this.enabledFilters.get(parsed[0]);
        if (filter == null) {
            throw new IllegalArgumentException("Filter [" + parsed[0] + "] currently not enabled");
        }
        return filter.getParameter(parsed[1]);
    }

    public static @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] parseFilterParameterName(@UnknownKeyFor @NonNull @Initialized String filterParameterName) {
        int dot = filterParameterName.lastIndexOf(46);
        if (dot <= 0) {
            throw new IllegalArgumentException("Invalid filter-parameter name format [" + filterParameterName + "]; expecting {filter-name}.{param-name}");
        }
        String filterName = filterParameterName.substring(0, dot);
        String parameterName = filterParameterName.substring(dot + 1);
        return new String[]{filterName, parameterName};
    }

    public @UnknownKeyFor @NonNull @Initialized boolean hasEnabledFetchProfiles() {
        return this.enabledFetchProfileNames != null && !this.enabledFetchProfileNames.isEmpty();
    }

    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getEnabledFetchProfileNames() {
        return this.enabledFetchProfileNames == null ? Collections.emptySet() : this.enabledFetchProfileNames;
    }

    private void checkFetchProfileName(@UnknownKeyFor @NonNull @Initialized String name) {
        if (!this.sessionFactory.containsFetchProfileDefinition(name)) {
            throw new UnknownProfileException(name);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isFetchProfileEnabled(@UnknownKeyFor @NonNull @Initialized String name) throws @UnknownKeyFor @NonNull @Initialized UnknownProfileException {
        this.checkFetchProfileName(name);
        return this.enabledFetchProfileNames != null && this.enabledFetchProfileNames.contains(name);
    }

    public void enableFetchProfile(@UnknownKeyFor @NonNull @Initialized String name) throws @UnknownKeyFor @NonNull @Initialized UnknownProfileException {
        this.checkFetchProfileName(name);
        if (this.enabledFetchProfileNames == null) {
            this.enabledFetchProfileNames = new HashSet();
        }
        this.enabledFetchProfileNames.add(name);
    }

    public void disableFetchProfile(@UnknownKeyFor @NonNull @Initialized String name) throws @UnknownKeyFor @NonNull @Initialized UnknownProfileException {
        this.checkFetchProfileName(name);
        if (this.enabledFetchProfileNames != null) {
            this.enabledFetchProfileNames.remove(name);
        }
    }

    @Internal
    public @Nullable @UnknownKeyFor @Initialized HashSet<@UnknownKeyFor @NonNull @Initialized String> adjustFetchProfiles(@Nullable @UnknownKeyFor @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> disabledFetchProfiles, @Nullable @UnknownKeyFor @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> enabledFetchProfiles) {
        HashSet<String> currentEnabledFetchProfileNames = this.enabledFetchProfileNames;
        HashSet<String> oldFetchProfiles = currentEnabledFetchProfileNames == null || currentEnabledFetchProfileNames.isEmpty() ? null : new HashSet<String>(currentEnabledFetchProfileNames);
        if (disabledFetchProfiles != null && this.enabledFetchProfileNames != null) {
            this.enabledFetchProfileNames.removeAll(disabledFetchProfiles);
        }
        if (enabledFetchProfiles != null) {
            if (this.enabledFetchProfileNames == null) {
                this.enabledFetchProfileNames = new HashSet();
            }
            this.enabledFetchProfileNames.addAll(enabledFetchProfiles);
        }
        return oldFetchProfiles;
    }

    @Internal
    public void setEnabledFetchProfileNames(@UnknownKeyFor @NonNull @Initialized HashSet<@UnknownKeyFor @NonNull @Initialized String> enabledFetchProfileNames) {
        this.enabledFetchProfileNames = enabledFetchProfileNames;
    }

    public @UnknownKeyFor @NonNull @Initialized EffectiveEntityGraph getEffectiveEntityGraph() {
        return this.effectiveEntityGraph;
    }

    public @UnknownKeyFor @NonNull @Initialized Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(@UnknownKeyFor @NonNull @Initialized Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public @UnknownKeyFor @NonNull @Initialized int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(@UnknownKeyFor @NonNull @Initialized int batchSize) {
        this.batchSize = batchSize;
    }

    public @UnknownKeyFor @NonNull @Initialized int effectiveBatchSize(@UnknownKeyFor @NonNull @Initialized CollectionPersister persister) {
        int persisterBatchSize = persister.getBatchSize();
        return persisterBatchSize >= 0 ? persisterBatchSize : this.batchSize;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean effectivelyBatchLoadable(@UnknownKeyFor @NonNull @Initialized CollectionPersister persister) {
        return persister.isBatchLoadable() || this.effectiveBatchSize(persister) > 1;
    }

    public @UnknownKeyFor @NonNull @Initialized int effectiveBatchSize(@UnknownKeyFor @NonNull @Initialized EntityPersister persister) {
        int persisterBatchSize = persister.getBatchSize();
        return persisterBatchSize >= 0 ? persisterBatchSize : this.batchSize;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean effectivelyBatchLoadable(@UnknownKeyFor @NonNull @Initialized EntityPersister persister) {
        return persister.isBatchLoadable() || this.effectiveBatchSize(persister) > 1;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean getSubselectFetchEnabled() {
        return this.subselectFetchEnabled;
    }

    public void setSubselectFetchEnabled(@UnknownKeyFor @NonNull @Initialized boolean subselectFetchEnabled) {
        this.subselectFetchEnabled = subselectFetchEnabled;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean effectiveSubselectFetchEnabled(@UnknownKeyFor @NonNull @Initialized CollectionPersister persister) {
        return this.subselectFetchEnabled || persister.isSubselectLoadable() || this.isSubselectFetchEnabledInProfile(persister);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isSubselectFetchEnabledInProfile(@UnknownKeyFor @NonNull @Initialized CollectionPersister persister) {
        if (this.hasEnabledFetchProfiles()) {
            for (String profile : this.getEnabledFetchProfileNames()) {
                Fetch fetch;
                FetchProfile fetchProfile = persister.getFactory().getSqlTranslationEngine().getFetchProfile(profile);
                if (fetchProfile == null || (fetch = fetchProfile.getFetchByRole(persister.getRole())) == null || fetch.getMethod() != FetchStyle.SUBSELECT) continue;
                return true;
            }
        }
        return false;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean hasSubselectLoadableCollections(@UnknownKeyFor @NonNull @Initialized EntityPersister persister) {
        return persister.hasSubselectLoadableCollections() || this.subselectFetchEnabled && persister.hasCollections() || this.hasSubselectLoadableCollectionsEnabledInProfile(persister);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean hasSubselectLoadableCollectionsEnabledInProfile(@UnknownKeyFor @NonNull @Initialized EntityPersister persister) {
        if (this.hasEnabledFetchProfiles()) {
            for (String profile : this.getEnabledFetchProfileNames()) {
                if (!persister.getFactory().getSqlTranslationEngine().getFetchProfile(profile).hasSubselectLoadableCollectionsEnabled(persister)) continue;
                return true;
            }
        }
        return false;
    }
}

