/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.util.Collection;
import java.util.Map;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.CustomEntityDirtinessStrategy;
import org.hibernate.Incubating;
import org.hibernate.Internal;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.spi.CacheImplementor;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.profile.FetchProfile;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.engine.spi.SessionBuilderImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.service.spi.EventListenerGroups;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EntityCopyObserverFactory;
import org.hibernate.event.spi.EventEngine;
import org.hibernate.generator.Generator;
import org.hibernate.graph.RootGraph;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.metamodel.model.domain.JpaMetamodel;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.metamodel.spi.RuntimeMetamodelsImplementor;
import org.hibernate.proxy.EntityNotFoundDelegate;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sql.spi.SqlTranslationEngine;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.sql.ast.spi.ParameterMarkerStrategy;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMappingProducerProvider;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.spi.TypeConfiguration;

public interface SessionFactoryImplementor
extends SessionFactory {
    public @UnknownKeyFor @NonNull @Initialized String getUuid();

    @Override
    public @UnknownKeyFor @NonNull @Initialized SessionImplementor openSession();

    @Override
    public @UnknownKeyFor @NonNull @Initialized SessionBuilderImplementor withOptions();

    public @UnknownKeyFor @NonNull @Initialized SessionImplementor openTemporarySession();

    @Override
    public @UnknownKeyFor @NonNull @Initialized CacheImplementor getCache();

    @Override
    public @UnknownKeyFor @NonNull @Initialized StatisticsImplementor getStatistics();

    public @UnknownKeyFor @NonNull @Initialized TypeConfiguration getTypeConfiguration();

    public @UnknownKeyFor @NonNull @Initialized RuntimeMetamodelsImplementor getRuntimeMetamodels();

    default public @UnknownKeyFor @NonNull @Initialized MappingMetamodelImplementor getMappingMetamodel() {
        return this.getRuntimeMetamodels().getMappingMetamodel();
    }

    default public @UnknownKeyFor @NonNull @Initialized JpaMetamodel getJpaMetamodel() {
        return this.getRuntimeMetamodels().getJpaMetamodel();
    }

    public @UnknownKeyFor @NonNull @Initialized QueryEngine getQueryEngine();

    public @UnknownKeyFor @NonNull @Initialized SqlTranslationEngine getSqlTranslationEngine();

    public @UnknownKeyFor @NonNull @Initialized ServiceRegistryImplementor getServiceRegistry();

    public @UnknownKeyFor @NonNull @Initialized EventEngine getEventEngine();

    @Deprecated(since="7.0", forRemoval=true)
    public @UnknownKeyFor @NonNull @Initialized FetchProfile getFetchProfile(@UnknownKeyFor @NonNull @Initialized String var1);

    @Deprecated(since="7", forRemoval=true)
    public @UnknownKeyFor @NonNull @Initialized Generator getGenerator(@UnknownKeyFor @NonNull @Initialized String var1);

    public @UnknownKeyFor @NonNull @Initialized EntityNotFoundDelegate getEntityNotFoundDelegate();

    public void addObserver(@UnknownKeyFor @NonNull @Initialized SessionFactoryObserver var1);

    public @UnknownKeyFor @NonNull @Initialized CustomEntityDirtinessStrategy getCustomEntityDirtinessStrategy();

    public @UnknownKeyFor @NonNull @Initialized CurrentTenantIdentifierResolver<@UnknownKeyFor @NonNull @Initialized Object> getCurrentTenantIdentifierResolver();

    public @UnknownKeyFor @NonNull @Initialized JavaType<@UnknownKeyFor @NonNull @Initialized Object> getTenantIdentifierJavaType();

    @Internal
    @Incubating
    public @UnknownKeyFor @NonNull @Initialized EventListenerGroups getEventListenerGroups();

    @Incubating
    public @UnknownKeyFor @NonNull @Initialized ParameterMarkerStrategy getParameterMarkerStrategy();

    @Incubating
    public @UnknownKeyFor @NonNull @Initialized JdbcValuesMappingProducerProvider getJdbcValuesMappingProducerProvider();

    @Incubating
    public @UnknownKeyFor @NonNull @Initialized EntityCopyObserverFactory getEntityCopyObserver();

    @Incubating
    public @UnknownKeyFor @NonNull @Initialized ClassLoaderService getClassLoaderService();

    @Incubating
    public @UnknownKeyFor @NonNull @Initialized ManagedBeanRegistry getManagedBeanRegistry();

    @Incubating
    public @UnknownKeyFor @NonNull @Initialized EventListenerRegistry getEventListenerRegistry();

    public @UnknownKeyFor @NonNull @Initialized WrapperOptions getWrapperOptions();

    @Override
    public @UnknownKeyFor @NonNull @Initialized SessionFactoryOptions getSessionFactoryOptions();

    @Override
    public @UnknownKeyFor @NonNull @Initialized FilterDefinition getFilterDefinition(@UnknownKeyFor @NonNull @Initialized String var1);

    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized FilterDefinition> getAutoEnabledFilters();

    public @UnknownKeyFor @NonNull @Initialized JdbcServices getJdbcServices();

    public @UnknownKeyFor @NonNull @Initialized SqlStringGenerationContext getSqlStringGenerationContext();

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized RootGraphImplementor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> findEntityGraphByName(@UnknownKeyFor @NonNull @Initialized String var1);

    default public <T> @UnknownKeyFor @NonNull @Initialized RootGraphImplementor<T> createEntityGraph(@UnknownKeyFor @NonNull @Initialized Class<T> entityType) {
        return (RootGraphImplementor)SessionFactory.super.createEntityGraph(entityType);
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized RootGraph<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?>> createGraphForDynamicEntity(@UnknownKeyFor @NonNull @Initialized String var1);

    public @UnknownKeyFor @NonNull @Initialized String bestGuessEntityName(@UnknownKeyFor @NonNull @Initialized Object var1);
}

