/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import jakarta.persistence.TransactionRequiredException;
import java.util.Set;
import java.util.UUID;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Incubating;
import org.hibernate.Interceptor;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.SharedSessionContract;
import org.hibernate.StatelessSession;
import org.hibernate.Transaction;
import org.hibernate.action.spi.AfterTransactionCompletionProcess;
import org.hibernate.cache.spi.CacheTransactionSynchronization;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.LobCreationContext;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.ExceptionConverter;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.spi.QueryProducerImplementor;
import org.hibernate.resource.jdbc.spi.JdbcSessionOwner;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorBuilder;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.spi.TypeConfiguration;

public interface SharedSessionContractImplementor
extends SharedSessionContract,
JdbcSessionOwner,
TransactionCoordinatorBuilder.Options,
LobCreationContext,
WrapperOptions,
QueryProducerImplementor,
JavaType.CoercionContext {
    @Override
    public @UnknownKeyFor @NonNull @Initialized SessionFactoryImplementor getFactory();

    @Override
    default public @UnknownKeyFor @NonNull @Initialized SessionFactoryImplementor getSessionFactory() {
        return this.getFactory();
    }

    @Override
    default public @UnknownKeyFor @NonNull @Initialized TypeConfiguration getTypeConfiguration() {
        return this.getFactory().getTypeConfiguration();
    }

    @Override
    default public @UnknownKeyFor @NonNull @Initialized Dialect getDialect() {
        return this.getSessionFactory().getJdbcServices().getDialect();
    }

    public @UnknownKeyFor @NonNull @Initialized SessionEventListenerManager getEventListenerManager();

    public @UnknownKeyFor @NonNull @Initialized PersistenceContext getPersistenceContext();

    public @UnknownKeyFor @NonNull @Initialized JdbcCoordinator getJdbcCoordinator();

    public @UnknownKeyFor @NonNull @Initialized JdbcServices getJdbcServices();

    public @UnknownKeyFor @NonNull @Initialized UUID getSessionIdentifier();

    @Override
    default public @UnknownKeyFor @NonNull @Initialized SharedSessionContractImplementor getSession() {
        return this;
    }

    default public @UnknownKeyFor @NonNull @Initialized Object getSessionToken() {
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isClosed();

    default public @UnknownKeyFor @NonNull @Initialized boolean isOpenOrWaitingForAutoClose() {
        return !this.isClosed();
    }

    default public void checkOpen() {
        this.checkOpen(true);
    }

    public void checkOpen(@UnknownKeyFor @NonNull @Initialized boolean var1);

    public void prepareForQueryExecution(@UnknownKeyFor @NonNull @Initialized boolean var1);

    public void markForRollbackOnly();

    public @UnknownKeyFor @NonNull @Initialized CacheTransactionSynchronization getCacheTransactionSynchronization();

    public @UnknownKeyFor @NonNull @Initialized boolean isTransactionInProgress();

    default public void checkTransactionNeededForUpdateOperation(@UnknownKeyFor @NonNull @Initialized String exceptionMessage) {
        if (!this.isTransactionInProgress()) {
            throw new TransactionRequiredException(exceptionMessage);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized Transaction accessTransaction();

    public @UnknownKeyFor @NonNull @Initialized EntityKey generateEntityKey(@UnknownKeyFor @NonNull @Initialized Object var1, @UnknownKeyFor @NonNull @Initialized EntityPersister var2);

    public @UnknownKeyFor @NonNull @Initialized Interceptor getInterceptor();

    public void initializeCollection(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PersistentCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> var1, @UnknownKeyFor @NonNull @Initialized boolean var2) throws @UnknownKeyFor @NonNull @Initialized HibernateException;

    public @UnknownKeyFor @NonNull @Initialized Object internalLoad(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized Object var2, @UnknownKeyFor @NonNull @Initialized boolean var3, @UnknownKeyFor @NonNull @Initialized boolean var4) throws @UnknownKeyFor @NonNull @Initialized HibernateException;

    public @UnknownKeyFor @NonNull @Initialized Object immediateLoad(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized Object var2) throws @UnknownKeyFor @NonNull @Initialized HibernateException;

    public @UnknownKeyFor @NonNull @Initialized EntityPersister getEntityPersister(@Nullable @UnknownKeyFor @Initialized String var1, @UnknownKeyFor @NonNull @Initialized Object var2) throws @UnknownKeyFor @NonNull @Initialized HibernateException;

    public @UnknownKeyFor @NonNull @Initialized Object getEntityUsingInterceptor(@UnknownKeyFor @NonNull @Initialized EntityKey var1) throws @UnknownKeyFor @NonNull @Initialized HibernateException;

    public @UnknownKeyFor @NonNull @Initialized Object getContextEntityIdentifier(@UnknownKeyFor @NonNull @Initialized Object var1);

    public @UnknownKeyFor @NonNull @Initialized String bestGuessEntityName(@UnknownKeyFor @NonNull @Initialized Object var1);

    default public @UnknownKeyFor @NonNull @Initialized String bestGuessEntityName(@UnknownKeyFor @NonNull @Initialized Object object, @UnknownKeyFor @NonNull @Initialized EntityEntry entry) {
        return this.bestGuessEntityName(object);
    }

    public @UnknownKeyFor @NonNull @Initialized String guessEntityName(@UnknownKeyFor @NonNull @Initialized Object var1) throws @UnknownKeyFor @NonNull @Initialized HibernateException;

    @Deprecated(since="7", forRemoval=true)
    public @UnknownKeyFor @NonNull @Initialized Object instantiate(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized Object var2) throws @UnknownKeyFor @NonNull @Initialized HibernateException;

    public @UnknownKeyFor @NonNull @Initialized Object instantiate(@UnknownKeyFor @NonNull @Initialized EntityPersister var1, @UnknownKeyFor @NonNull @Initialized Object var2) throws @UnknownKeyFor @NonNull @Initialized HibernateException;

    public @UnknownKeyFor @NonNull @Initialized boolean isDefaultReadOnly();

    public @UnknownKeyFor @NonNull @Initialized boolean isIdentifierRollbackEnabled();

    public void setCriteriaCopyTreeEnabled(@UnknownKeyFor @NonNull @Initialized boolean var1);

    public @UnknownKeyFor @NonNull @Initialized boolean isCriteriaCopyTreeEnabled();

    public void setCriteriaPlanCacheEnabled(@UnknownKeyFor @NonNull @Initialized boolean var1);

    public @UnknownKeyFor @NonNull @Initialized boolean isCriteriaPlanCacheEnabled();

    public @UnknownKeyFor @NonNull @Initialized boolean getNativeJdbcParametersIgnored();

    public void setNativeJdbcParametersIgnored(@UnknownKeyFor @NonNull @Initialized boolean var1);

    @Override
    public @UnknownKeyFor @NonNull @Initialized FlushMode getHibernateFlushMode();

    public void flush();

    default public @UnknownKeyFor @NonNull @Initialized boolean isEventSource() {
        return false;
    }

    default public @UnknownKeyFor @NonNull @Initialized EventSource asEventSource() {
        throw new ClassCastException("session is not an EventSource");
    }

    public void afterScrollOperation();

    public @UnknownKeyFor @NonNull @Initialized LoadQueryInfluencers getLoadQueryInfluencers();

    public @UnknownKeyFor @NonNull @Initialized ExceptionConverter getExceptionConverter();

    default public @UnknownKeyFor @NonNull @Initialized Integer getConfiguredJdbcBatchSize() {
        Integer sessionJdbcBatchSize = this.getJdbcBatchSize();
        return sessionJdbcBatchSize == null ? this.getFactory().getSessionFactoryOptions().getJdbcBatchSize() : sessionJdbcBatchSize.intValue();
    }

    public @UnknownKeyFor @NonNull @Initialized PersistenceContext getPersistenceContextInternal();

    default public @UnknownKeyFor @NonNull @Initialized boolean autoFlushIfRequired(@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> querySpaces) {
        return this.autoFlushIfRequired(querySpaces, false);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean autoFlushIfRequired(@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> var1, @UnknownKeyFor @NonNull @Initialized boolean var2);

    public void autoPreFlush();

    public void afterOperation(@UnknownKeyFor @NonNull @Initialized boolean var1);

    @Deprecated(since="7.0", forRemoval=true)
    default public @UnknownKeyFor @NonNull @Initialized SessionImplementor asSessionImplementor() {
        throw new ClassCastException("session is not a SessionImplementor");
    }

    @Deprecated(since="7.0", forRemoval=true)
    default public @UnknownKeyFor @NonNull @Initialized boolean isSessionImplementor() {
        return this instanceof SessionImplementor;
    }

    @Deprecated(since="7.0", forRemoval=true)
    default public @UnknownKeyFor @NonNull @Initialized StatelessSession asStatelessSession() {
        return (StatelessSession)((Object)this);
    }

    @Deprecated(since="7.0", forRemoval=true)
    default public @UnknownKeyFor @NonNull @Initialized boolean isStatelessSession() {
        return this instanceof StatelessSession;
    }

    public void lock(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized Object var2, @UnknownKeyFor @NonNull @Initialized LockOptions var3);

    @Incubating
    public void registerProcess(@UnknownKeyFor @NonNull @Initialized AfterTransactionCompletionProcess var1);

    @Incubating
    public @UnknownKeyFor @NonNull @Initialized Object loadFromSecondLevelCache(@UnknownKeyFor @NonNull @Initialized EntityPersister var1, @UnknownKeyFor @NonNull @Initialized EntityKey var2, @UnknownKeyFor @NonNull @Initialized Object var3, @UnknownKeyFor @NonNull @Initialized LockMode var4);
}

