/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.transaction.jta.platform.internal;

import jakarta.transaction.TransactionManager;
import jakarta.transaction.UserTransaction;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.engine.jndi.JndiException;
import org.hibernate.engine.transaction.jta.platform.internal.AbstractJtaPlatform;

public class JBossAppServerJtaPlatform
extends AbstractJtaPlatform {
    public static final @UnknownKeyFor @NonNull @Initialized String AS7_TM_NAME = "java:jboss/TransactionManager";
    public static final @UnknownKeyFor @NonNull @Initialized String AS4_TM_NAME = "java:/TransactionManager";
    public static final @UnknownKeyFor @NonNull @Initialized String JBOSS_UT_NAME = "java:jboss/UserTransaction";
    public static final @UnknownKeyFor @NonNull @Initialized String UT_NAME = "java:comp/UserTransaction";

    @Override
    protected @UnknownKeyFor @NonNull @Initialized boolean canCacheUserTransactionByDefault() {
        return true;
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized TransactionManager locateTransactionManager() {
        try {
            return (TransactionManager)this.jndiService().locate(AS7_TM_NAME);
        }
        catch (JndiException jndiException) {
            try {
                return (TransactionManager)this.jndiService().locate(AS4_TM_NAME);
            }
            catch (JndiException jndiExceptionInner) {
                throw new JndiException("unable to find transaction manager", (Throwable)((Object)jndiException));
            }
        }
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized UserTransaction locateUserTransaction() {
        try {
            return (UserTransaction)this.jndiService().locate(JBOSS_UT_NAME);
        }
        catch (JndiException jndiException) {
            try {
                return (UserTransaction)this.jndiService().locate(UT_NAME);
            }
            catch (JndiException jndiExceptionInner) {
                throw new JndiException("unable to find UserTransaction", (Throwable)((Object)jndiException));
            }
        }
    }
}

