/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.transaction.jta.platform.internal;

import java.util.Map;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.engine.transaction.jta.platform.internal.AtomikosJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.internal.JBossStandAloneJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.internal.NoJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.internal.WebSphereLibertyJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.internal.WildFlyStandAloneJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatformProvider;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatformResolver;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.jboss.logging.Logger;

public class StandardJtaPlatformResolver
implements JtaPlatformResolver {
    public static final @UnknownKeyFor @NonNull @Initialized StandardJtaPlatformResolver INSTANCE = new StandardJtaPlatformResolver();
    private static final @UnknownKeyFor @NonNull @Initialized Logger log = Logger.getLogger(StandardJtaPlatformResolver.class);

    @Override
    public @UnknownKeyFor @NonNull @Initialized JtaPlatform resolveJtaPlatform(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> configurationValues, @UnknownKeyFor @NonNull @Initialized ServiceRegistryImplementor registry) {
        ClassLoaderService classLoaderService = registry.requireService(ClassLoaderService.class);
        for (JtaPlatformProvider provider : classLoaderService.loadJavaServices(JtaPlatformProvider.class)) {
            JtaPlatform providedPlatform = provider.getProvidedJtaPlatform();
            log.tracef("Located JtaPlatformProvider [%s] provided JtaPlatform : %s", (Object)provider, (Object)providedPlatform);
            if (providedPlatform == null) continue;
            return providedPlatform;
        }
        try {
            classLoaderService.classForName("org.wildfly.transaction.client.ContextTransactionManager");
            classLoaderService.classForName("org.wildfly.transaction.client.LocalUserTransaction");
            return new WildFlyStandAloneJtaPlatform();
        }
        catch (ClassLoadingException classLoadingException) {
            try {
                classLoaderService.classForName("com.arjuna.ats.jta.TransactionManager");
                classLoaderService.classForName("com.arjuna.ats.jta.UserTransaction");
                return new JBossStandAloneJtaPlatform();
            }
            catch (ClassLoadingException classLoadingException2) {
                try {
                    classLoaderService.classForName("com.atomikos.icatch.jta.UserTransactionManager");
                    return new AtomikosJtaPlatform();
                }
                catch (ClassLoadingException classLoadingException3) {
                    try {
                        classLoaderService.classForName("com.ibm.tx.jta.TransactionManagerFactory");
                        return new WebSphereLibertyJtaPlatform();
                    }
                    catch (ClassLoadingException classLoadingException4) {
                        log.debugf("Could not resolve JtaPlatform, using default [%s]", (Object)NoJtaPlatform.class.getName());
                        return NoJtaPlatform.INSTANCE;
                    }
                }
            }
        }
    }
}

