/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import org.hibernate.HibernateException;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.InitializeCollectionEvent;
import org.hibernate.event.spi.InitializeCollectionEventListener;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.loader.internal.CacheLoadHelper;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.sql.results.internal.ResultsHelper;
import org.hibernate.stat.spi.StatisticsImplementor;

public class DefaultInitializeCollectionEventListener
implements InitializeCollectionEventListener {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(DefaultInitializeCollectionEventListener.class);

    @Override
    public void onInitializeCollection(InitializeCollectionEvent event) throws HibernateException {
        PersistentCollection<?> collection = event.getCollection();
        EventSource source = event.getSession();
        PersistenceContext persistenceContext = source.getPersistenceContextInternal();
        CollectionEntry ce = persistenceContext.getCollectionEntry(collection);
        if (ce == null) {
            throw new HibernateException("Collection was evicted");
        }
        if (!collection.wasInitialized()) {
            boolean foundInCache;
            CollectionPersister loadedPersister = ce.getLoadedPersister();
            Object loadedKey = ce.getLoadedKey();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Initializing collection " + MessageHelper.collectionInfoString(loadedPersister, collection, loadedKey, source));
            }
            if (foundInCache = this.initializeFromCache(loadedKey, loadedPersister, collection, source)) {
                LOG.trace("Collection initialized from cache");
            } else {
                LOG.trace("Collection not cached");
                loadedPersister.initialize(loadedKey, source);
                DefaultInitializeCollectionEventListener.handlePotentiallyEmptyCollection(collection, persistenceContext, loadedKey, loadedPersister);
                LOG.trace("Collection initialized");
                StatisticsImplementor statistics = source.getFactory().getStatistics();
                if (statistics.isStatisticsEnabled()) {
                    statistics.fetchCollection(loadedPersister.getRole());
                }
            }
        }
    }

    public static void handlePotentiallyEmptyCollection(PersistentCollection<?> collection, PersistenceContext persistenceContext, Object loadedKey, CollectionPersister loadedPersister) {
        if (!collection.wasInitialized()) {
            collection.initializeEmptyCollection(loadedPersister);
            ResultsHelper.finalizeCollectionLoading(persistenceContext, loadedPersister, collection, loadedKey, true);
        }
    }

    private boolean initializeFromCache(Object id, CollectionPersister persister, PersistentCollection<?> collection, SessionImplementor source) {
        if (source.getLoadQueryInfluencers().hasEnabledFilters() && persister.isAffectedByEnabledFilters(source)) {
            LOG.trace("Disregarding cached version (if any) of collection due to enabled filters");
            return false;
        }
        return CacheLoadHelper.initializeCollectionFromCache(id, persister, collection, source);
    }
}

