/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.service.internal;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.event.service.spi.DuplicationStrategy;
import org.hibernate.event.service.spi.EventActionWithParameter;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.service.spi.EventListenerRegistrationException;
import org.hibernate.event.service.spi.JpaBootstrapSensitive;
import org.hibernate.event.spi.EventType;
import org.hibernate.internal.build.AllowReflection;
import org.hibernate.jpa.event.spi.CallbackRegistry;
import org.hibernate.jpa.event.spi.CallbackRegistryConsumer;
import org.jboss.logging.Logger;

class EventListenerGroupImpl<T>
implements EventListenerGroup<T> {
    private static final Logger log = Logger.getLogger(EventListenerGroupImpl.class);
    private static final DuplicationStrategy DEFAULT_DUPLICATION_STRATEGY = new DuplicationStrategy(){

        @Override
        public boolean areMatch(Object listener, Object original) {
            return listener.getClass().equals(original.getClass());
        }

        @Override
        public DuplicationStrategy.Action getAction() {
            return DuplicationStrategy.Action.ERROR;
        }
    };
    private static final Set<DuplicationStrategy> DEFAULT_DUPLICATION_STRATEGIES = Collections.singleton(DEFAULT_DUPLICATION_STRATEGY);
    private static final CompletableFuture<?> COMPLETED = CompletableFuture.completedFuture(null);
    private final EventType<T> eventType;
    private final CallbackRegistry callbackRegistry;
    private final boolean isJpaBootstrap;
    private volatile Set<DuplicationStrategy> duplicationStrategies = DEFAULT_DUPLICATION_STRATEGIES;
    private volatile T[] listeners = null;
    private volatile List<T> listenersAsList = Collections.emptyList();

    private static <R> CompletableFuture<R> nullCompletion() {
        return COMPLETED;
    }

    public EventListenerGroupImpl(EventType<T> eventType, CallbackRegistry callbackRegistry, boolean isJpaBootstrap) {
        this.eventType = eventType;
        this.callbackRegistry = callbackRegistry;
        this.isJpaBootstrap = isJpaBootstrap;
    }

    @Override
    public EventType<T> getEventType() {
        return this.eventType;
    }

    @Override
    public boolean isEmpty() {
        return this.count() <= 0;
    }

    @Override
    public int count() {
        T[] ls = this.listeners;
        return ls == null ? 0 : ls.length;
    }

    @Override
    public void clear() {
        this.duplicationStrategies = new LinkedHashSet<DuplicationStrategy>();
        this.setListeners(null);
    }

    private synchronized void setListeners(T[] newListeners) {
        this.listeners = newListeners;
        this.listenersAsList = newListeners == null || newListeners.length == 0 ? Collections.emptyList() : Arrays.asList(newListeners);
    }

    @Override
    public void clearListeners() {
        this.setListeners(null);
    }

    @Override
    public final <U> void fireLazyEventOnEachListener(Supplier<U> eventSupplier, BiConsumer<T, U> actionOnEvent) {
        T[] ls = this.listeners;
        if (ls != null && ls.length != 0) {
            U event = eventSupplier.get();
            for (int i = 0; i < ls.length; ++i) {
                actionOnEvent.accept(ls[i], event);
            }
        }
    }

    @Override
    public final <U> void fireEventOnEachListener(U event, BiConsumer<T, U> actionOnEvent) {
        T[] ls = this.listeners;
        if (ls != null) {
            for (int i = 0; i < ls.length; ++i) {
                actionOnEvent.accept(ls[i], event);
            }
        }
    }

    @Override
    public <U, X> void fireEventOnEachListener(U event, X parameter, EventActionWithParameter<T, U, X> actionOnEvent) {
        T[] ls = this.listeners;
        if (ls != null) {
            for (int i = 0; i < ls.length; ++i) {
                actionOnEvent.applyEventToListener(ls[i], event, parameter);
            }
        }
    }

    @Override
    public <R, U, RL> CompletionStage<R> fireEventOnEachListener(U event, Function<RL, Function<U, CompletionStage<R>>> fun) {
        CompletionStage<Object> ret = EventListenerGroupImpl.nullCompletion();
        T[] ls = this.listeners;
        if (ls != null) {
            for (Object listener : ls) {
                ret = ret.thenCompose(v -> (CompletionStage)((Function)fun.apply(listener)).apply(event));
            }
        }
        return ret;
    }

    @Override
    public <R, U, RL, X> CompletionStage<R> fireEventOnEachListener(U event, X param, Function<RL, BiFunction<U, X, CompletionStage<R>>> fun) {
        CompletionStage<Object> ret = EventListenerGroupImpl.nullCompletion();
        T[] ls = this.listeners;
        if (ls != null) {
            for (Object listener : ls) {
                ret = ret.thenCompose(v -> (CompletionStage)((BiFunction)fun.apply(listener)).apply(event, param));
            }
        }
        return ret;
    }

    @Override
    public <R, U, RL> CompletionStage<R> fireLazyEventOnEachListener(Supplier<U> eventSupplier, Function<RL, Function<U, CompletionStage<R>>> fun) {
        CompletionStage<Object> ret = EventListenerGroupImpl.nullCompletion();
        T[] ls = this.listeners;
        if (ls != null && ls.length != 0) {
            Object event = eventSupplier.get();
            for (Object listener : ls) {
                ret = ret.thenCompose(v -> (CompletionStage)((Function)fun.apply(listener)).apply(event));
            }
        }
        return ret;
    }

    @Override
    public void addDuplicationStrategy(DuplicationStrategy strategy) {
        if (this.duplicationStrategies == DEFAULT_DUPLICATION_STRATEGIES) {
            this.duplicationStrategies = new LinkedHashSet<DuplicationStrategy>(DEFAULT_DUPLICATION_STRATEGIES);
        }
        this.duplicationStrategies.add(strategy);
    }

    @Override
    public void appendListener(T listener) {
        this.handleListenerAddition(listener, this::internalAppend);
    }

    @Override
    @SafeVarargs
    public final void appendListeners(T ... listeners) {
        for (int i = 0; i < listeners.length; ++i) {
            this.handleListenerAddition(listeners[i], this::internalAppend);
        }
    }

    private void internalAppend(T listener) {
        T[] listenersWrite;
        this.prepareListener(listener);
        T[] listenersRead = this.listeners;
        if (listenersRead == null) {
            listenersWrite = this.createListenerArrayForWrite(1);
            listenersWrite[0] = listener;
        } else {
            int size = listenersRead.length;
            listenersWrite = this.createListenerArrayForWrite(size + 1);
            System.arraycopy(listenersRead, 0, listenersWrite, 0, size);
            listenersWrite[size] = listener;
        }
        this.setListeners(listenersWrite);
    }

    @Override
    public void prependListener(T listener) {
        this.handleListenerAddition(listener, this::internalPrepend);
    }

    @Override
    @SafeVarargs
    public final void prependListeners(T ... listeners) {
        for (int i = 0; i < listeners.length; ++i) {
            this.handleListenerAddition(listeners[i], this::internalPrepend);
        }
    }

    private void internalPrepend(T listener) {
        T[] listenersWrite;
        this.prepareListener(listener);
        T[] listenersRead = this.listeners;
        if (listenersRead == null) {
            listenersWrite = this.createListenerArrayForWrite(1);
            listenersWrite[0] = listener;
        } else {
            int size = listenersRead.length;
            listenersWrite = this.createListenerArrayForWrite(size + 1);
            listenersWrite[0] = listener;
            System.arraycopy(listenersRead, 0, listenersWrite, 1, size);
        }
        this.setListeners(listenersWrite);
    }

    private void handleListenerAddition(T listener, Consumer<T> additionHandler) {
        T[] listenersRead = this.listeners;
        if (listenersRead == null) {
            additionHandler.accept(listener);
            return;
        }
        int size = listenersRead.length;
        T[] listenersWrite = this.createListenerArrayForWrite(size);
        System.arraycopy(listenersRead, 0, listenersWrite, 0, size);
        boolean debugEnabled = log.isDebugEnabled();
        for (DuplicationStrategy strategy : this.duplicationStrategies) {
            for (int i = 0; i < size; ++i) {
                T existingListener = listenersRead[i];
                if (debugEnabled) {
                    log.debugf("Checking incoming listener [`%s`] for match against existing listener [`%s`]", listener, existingListener);
                }
                if (!strategy.areMatch(listener, existingListener)) continue;
                if (debugEnabled) {
                    log.debugf("Found listener match between `%s` and `%s`", listener, existingListener);
                }
                DuplicationStrategy.Action action = strategy.getAction();
                switch (action) {
                    case ERROR: {
                        throw new EventListenerRegistrationException("Duplicate event listener found");
                    }
                    case KEEP_ORIGINAL: {
                        if (debugEnabled) {
                            log.debugf("Skipping listener registration (%s) : `%s`", (Object)action, listener);
                        }
                        return;
                    }
                    case REPLACE_ORIGINAL: {
                        if (debugEnabled) {
                            log.debugf("Replacing listener registration (%s) : `%s` -> `%s`", (Object)action, existingListener, listener);
                        }
                        this.prepareListener(listener);
                        listenersWrite[i] = listener;
                    }
                }
                this.setListeners(listenersWrite);
                return;
            }
        }
        this.checkAgainstBaseInterface(listener);
        this.performInjections(listener);
        additionHandler.accept(listener);
    }

    @AllowReflection
    private T[] createListenerArrayForWrite(int len) {
        return (Object[])Array.newInstance(this.eventType.baseListenerInterface(), len);
    }

    private void prepareListener(T listener) {
        this.checkAgainstBaseInterface(listener);
        this.performInjections(listener);
    }

    private void performInjections(T listener) {
        if (listener instanceof CallbackRegistryConsumer) {
            CallbackRegistryConsumer consumer = (CallbackRegistryConsumer)listener;
            consumer.injectCallbackRegistry(this.callbackRegistry);
        }
        if (listener instanceof JpaBootstrapSensitive) {
            JpaBootstrapSensitive sensitive = (JpaBootstrapSensitive)listener;
            sensitive.wasJpaBootstrap(this.isJpaBootstrap);
        }
    }

    private void checkAgainstBaseInterface(T listener) {
        if (!this.eventType.baseListenerInterface().isInstance(listener)) {
            throw new EventListenerRegistrationException("Listener did not implement expected interface [" + this.eventType.baseListenerInterface().getName() + "]");
        }
    }

    @Override
    @Deprecated
    public final Iterable<T> listeners() {
        return this.listenersAsList;
    }
}

