/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.exception.internal;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.JDBCException;
import org.hibernate.exception.GenericJDBCException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.SQLExceptionConverter;

public class StandardSQLExceptionConverter
implements SQLExceptionConverter {
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SQLExceptionConversionDelegate> delegates;

    public StandardSQLExceptionConverter(SQLExceptionConversionDelegate ... delegates) {
        this.delegates = Arrays.asList(delegates);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized JDBCException convert(@UnknownKeyFor @NonNull @Initialized SQLException sqlException, @UnknownKeyFor @NonNull @Initialized String message, @UnknownKeyFor @NonNull @Initialized String sql) {
        for (SQLExceptionConversionDelegate delegate : this.delegates) {
            JDBCException jdbcException = delegate.convert(sqlException, message, sql);
            if (jdbcException == null) continue;
            return jdbcException;
        }
        return new GenericJDBCException(message, sqlException, sql);
    }
}

