/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.graph.internal.parse;

import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.grammars.graph.GraphLanguageParser;
import org.hibernate.grammars.graph.GraphLanguageParserBaseVisitor;
import org.hibernate.graph.GraphNode;
import org.hibernate.graph.InvalidGraphException;
import org.hibernate.graph.internal.GraphParserLogging;
import org.hibernate.graph.internal.parse.EntityNameResolver;
import org.hibernate.graph.internal.parse.EntityNameResolverSessionFactory;
import org.hibernate.graph.internal.parse.PathQualifierType;
import org.hibernate.graph.internal.parse.SubGraphGenerator;
import org.hibernate.graph.spi.AttributeNodeImplementor;
import org.hibernate.graph.spi.GraphImplementor;
import org.hibernate.graph.spi.SubGraphImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.internal.util.collections.StandardStack;

public class GraphParser
extends GraphLanguageParserBaseVisitor<GraphNode<?>> {
    private final EntityNameResolver entityNameResolver;
    private final Stack<GraphImplementor<?>> graphStack = new StandardStack();
    private final Stack<AttributeNodeImplementor<?, ?, ?>> attributeNodeStack = new StandardStack();
    private final Stack<SubGraphGenerator> graphSourceStack = new StandardStack<SubGraphGenerator>();

    public GraphParser(EntityNameResolver entityNameResolver) {
        this.entityNameResolver = entityNameResolver;
    }

    public GraphParser(SessionFactoryImplementor sessionFactory) {
        this(new EntityNameResolverSessionFactory(sessionFactory));
    }

    public Stack<GraphImplementor<?>> getGraphStack() {
        return this.graphStack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttributeNodeImplementor<?, ?, ?> visitAttributeNode(GraphLanguageParser.AttributeNodeContext attributeNodeContext) {
        SubGraphGenerator subGraphCreator;
        String attributeName = attributeNodeContext.attributePath().ATTR_NAME().getText();
        if (attributeNodeContext.attributePath().attributeQualifier() == null) {
            if (GraphParserLogging.PARSING_LOGGER.isDebugEnabled()) {
                GraphParserLogging.PARSING_LOGGER.debugf("%s Start attribute : %s", (Object)StringHelper.repeat(">>", this.attributeNodeStack.depth() + 1), (Object)attributeName);
            }
            subGraphCreator = PathQualifierType.VALUE.getSubGraphCreator();
        } else {
            String qualifierName = attributeNodeContext.attributePath().attributeQualifier().ATTR_NAME().getText();
            if (GraphParserLogging.PARSING_LOGGER.isDebugEnabled()) {
                GraphParserLogging.PARSING_LOGGER.debugf("%s Start qualified attribute : %s.%s", (Object)StringHelper.repeat(">>", this.attributeNodeStack.depth() + 1), (Object)attributeName, (Object)qualifierName);
            }
            PathQualifierType pathQualifierType = this.resolvePathQualifier(qualifierName);
            subGraphCreator = pathQualifierType.getSubGraphCreator();
        }
        AttributeNodeImplementor<?, ?, ?> attributeNode = this.resolveAttributeNode(attributeName);
        if (attributeNodeContext.subGraph() != null) {
            this.attributeNodeStack.push(attributeNode);
            this.graphSourceStack.push(subGraphCreator);
            try {
                this.visitSubGraph(attributeNodeContext.subGraph());
            }
            finally {
                this.graphSourceStack.pop();
                this.attributeNodeStack.pop();
            }
        }
        if (GraphParserLogging.PARSING_LOGGER.isDebugEnabled()) {
            GraphParserLogging.PARSING_LOGGER.debugf("%s Finished attribute : %s", (Object)StringHelper.repeat("<<", this.attributeNodeStack.depth() + 1), (Object)attributeName);
        }
        return attributeNode;
    }

    private AttributeNodeImplementor<?, ?, ?> resolveAttributeNode(String attributeName) {
        GraphImplementor<?> currentGraph = this.graphStack.getCurrent();
        assert (currentGraph != null);
        AttributeNodeImplementor attributeNode = currentGraph.findOrCreateAttributeNode(attributeName);
        assert (attributeNode != null);
        return attributeNode;
    }

    private PathQualifierType resolvePathQualifier(String qualifier) {
        if ("key".equalsIgnoreCase(qualifier)) {
            return PathQualifierType.KEY;
        }
        if ("value".equalsIgnoreCase(qualifier)) {
            return PathQualifierType.VALUE;
        }
        throw new InvalidGraphException("Invalid path qualifier [" + qualifier + "] - expecting `key` or `value`");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubGraphImplementor<?> visitSubGraph(GraphLanguageParser.SubGraphContext subGraphContext) {
        String subTypeName;
        String string = subTypeName = subGraphContext.typeIndicator() == null ? null : subGraphContext.typeIndicator().TYPE_NAME().getText();
        if (GraphParserLogging.PARSING_LOGGER.isDebugEnabled()) {
            GraphParserLogging.PARSING_LOGGER.debugf("%s Starting graph : %s", (Object)StringHelper.repeat(">>", this.attributeNodeStack.depth() + 2), (Object)subTypeName);
        }
        AttributeNodeImplementor<?, ?, ?> attributeNode = this.attributeNodeStack.getCurrent();
        SubGraphGenerator subGraphCreator = this.graphSourceStack.getCurrent();
        SubGraphImplementor<?> subGraph = subGraphCreator.createSubGraph(attributeNode, subTypeName, this.entityNameResolver);
        this.graphStack.push(subGraph);
        try {
            subGraphContext.attributeList().accept(this);
        }
        finally {
            this.graphStack.pop();
        }
        if (GraphParserLogging.PARSING_LOGGER.isDebugEnabled()) {
            GraphParserLogging.PARSING_LOGGER.debugf("%s Finished graph : %s", (Object)StringHelper.repeat("<<", this.attributeNodeStack.depth() + 2), (Object)subGraph.getGraphedType().getTypeName());
        }
        return subGraph;
    }
}

