/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import jakarta.persistence.PersistenceException;
import jakarta.persistence.PessimisticLockScope;
import java.util.Map;
import java.util.function.Supplier;
import org.hibernate.LockOptions;

public final class LockOptionsHelper {
    private LockOptionsHelper() {
    }

    public static void applyPropertiesToLockOptions(Map<String, Object> props, Supplier<LockOptions> lockOptions) {
        LockOptionsHelper.applyScope(props, lockOptions);
        LockOptionsHelper.applyTimeout(props, lockOptions);
    }

    private static void applyScope(Map<String, Object> props, Supplier<LockOptions> lockOptions) {
        String lockScopeHint = "javax.persistence.lock.scope";
        Object lockScope = props.get(lockScopeHint);
        if (lockScope == null) {
            lockScopeHint = "jakarta.persistence.lock.scope";
            lockScope = props.get(lockScopeHint);
        }
        if (lockScope instanceof String) {
            String string = (String)lockScope;
            lockOptions.get().setLockScope(PessimisticLockScope.EXTENDED.name().equalsIgnoreCase(string) ? PessimisticLockScope.EXTENDED : PessimisticLockScope.NORMAL);
        } else if (lockScope instanceof PessimisticLockScope) {
            PessimisticLockScope pessimisticLockScope = (PessimisticLockScope)lockScope;
            lockOptions.get().setLockScope(pessimisticLockScope);
        } else if (lockScope != null) {
            throw new PersistenceException("Unable to parse " + lockScopeHint + ": " + String.valueOf(lockScope));
        }
    }

    private static void applyTimeout(Map<String, Object> props, Supplier<LockOptions> lockOptions) {
        String timeoutHint = "javax.persistence.lock.timeout";
        Object lockTimeout = props.get(timeoutHint);
        if (lockTimeout == null) {
            timeoutHint = "jakarta.persistence.lock.timeout";
            lockTimeout = props.get(timeoutHint);
        }
        if (lockTimeout instanceof String) {
            String string = (String)lockTimeout;
            lockOptions.get().setTimeOut(Integer.parseInt(string));
        } else if (lockTimeout instanceof Number) {
            Number number = (Number)lockTimeout;
            int timeout = number.intValue();
            lockOptions.get().setTimeOut(timeout);
        } else if (lockTimeout != null) {
            throw new PersistenceException("Unable to parse " + timeoutHint + ": " + String.valueOf(lockTimeout));
        }
    }
}

