/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import org.hibernate.CacheMode;
import org.hibernate.action.spi.AfterTransactionCompletionProcess;
import org.hibernate.cache.spi.access.CachedDomainDataAccess;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.cache.spi.entry.CacheEntry;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.monitor.spi.DiagnosticEvent;
import org.hibernate.event.monitor.spi.EventMonitor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.stat.internal.StatsHelper;
import org.hibernate.stat.spi.StatisticsImplementor;

public final class OptimisticLockHelper {
    private OptimisticLockHelper() {
    }

    public static void forceVersionIncrement(Object object, EntityEntry entry, SharedSessionContractImplementor session) {
        Object cacheKey;
        EntityPersister persister = entry.getPersister();
        Object previousVersion = entry.getVersion();
        SoftLock lock = null;
        if (persister.canWriteToCache()) {
            EntityDataAccess cache = persister.getCacheAccessStrategy();
            cacheKey = cache.generateCacheKey(entry.getId(), persister, session.getFactory(), session.getTenantIdentifier());
            lock = cache.lockItem(session, cacheKey, previousVersion);
        } else {
            cacheKey = null;
        }
        Object nextVersion = persister.forceVersionIncrement(entry.getId(), previousVersion, session);
        entry.forceLocked(object, nextVersion);
        if (persister.canWriteToCache()) {
            Object cacheEntry = OptimisticLockHelper.updateCacheItem(object, previousVersion, nextVersion, cacheKey, entry, persister, session);
            session.registerProcess(new CacheCleanupProcess(cacheKey, persister, previousVersion, nextVersion, lock, cacheEntry));
        }
    }

    private static Object updateCacheItem(Object entity, Object previousVersion, Object nextVersion, Object ck, EntityEntry entry, EntityPersister persister, SharedSessionContractImplementor session) {
        if (OptimisticLockHelper.isCacheInvalidationRequired(persister, session) || entry.getStatus() != Status.MANAGED) {
            persister.getCacheAccessStrategy().remove(session, ck);
        } else if (session.getCacheMode().isPutEnabled()) {
            CacheEntry ce = persister.buildCacheEntry(entity, entry.getLoadedState(), nextVersion, session);
            Object cacheEntry = persister.getCacheEntryStructure().structure(ce);
            boolean put = OptimisticLockHelper.updateCache(persister, cacheEntry, previousVersion, nextVersion, ck, session);
            StatisticsImplementor statistics = session.getFactory().getStatistics();
            if (put && statistics.isStatisticsEnabled()) {
                statistics.entityCachePut(StatsHelper.getRootEntityRole(persister), persister.getCacheAccessStrategy().getRegion().getName());
            }
            return cacheEntry;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean updateCache(EntityPersister persister, Object cacheEntry, Object previousVersion, Object nextVersion, Object ck, SharedSessionContractImplementor session) {
        EventMonitor eventMonitor = session.getEventMonitor();
        DiagnosticEvent cachePutEvent = eventMonitor.beginCachePutEvent();
        EntityDataAccess cacheAccessStrategy = persister.getCacheAccessStrategy();
        boolean update = false;
        try {
            session.getEventListenerManager().cachePutStart();
            boolean bl = update = cacheAccessStrategy.update(session, ck, cacheEntry, nextVersion, previousVersion);
            return bl;
        }
        finally {
            eventMonitor.completeCachePutEvent(cachePutEvent, session, (CachedDomainDataAccess)cacheAccessStrategy, persister, update, EventMonitor.CacheActionDescription.ENTITY_UPDATE);
            session.getEventListenerManager().cachePutEnd();
        }
    }

    private static boolean isCacheInvalidationRequired(EntityPersister persister, SharedSessionContractImplementor session) {
        return persister.isCacheInvalidationRequired() || session.getCacheMode() == CacheMode.GET || session.getCacheMode() == CacheMode.IGNORE;
    }

    private static class CacheCleanupProcess
    implements AfterTransactionCompletionProcess {
        private final Object cacheKey;
        private final EntityPersister persister;
        private final Object previousVersion;
        private final Object nextVersion;
        private final SoftLock lock;
        private final Object cacheEntry;

        private CacheCleanupProcess(Object cacheKey, EntityPersister persister, Object previousVersion, Object nextVersion, SoftLock lock, Object cacheEntry) {
            this.cacheKey = cacheKey;
            this.persister = persister;
            this.previousVersion = previousVersion;
            this.nextVersion = nextVersion;
            this.lock = lock;
            this.cacheEntry = cacheEntry;
        }

        @Override
        public void doAfterTransactionCompletion(boolean success, SharedSessionContractImplementor session) {
            EntityDataAccess cache = this.persister.getCacheAccessStrategy();
            if (CacheCleanupProcess.cacheUpdateRequired(success, this.persister, session)) {
                this.cacheAfterUpdate(cache, this.cacheKey, session);
            } else {
                cache.unlockItem(session, this.cacheKey, this.lock);
            }
        }

        private static boolean cacheUpdateRequired(boolean success, EntityPersister persister, SharedSessionContractImplementor session) {
            return success && !persister.isCacheInvalidationRequired() && session.getCacheMode().isPutEnabled();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void cacheAfterUpdate(EntityDataAccess cache, Object ck, SharedSessionContractImplementor session) {
            SessionEventListenerManager eventListenerManager = session.getEventListenerManager();
            EventMonitor eventMonitor = session.getEventMonitor();
            DiagnosticEvent cachePutEvent = eventMonitor.beginCachePutEvent();
            boolean put = false;
            try {
                eventListenerManager.cachePutStart();
                put = cache.afterUpdate(session, ck, this.cacheEntry, this.nextVersion, this.previousVersion, this.lock);
            }
            finally {
                eventMonitor.completeCachePutEvent(cachePutEvent, session, (CachedDomainDataAccess)cache, this.persister, put, EventMonitor.CacheActionDescription.ENTITY_AFTER_UPDATE);
                StatisticsImplementor statistics = session.getFactory().getStatistics();
                if (put && statistics.isStatisticsEnabled()) {
                    statistics.entityCachePut(StatsHelper.getRootEntityRole(this.persister), cache.getRegion().getName());
                }
                eventListenerManager.cachePutEnd();
            }
        }
    }
}

