/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util;

import org.hibernate.internal.util.SubSequence;

public final class CharSequenceHelper {
    private CharSequenceHelper() {
    }

    public static CharSequence subSequence(CharSequence sequence, int start, int end) {
        if (start == 0 && end == sequence.length()) {
            return sequence;
        }
        if (sequence instanceof SubSequence) {
            return sequence.subSequence(start, end);
        }
        return new SubSequence(sequence, start, end);
    }

    public static boolean isEmpty(CharSequence string) {
        return string == null || string.length() == 0;
    }

    public static int lastIndexOf(CharSequence charSequence, char c) {
        return CharSequenceHelper.lastIndexOf(charSequence, c, 0, charSequence.length() - 1);
    }

    public static int lastIndexOf(CharSequence charSequence, char c, int fromIndex, int endIndex) {
        if (charSequence instanceof String) {
            String string = (String)charSequence;
            int idx = string.lastIndexOf(c, endIndex);
            if (idx < fromIndex) {
                return -1;
            }
            return idx;
        }
        if (charSequence instanceof SubSequence) {
            SubSequence subSequence = (SubSequence)charSequence;
            return subSequence.lastIndexOf(c, fromIndex, endIndex);
        }
        return CharSequenceHelper.lastIndexOf(charSequence.toString(), c, fromIndex, endIndex);
    }

    public static int indexOf(CharSequence charSequence, char c) {
        return CharSequenceHelper.indexOf(charSequence, c, 0);
    }

    public static int indexOf(CharSequence charSequence, char c, int fromIndex) {
        return CharSequenceHelper.indexOf(charSequence, c, fromIndex, charSequence.length() - 1);
    }

    public static int indexOf(CharSequence charSequence, char c, int fromIndex, int endIndex) {
        if (charSequence instanceof String) {
            String string = (String)charSequence;
            int idx = string.indexOf(c, fromIndex);
            if (idx > endIndex) {
                return -1;
            }
            return idx;
        }
        if (charSequence instanceof SubSequence) {
            SubSequence subSequence = (SubSequence)charSequence;
            return subSequence.indexOf(c, fromIndex, endIndex);
        }
        return CharSequenceHelper.indexOf((CharSequence)charSequence.toString(), c, fromIndex, endIndex);
    }

    public static int indexOf(CharSequence charSequence, String target, int fromIndex) {
        return CharSequenceHelper.indexOf(charSequence, target, fromIndex, charSequence.length() - 1);
    }

    public static int indexOf(CharSequence charSequence, String target, int fromIndex, int endIndex) {
        if (charSequence instanceof String) {
            String string = (String)charSequence;
            int idx = string.indexOf(target, fromIndex);
            if (idx > endIndex) {
                return -1;
            }
            return idx;
        }
        if (charSequence instanceof SubSequence) {
            SubSequence subSequence = (SubSequence)charSequence;
            return subSequence.indexOf(target, fromIndex, endIndex);
        }
        return CharSequenceHelper.indexOf((CharSequence)charSequence.toString(), target, fromIndex, endIndex);
    }

    public static boolean regionMatchesIgnoreCase(CharSequence lhs, int lhsStart, CharSequence rhs, int rhsStart, int length) {
        if (lhsStart + length <= lhs.length() && rhsStart + length <= rhs.length()) {
            for (int i = 0; i < length; ++i) {
                char c2;
                char c1 = lhs.charAt(lhsStart + i);
                if (c1 == (c2 = rhs.charAt(rhsStart + i)) || Character.toLowerCase(c1) == Character.toLowerCase(c2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

