/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util;

import jakarta.persistence.AttributeConverter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;

public class GenericsHelper {
    public static ParameterizedType extractParameterizedType(Type base) {
        if (base == null) {
            return null;
        }
        Class<?> clazz = GenericsHelper.extractClass(base);
        if (clazz == null) {
            return null;
        }
        ArrayList<Type> types = new ArrayList<Type>();
        types.add(clazz.getGenericSuperclass());
        types.addAll(Arrays.asList(clazz.getGenericInterfaces()));
        for (Type type : types) {
            ParameterizedType parameterizedType;
            if ((type = GenericsHelper.resolveType(type, base)) instanceof ParameterizedType && AttributeConverter.class.equals((Object)(parameterizedType = (ParameterizedType)type).getRawType())) {
                return parameterizedType;
            }
            parameterizedType = GenericsHelper.extractParameterizedType(type);
            if (parameterizedType == null) continue;
            return parameterizedType;
        }
        return null;
    }

    private static Type resolveTypeVariable(TypeVariable<?> typeVariable, ParameterizedType context) {
        Class<?> clazz = GenericsHelper.extractClass(context.getRawType());
        if (clazz == null) {
            return null;
        }
        TypeVariable<Class<?>>[] typeParameters = clazz.getTypeParameters();
        for (int idx = 0; idx < typeParameters.length; ++idx) {
            if (!typeVariable.getName().equals(typeParameters[idx].getName())) continue;
            return GenericsHelper.resolveType(context.getActualTypeArguments()[idx], context);
        }
        return typeVariable;
    }

    public static Class<?> extractClass(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return clazz;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return GenericsHelper.extractClass(parameterizedType.getRawType());
        }
        return null;
    }

    private static Type resolveType(Type target, Type context) {
        if (target instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)target;
            return GenericsHelper.resolveParameterizedType(parameterizedType, context);
        }
        if (target instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)target;
            return GenericsHelper.resolveTypeVariable(typeVariable, (ParameterizedType)context);
        }
        return target;
    }

    private static ParameterizedType resolveParameterizedType(final ParameterizedType parameterizedType, Type context) {
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        final Type[] resolvedTypeArguments = new Type[actualTypeArguments.length];
        for (int idx = 0; idx < actualTypeArguments.length; ++idx) {
            resolvedTypeArguments[idx] = GenericsHelper.resolveType(actualTypeArguments[idx], context);
        }
        return new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return resolvedTypeArguments;
            }

            @Override
            public Type getRawType() {
                return parameterizedType.getRawType();
            }

            @Override
            public Type getOwnerType() {
                return parameterizedType.getOwnerType();
            }
        };
    }
}

