/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jdbc;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.exception.GenericJDBCException;
import org.hibernate.jdbc.Expectations;

public interface Expectation {
    default public @UnknownKeyFor @NonNull @Initialized boolean canBeBatched() {
        return true;
    }

    default public @UnknownKeyFor @NonNull @Initialized int getNumberOfParametersUsed() {
        return 0;
    }

    public void verifyOutcome(@UnknownKeyFor @NonNull @Initialized int var1, @UnknownKeyFor @NonNull @Initialized PreparedStatement var2, @UnknownKeyFor @NonNull @Initialized int var3, @UnknownKeyFor @NonNull @Initialized String var4) throws @UnknownKeyFor @NonNull @Initialized SQLException, @UnknownKeyFor @NonNull @Initialized HibernateException;

    default public @UnknownKeyFor @NonNull @Initialized int prepare(@UnknownKeyFor @NonNull @Initialized PreparedStatement statement) throws @UnknownKeyFor @NonNull @Initialized SQLException, @UnknownKeyFor @NonNull @Initialized HibernateException {
        return 0;
    }

    default public void validate(@UnknownKeyFor @NonNull @Initialized boolean callable) throws @UnknownKeyFor @NonNull @Initialized MappingException {
    }

    public static class OutParameter
    implements Expectation {
        @Override
        public final void verifyOutcome(@UnknownKeyFor @NonNull @Initialized int rowCount, @UnknownKeyFor @NonNull @Initialized PreparedStatement statement, @UnknownKeyFor @NonNull @Initialized int batchPosition, @UnknownKeyFor @NonNull @Initialized String sql) {
            int result;
            try {
                result = Expectations.toCallableStatement(statement).getInt(this.parameterIndex());
            }
            catch (SQLException sqle) {
                Expectations.sqlExceptionHelper.logExceptions(sqle, "Could not extract row count from CallableStatement");
                throw new GenericJDBCException("Could not extract row count from CallableStatement", sqle);
            }
            if (batchPosition < 0) {
                Expectations.checkNonBatched(this.expectedRowCount(), result, sql);
            } else {
                Expectations.checkBatched(this.expectedRowCount(), result, batchPosition, sql);
            }
        }

        @Override
        public void validate(@UnknownKeyFor @NonNull @Initialized boolean callable) throws @UnknownKeyFor @NonNull @Initialized MappingException {
            if (!callable) {
                throw new MappingException("Expectation.OutParameter operates exclusively on CallableStatements");
            }
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized int getNumberOfParametersUsed() {
            return 1;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized int prepare(@UnknownKeyFor @NonNull @Initialized PreparedStatement statement) throws @UnknownKeyFor @NonNull @Initialized SQLException, @UnknownKeyFor @NonNull @Initialized HibernateException {
            Expectations.toCallableStatement(statement).registerOutParameter(this.parameterIndex(), 2);
            return 1;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean canBeBatched() {
            return false;
        }

        protected @UnknownKeyFor @NonNull @Initialized int parameterIndex() {
            return 1;
        }

        protected @UnknownKeyFor @NonNull @Initialized int expectedRowCount() {
            return 1;
        }
    }

    public static class RowCount
    implements Expectation {
        @Override
        public final void verifyOutcome(@UnknownKeyFor @NonNull @Initialized int rowCount, @UnknownKeyFor @NonNull @Initialized PreparedStatement statement, @UnknownKeyFor @NonNull @Initialized int batchPosition, @UnknownKeyFor @NonNull @Initialized String sql) {
            if (batchPosition < 0) {
                Expectations.checkNonBatched(this.expectedRowCount(), rowCount, sql);
            } else {
                Expectations.checkBatched(this.expectedRowCount(), rowCount, batchPosition, sql);
            }
        }

        protected @UnknownKeyFor @NonNull @Initialized int expectedRowCount() {
            return 1;
        }
    }

    public static class None
    implements Expectation {
        public static final @UnknownKeyFor @NonNull @Initialized None INSTANCE = new None();

        @Override
        public void verifyOutcome(@UnknownKeyFor @NonNull @Initialized int rowCount, @UnknownKeyFor @NonNull @Initialized PreparedStatement statement, @UnknownKeyFor @NonNull @Initialized int batchPosition, @UnknownKeyFor @NonNull @Initialized String sql) {
        }
    }
}

