/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.HibernateException;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.internal.LoaderSqlAstCreationState;
import org.hibernate.loader.ast.internal.NoCallbackExecutionContext;
import org.hibernate.loader.ast.spi.Loadable;
import org.hibernate.loader.ast.spi.NaturalIdLoadOptions;
import org.hibernate.loader.ast.spi.NaturalIdLoader;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.NaturalIdMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.query.internal.SimpleQueryOptions;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SimpleFromClauseAccessImpl;
import org.hibernate.sql.ast.spi.SqlAliasBaseManager;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.BaseExecutionContext;
import org.hibernate.sql.exec.internal.CallbackImpl;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.Callback;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBinding;
import org.hibernate.sql.exec.spi.JdbcParametersList;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.internal.ImmutableFetchList;
import org.hibernate.sql.results.internal.RowTransformerSingularReturnImpl;
import org.hibernate.sql.results.spi.ListResultsConsumer;

public abstract class AbstractNaturalIdLoader<T>
implements NaturalIdLoader<T> {
    private final NaturalIdMapping naturalIdMapping;
    private final EntityMappingType entityDescriptor;

    public AbstractNaturalIdLoader(NaturalIdMapping naturalIdMapping, EntityMappingType entityDescriptor) {
        this.naturalIdMapping = naturalIdMapping;
        this.entityDescriptor = entityDescriptor;
    }

    protected EntityMappingType entityDescriptor() {
        return this.entityDescriptor;
    }

    protected NaturalIdMapping naturalIdMapping() {
        return this.naturalIdMapping;
    }

    @Override
    public EntityMappingType getLoadable() {
        return this.entityDescriptor();
    }

    @Override
    public T load(Object naturalIdValue, NaturalIdLoadOptions options, SharedSessionContractImplementor session) {
        T result;
        SessionFactoryImplementor factory = session.getFactory();
        LockOptions lockOptions = options.getLockOptions() == null ? LockOptions.NONE : options.getLockOptions();
        SelectStatement sqlSelect = LoaderSelectBuilder.createSelect(this.getLoadable(), null, true, Collections.emptyList(), null, 1, session.getLoadQueryInfluencers(), lockOptions, JdbcParametersList.newBuilder()::add, factory);
        JdbcParameterBindingsImpl bindings = new JdbcParameterBindingsImpl(this.naturalIdMapping.getJdbcTypeCount());
        this.applyNaturalIdRestriction(this.naturalIdMapping().normalizeInput(naturalIdValue), sqlSelect.getQuerySpec().getFromClause().getRoots().get(0), sqlSelect.getQuerySpec()::applyPredicate, bindings::addBinding, new LoaderSqlAstCreationState(sqlSelect.getQuerySpec(), new SqlAliasBaseManager(), new SimpleFromClauseAccessImpl(), lockOptions, (fetchParent, creationState) -> ImmutableFetchList.EMPTY, true, new LoadQueryInfluencers(factory), factory.getSqlTranslationEngine()), session);
        SimpleQueryOptions queryOptions = new SimpleQueryOptions(lockOptions, false);
        JdbcOperationQuerySelect jdbcSelect = factory.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory().buildSelectTranslator(factory, sqlSelect).translate(bindings, queryOptions);
        long startToken = factory.getStatistics().isStatisticsEnabled() ? System.nanoTime() : -1L;
        List results = session.getFactory().getJdbcServices().getJdbcSelectExecutor().list(jdbcSelect, bindings, new NaturalIdLoaderWithOptionsExecutionContext(session, queryOptions), RowTransformerSingularReturnImpl.instance(), null, ListResultsConsumer.UniqueSemantic.FILTER, 1);
        if (results.size() > 1) {
            throw new HibernateException(String.format("Loading by natural-id returned more that one row : %s", this.entityDescriptor.getEntityName()));
        }
        T t = result = results.isEmpty() ? null : (T)results.get(0);
        if (startToken > 0L) {
            session.getFactory().getStatistics().naturalIdQueryExecuted(this.entityDescriptor().getEntityPersister().getRootEntityName(), System.nanoTime() - startToken);
        }
        return result;
    }

    protected <L> L selectByNaturalId(Object bindValue, NaturalIdLoadOptions options, BiFunction<TableGroup, LoaderSqlAstCreationState, DomainResult<?>> domainResultProducer, LoaderSqlAstCreationState.FetchProcessor fetchProcessor, Function<Boolean, Long> statementStartHandler, BiConsumer<Object, Long> statementCompletionHandler, SharedSessionContractImplementor session) {
        SessionFactoryImplementor factory = session.getFactory();
        LockOptions lockOptions = options.getLockOptions() != null ? options.getLockOptions() : LockOptions.NONE;
        NavigablePath entityPath = new NavigablePath(this.entityDescriptor.getRootPathName());
        QuerySpec rootQuerySpec = new QuerySpec(true);
        LoaderSqlAstCreationState sqlAstCreationState = new LoaderSqlAstCreationState(rootQuerySpec, new SqlAliasBaseManager(), new SimpleFromClauseAccessImpl(), lockOptions, fetchProcessor, true, new LoadQueryInfluencers(factory), factory.getSqlTranslationEngine());
        TableGroup rootTableGroup = this.entityDescriptor.createRootTableGroup(true, entityPath, null, null, () -> rootQuerySpec::applyPredicate, sqlAstCreationState);
        rootQuerySpec.getFromClause().addRoot(rootTableGroup);
        sqlAstCreationState.getFromClauseAccess().registerTableGroup(entityPath, rootTableGroup);
        DomainResult<?> domainResult = domainResultProducer.apply(rootTableGroup, sqlAstCreationState);
        SelectStatement sqlSelect = new SelectStatement(rootQuerySpec, Collections.singletonList(domainResult));
        JdbcParameterBindingsImpl bindings = new JdbcParameterBindingsImpl(this.naturalIdMapping.getJdbcTypeCount());
        this.applyNaturalIdRestriction(bindValue, rootTableGroup, rootQuerySpec::applyPredicate, bindings::addBinding, sqlAstCreationState, session);
        SimpleQueryOptions queryOptions = new SimpleQueryOptions(lockOptions, false);
        JdbcOperationQuerySelect jdbcSelect = factory.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory().buildSelectTranslator(factory, sqlSelect).translate(bindings, queryOptions);
        Long startToken = statementStartHandler.apply(factory.getStatistics().isStatisticsEnabled());
        List results = factory.getJdbcServices().getJdbcSelectExecutor().list(jdbcSelect, bindings, new NaturalIdLoaderWithOptionsExecutionContext(session, queryOptions), RowTransformerSingularReturnImpl.instance(), null, ListResultsConsumer.UniqueSemantic.FILTER, 1);
        if (results.size() > 1) {
            throw new HibernateException(String.format("Loading by natural-id returned more that one row : %s", this.entityDescriptor.getEntityName()));
        }
        L result = results.isEmpty() ? null : (L)results.get(0);
        statementCompletionHandler.accept(result, startToken);
        return result;
    }

    protected abstract void applyNaturalIdRestriction(Object var1, TableGroup var2, Consumer<Predicate> var3, BiConsumer<JdbcParameter, JdbcParameterBinding> var4, LoaderSqlAstCreationState var5, SharedSessionContractImplementor var6);

    protected Expression resolveColumnReference(TableGroup rootTableGroup, SelectableMapping selectableMapping, SqlExpressionResolver sqlExpressionResolver, SessionFactoryImplementor sessionFactory) {
        TableReference tableReference = rootTableGroup.getTableReference(rootTableGroup.getNavigablePath(), selectableMapping.getContainingTableExpression());
        if (tableReference == null) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Unable to locate TableReference for `%s` : %s", selectableMapping.getContainingTableExpression(), rootTableGroup));
        }
        return sqlExpressionResolver.resolveSqlExpression(tableReference, selectableMapping);
    }

    @Override
    public Object resolveNaturalIdToId(Object naturalIdValue, SharedSessionContractImplementor session) {
        return this.selectByNaturalId(this.naturalIdMapping().normalizeInput(naturalIdValue), NaturalIdLoadOptions.NONE, (tableGroup, creationState) -> this.entityDescriptor.getIdentifierMapping().createDomainResult(tableGroup.getNavigablePath().append("{id}"), (TableGroup)tableGroup, null, (DomainResultCreationState)creationState), (fetchParent, creationState) -> ImmutableFetchList.EMPTY, statsEnabled -> statsEnabled != false ? System.nanoTime() : -1L, (result, startToken) -> {
            if (startToken > 0L) {
                session.getFactory().getStatistics().naturalIdQueryExecuted(this.entityDescriptor().getEntityPersister().getRootEntityName(), System.nanoTime() - startToken);
            }
        }, session);
    }

    @Override
    public Object resolveIdToNaturalId(Object id, SharedSessionContractImplementor session) {
        SessionFactoryImplementor factory = session.getFactory();
        JdbcParametersList.Builder builder = JdbcParametersList.newBuilder();
        SelectStatement sqlSelect = LoaderSelectBuilder.createSelect((Loadable)this.entityDescriptor(), Collections.singletonList(this.naturalIdMapping()), this.entityDescriptor().getIdentifierMapping(), null, 1, session.getLoadQueryInfluencers(), LockOptions.NONE, builder::add, factory);
        JdbcParametersList jdbcParameters = builder.build();
        JdbcParameterBindingsImpl bindings = new JdbcParameterBindingsImpl(jdbcParameters.size());
        int offset = bindings.registerParametersForEachJdbcValue(id, this.entityDescriptor().getIdentifierMapping(), jdbcParameters, session);
        assert (offset == jdbcParameters.size());
        JdbcOperationQuerySelect jdbcSelect = factory.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory().buildSelectTranslator(factory, sqlSelect).translate(bindings, QueryOptions.NONE);
        List results = factory.getJdbcServices().getJdbcSelectExecutor().list(jdbcSelect, bindings, new NoCallbackExecutionContext(session), RowTransformerSingularReturnImpl.instance(), null, ListResultsConsumer.UniqueSemantic.FILTER, 1);
        return switch (results.size()) {
            case 0 -> null;
            case 1 -> results.get(0);
            default -> throw new HibernateException(String.format("Resolving id to natural-id returned more that one row : %s #%s", this.entityDescriptor().getEntityName(), id));
        };
    }

    private static class NaturalIdLoaderWithOptionsExecutionContext
    extends BaseExecutionContext {
        private final Callback callback;
        private final QueryOptions queryOptions;

        public NaturalIdLoaderWithOptionsExecutionContext(SharedSessionContractImplementor session, QueryOptions queryOptions) {
            super(session);
            this.queryOptions = queryOptions;
            this.callback = new CallbackImpl();
        }

        @Override
        public QueryOptions getQueryOptions() {
            return this.queryOptions;
        }

        @Override
        public Callback getCallback() {
            return this.callback;
        }
    }
}

