/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.lang.reflect.Array;
import java.util.List;
import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.ObjectDeletedException;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.event.monitor.spi.DiagnosticEvent;
import org.hibernate.event.monitor.spi.EventMonitor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.internal.OptimisticLockHelper;
import org.hibernate.internal.build.AllowReflection;
import org.hibernate.loader.LoaderLogging;
import org.hibernate.loader.ast.internal.SingleIdExecutionContext;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingImpl;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParametersList;
import org.hibernate.sql.results.internal.RowTransformerStandardImpl;
import org.hibernate.sql.results.spi.ListResultsConsumer;
import org.hibernate.type.descriptor.java.JavaType;

public class LoaderHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void upgradeLock(Object object, EntityEntry entry, LockOptions lockOptions, SharedSessionContractImplementor session) {
        LockMode requestedLockMode = lockOptions.getLockMode();
        if (!requestedLockMode.greaterThan(entry.getLockMode())) return;
        EntityPersister persister = entry.getPersister();
        if (entry.getStatus().isDeletedOrGone()) {
            throw new ObjectDeletedException("attempted to lock a deleted instance", entry.getId(), persister.getEntityName());
        }
        if (LoaderLogging.LOADER_LOGGER.isTraceEnabled()) {
            LoaderLogging.LOADER_LOGGER.tracef("Locking `%s( %s )` in `%s` lock-mode", (Object)persister.getEntityName(), entry.getId(), (Object)requestedLockMode);
        }
        boolean cachingEnabled = persister.canWriteToCache();
        SoftLock lock = null;
        Object ck = null;
        try {
            if (cachingEnabled) {
                EntityDataAccess cache = persister.getCacheAccessStrategy();
                ck = cache.generateCacheKey(entry.getId(), persister, session.getFactory(), session.getTenantIdentifier());
                lock = cache.lockItem(session, ck, entry.getVersion());
            }
            if (persister.isVersioned() && entry.getVersion() == null) {
                if (Hibernate.isPropertyInitialized(object, persister.getVersionMapping().getPartName())) throw new IllegalStateException(String.format("Trying to lock versioned entity %s but found null version", MessageHelper.infoString(persister.getEntityName(), entry.getId())));
                Hibernate.initialize(object);
                entry = session.getPersistenceContextInternal().getEntry(object);
                assert (entry.getVersion() != null);
            }
            if (persister.isVersioned() && requestedLockMode == LockMode.PESSIMISTIC_FORCE_INCREMENT) {
                OptimisticLockHelper.forceVersionIncrement(object, entry, session);
            } else if (entry.isExistsInDatabase()) {
                EventMonitor eventMonitor = session.getEventMonitor();
                DiagnosticEvent entityLockEvent = eventMonitor.beginEntityLockEvent();
                boolean success = false;
                try {
                    persister.lock(entry.getId(), entry.getVersion(), object, lockOptions, session);
                    success = true;
                }
                finally {
                    eventMonitor.completeEntityLockEvent(entityLockEvent, entry.getId(), persister.getEntityName(), lockOptions.getLockMode(), success, session);
                }
            } else if (session instanceof EventSource) {
                EventSource eventSource = (EventSource)session;
                eventSource.forceFlush(entry);
            }
            entry.setLockMode(requestedLockMode);
            if (!cachingEnabled) return;
        }
        catch (Throwable throwable) {
            if (!cachingEnabled) throw throwable;
            persister.getCacheAccessStrategy().unlockItem(session, ck, lock);
            throw throwable;
        }
        persister.getCacheAccessStrategy().unlockItem(session, ck, lock);
    }

    public static Boolean getReadOnlyFromLoadQueryInfluencers(SharedSessionContractImplementor session) {
        return LoaderHelper.getReadOnlyFromLoadQueryInfluencers(session.getLoadQueryInfluencers());
    }

    public static Boolean getReadOnlyFromLoadQueryInfluencers(LoadQueryInfluencers influencers) {
        return influencers == null ? null : influencers.getReadOnly();
    }

    public static <K> K[] normalizeKeys(K[] keys, BasicValuedModelPart keyPart, SharedSessionContractImplementor session, SessionFactoryImplementor sessionFactory) {
        boolean coerce;
        assert (keys.getClass().isArray());
        JavaType<?> keyJavaType = keyPart.getJavaType();
        Class<?> keyClass = keyJavaType.getJavaTypeClass();
        if (keys.getClass().getComponentType().equals(keyClass)) {
            return keys;
        }
        ?[] typedArray = LoaderHelper.createTypedArray(keyClass, keys.length);
        boolean bl = coerce = !sessionFactory.getSessionFactoryOptions().getJpaCompliance().isLoadByIdComplianceEnabled();
        if (!coerce) {
            System.arraycopy(keys, 0, typedArray, 0, keys.length);
        } else {
            for (int i = 0; i < keys.length; ++i) {
                typedArray[i] = keyJavaType.coerce(keys[i], session);
            }
        }
        return typedArray;
    }

    @AllowReflection
    public static <X> X[] createTypedArray(Class<X> elementClass, int length) {
        return (Object[])Array.newInstance(elementClass, length);
    }

    public static <R, K> List<R> loadByArrayParameter(K[] idsToInitialize, SelectStatement sqlAst, JdbcOperationQuerySelect jdbcOperation, JdbcParameter jdbcParameter, JdbcMapping arrayJdbcMapping, Object entityId, Object entityInstance, EntityMappingType rootEntityDescriptor, LockOptions lockOptions, Boolean readOnly, SharedSessionContractImplementor session) {
        assert (jdbcOperation != null);
        assert (jdbcParameter != null);
        JdbcParameterBindingsImpl bindings = new JdbcParameterBindingsImpl(1);
        bindings.addBinding(jdbcParameter, new JdbcParameterBindingImpl(arrayJdbcMapping, idsToInitialize));
        return session.getJdbcServices().getJdbcSelectExecutor().list(jdbcOperation, bindings, new SingleIdExecutionContext(entityId, entityInstance, rootEntityDescriptor, readOnly, lockOptions, SubselectFetch.createRegistrationHandler(session.getPersistenceContext().getBatchFetchQueue(), sqlAst, JdbcParametersList.singleton(jdbcParameter), bindings), session), RowTransformerStandardImpl.instance(), null, ListResultsConsumer.UniqueSemantic.FILTER, idsToInitialize.length);
    }
}

